/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractSampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class ChannelSampleModel
extends AbstractSampleModel {
    private final SampleModel sm;
    private final int ci;
    private final int nc;
    private final boolean closeModel;

    public ChannelSampleModel(SampleModel model, int channel, boolean closeModel) {
        super(1, model.getFrameRate());
        this.closeModel = closeModel;
        this.sm = model;
        this.ci = channel;
        this.nc = model.getChannels();
        if (this.ci < 0) {
            throw new IllegalArgumentException("Invalid channel index: " + this.ci + " < 0");
        }
        if (this.ci >= this.nc) {
            throw new IllegalArgumentException("Invalid channel index: " + this.ci + " >= " + this.nc);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.sm.isReadOnly();
    }

    @Override
    public boolean isEmpty() {
        return this.sm.getSamples() < 1L;
    }

    @Override
    public long getSamples() {
        return this.sm.getSamples() / (long)this.nc;
    }

    @Override
    public float getFloat(long i) throws IOException {
        return this.sm.getFloat(i * (long)this.nc + (long)this.ci);
    }

    @Override
    public double getDouble(long i) throws IOException {
        return this.sm.getDouble(i * (long)this.nc + (long)this.ci);
    }

    @Override
    public void get(long i, double[] dst, int off, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        int end = off + len;
        while (off < end) {
            dst[off++] = this.sm.getDouble(x);
            x += (long)this.nc;
        }
    }

    @Override
    public void get(long i, float[] dst, int off, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        int end = off + len;
        while (off < end) {
            dst[off++] = this.sm.getFloat(x);
            x += (long)this.nc;
        }
    }

    @Override
    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        while (len-- > 0) {
            dst.put(this.sm.getDouble(x));
            x += (long)this.nc;
        }
    }

    @Override
    public void get(long i, FloatBuffer dst, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        while (len-- > 0) {
            dst.put(this.sm.getFloat(x));
            x += (long)this.nc;
        }
    }

    @Override
    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        int end = off + len;
        while (off < end) {
            dst.set(off++, this.sm.getDouble(x));
            x += (long)this.nc;
        }
    }

    @Override
    public void set(long i, float v) throws IOException {
        this.sm.set(i * (long)this.nc + (long)this.ci, v);
    }

    @Override
    public void set(long i, double v) throws IOException {
        this.sm.set(i * (long)this.nc + (long)this.ci, v);
    }

    @Override
    public void set(long i, double[] src, int off, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        int end = off + len;
        while (off < end) {
            this.sm.set(x, src[off++]);
            x += (long)this.nc;
        }
    }

    @Override
    public void set(long i, float[] src, int off, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        int end = off + len;
        while (off < end) {
            this.sm.set(x, src[off++]);
            x += (long)this.nc;
        }
    }

    @Override
    public void set(long i, FloatBuffer src, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        while (len-- > 0) {
            this.sm.set(x, src.get());
            x += (long)this.nc;
        }
    }

    @Override
    public void set(long i, DoubleBuffer src, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        while (len-- > 0) {
            this.sm.set(x, src.get());
            x += (long)this.nc;
        }
    }

    @Override
    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        int end = off + len;
        while (off < end) {
            this.sm.set(x, src.getDouble(off++));
            x += (long)this.nc;
        }
    }

    @Override
    public void clear(long i, int len) throws IOException {
        long x = i * (long)this.nc + (long)this.ci;
        while (len-- > 0) {
            this.sm.set(x, 0.0);
            x += (long)this.nc;
        }
    }

    @Override
    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
        this.sm.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closeModel) {
            this.sm.close();
        }
    }
}

