/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractSampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class CubicInterpolatedSampleModel
extends AbstractSampleModel {
    private final SampleModel sm;
    private final double x;
    private final double[] da;
    private final boolean closeModel;

    public CubicInterpolatedSampleModel(float frameRate, SampleModel model, boolean closeModel) {
        super(1, frameRate);
        this.sm = model;
        this.closeModel = closeModel;
        this.da = new double[4];
        int chs = this.sm.getChannels();
        if (chs != 1) {
            throw new IllegalArgumentException("Invalid number of channels: " + chs + " != 1");
        }
        this.x = this.sm.getFrameRate() / frameRate;
    }

    protected double get(double p) throws IOException {
        long i = (long)(p *= this.x);
        if (i > 0L) {
            this.sm.get(i - 1L, this.da, 0, 4);
        } else if (i == 0L) {
            this.da[0] = 0.0;
            this.sm.get(i, this.da, 1, 3);
        } else {
            return 0.0;
        }
        double s0 = this.da[0];
        double s1 = this.da[1];
        double s2 = this.da[2];
        double s3 = this.da[3];
        double f = p - (double)i;
        double f2 = f * f;
        double a = s3 - s2 - s0 + s1;
        double b = s0 - s1 - a;
        double c = s2 - s0;
        return a * f * f2 + b * f2 + c * f + s1;
    }

    @Override
    public long getSamples() {
        long samples = this.sm.getSamples();
        long destSamples = (long)((double)(samples - 4L) / this.x);
        if (destSamples < 0L) {
            destSamples = 0L;
        }
        return destSamples;
    }

    @Override
    public boolean isEmpty() {
        return this.getSamples() < 1L;
    }

    @Override
    public double getDouble(long i) throws IOException {
        return this.get(i);
    }

    @Override
    public float getFloat(long i) throws IOException {
        return (float)this.get(i);
    }

    @Override
    public void get(long i, double[] dst, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            dst[off++] = this.get(i++);
        }
    }

    @Override
    public void get(long i, float[] dst, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            dst[off++] = (float)this.get(i++);
        }
    }

    @Override
    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        for (int k = 0; k < len; ++k) {
            dst.put(this.get(i++));
        }
    }

    @Override
    public void get(long i, FloatBuffer dst, int len) throws IOException {
        for (int k = 0; k < len; ++k) {
            dst.put((float)this.get(i++));
        }
    }

    @Override
    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            dst.set(off++, this.get(i++));
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.closeModel) {
            this.sm.close();
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void set(long i, float v) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, double v) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }
}

