/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleCursor;
import com.spacekiller.util.sound.SampleModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class DefaultSampleCursor
implements SampleCursor {
    private static final long CLOSED = -4611686018427387904L;
    private final SampleModel model;
    private long i;

    public DefaultSampleCursor(SampleModel model, long sampleIndex) {
        this.model = model;
        this.i = sampleIndex;
    }

    public DefaultSampleCursor(SampleModel model) {
        this(model, 0L);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public int getChannels() {
        return this.model.getChannels();
    }

    @Override
    public float getFrameRate() {
        return this.model.getFrameRate();
    }

    @Override
    public long getSamples() {
        return this.model.getSamples();
    }

    @Override
    public long getPosition() {
        return this.i;
    }

    @Override
    public void move(int n) {
        this.i += (long)n;
    }

    @Override
    public void close() {
        this.i = -4611686018427387904L;
    }

    @Override
    public void flush() {
    }

    @Override
    public void get(double[] dst, int off, int len) {
        try {
            this.model.get(this.i, dst, off, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void get(float[] dst, int off, int len) {
        try {
            this.model.get(this.i, dst, off, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void get(SampleBuffer dst, int off, int len) {
        try {
            this.model.get(this.i, dst, off, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void get(DoubleBuffer dst, int len) {
        try {
            this.model.get(this.i, dst, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void get(FloatBuffer dst, int len) {
        try {
            this.model.get(this.i, dst, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(double[] src, int off, int len) {
        try {
            this.model.set(this.i, src, off, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(float[] src, int off, int len) {
        try {
            this.model.set(this.i, src, off, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(SampleBuffer src, int off, int len) {
        try {
            this.model.set(this.i, src, off, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(DoubleBuffer src, int len) {
        try {
            this.model.set(this.i, src, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(FloatBuffer src, int len) {
        try {
            this.model.set(this.i, src, len);
            this.i += (long)len;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

