/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractSampleBuffer;
import com.spacekiller.util.sound.RingSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class DoubleArrayRingSampleBuffer
extends AbstractSampleBuffer
implements RingSampleBuffer {
    private final double[] arr;
    private int o;

    public DoubleArrayRingSampleBuffer(int channels, int samples, float frameRate, double[] arr) {
        super(channels, samples, frameRate);
        this.arr = arr;
    }

    public DoubleArrayRingSampleBuffer(int channels, int samples, float frameRate, double[] arr, int ofs) {
        this(channels, samples, frameRate, arr);
        this.o = ofs;
    }

    public final double[] array() {
        return this.arr;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public double getDouble(int i) {
        return this.arr[(this.o + i) % this.samples];
    }

    @Override
    public float getFloat(int i) {
        return (float)this.arr[(this.o + i) % this.samples];
    }

    @Override
    public void set(int i, double v) {
        this.arr[(this.o + i) % this.samples] = v;
    }

    @Override
    public void set(int i, float v) {
        this.arr[(this.o + i) % this.samples] = v;
    }

    @Override
    public void add(int i, double v) {
        int n = (this.o + i) % this.samples;
        this.arr[n] = this.arr[n] + v;
    }

    @Override
    public void add(int i, float v) {
        int n = (this.o + i) % this.samples;
        this.arr[n] = this.arr[n] + (double)v;
    }

    @Override
    public void clear(int i, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            Arrays.fill(this.arr, i, i + len, 0.0);
        } else {
            Arrays.fill(this.arr, i, this.samples, 0.0);
            Arrays.fill(this.arr, 0, i + len - this.samples, 0.0);
        }
    }

    @Override
    public void fill(int i, int len, double v) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            Arrays.fill(this.arr, i, i + len, v);
        } else {
            Arrays.fill(this.arr, i, this.samples, v);
            Arrays.fill(this.arr, 0, i + len - this.samples, v);
        }
    }

    @Override
    public void fill(int i, int len, float v) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            Arrays.fill(this.arr, i, i + len, (double)v);
        } else {
            Arrays.fill(this.arr, i, this.samples, (double)v);
            Arrays.fill(this.arr, 0, i + len - this.samples, (double)v);
        }
    }

    @Override
    public void get(int i, double[] dst, int off, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            System.arraycopy(this.arr, i, dst, off, len);
        } else {
            int n = this.samples - i;
            System.arraycopy(this.arr, i, dst, off, n);
            System.arraycopy(this.arr, 0, dst, off + n, len - n);
        }
    }

    @Override
    public void set(int i, double[] src, int off, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            System.arraycopy(src, off, this.arr, i, len);
        } else {
            int n = this.samples - i;
            System.arraycopy(src, off, this.arr, i, n);
            System.arraycopy(src, off + n, this.arr, 0, len - n);
        }
    }

    @Override
    public void get(int i, DoubleBuffer dst, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            dst.put(this.arr, i, len);
        } else {
            int n = this.samples - i;
            dst.put(this.arr, i, n);
            dst.put(this.arr, 0, len - n);
        }
    }

    @Override
    public void set(int i, DoubleBuffer src, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            src.get(this.arr, i, len);
        } else {
            int n = this.samples - i;
            src.get(this.arr, i, n);
            src.get(this.arr, 0, len - n);
        }
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            src.get(off, this.arr, i, len);
        } else {
            int n = this.samples - i;
            src.get(off, this.arr, i, n);
            src.get(off + n, this.arr, 0, len - n);
        }
    }

    @Override
    public void get(int i, float[] dst, int off, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            while (i < z) {
                dst[off++] = (float)this.arr[i++];
            }
        } else {
            int n = i + len - this.samples;
            while (i < this.samples) {
                dst[off++] = (float)this.arr[i++];
            }
            i = 0;
            while (i < n) {
                dst[off++] = (float)this.arr[i++];
            }
        }
    }

    @Override
    public void set(int i, float[] src, int off, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            while (i < z) {
                this.arr[i++] = src[off++];
            }
        } else {
            int n = i + len - this.samples;
            while (i < this.samples) {
                this.arr[i++] = src[off++];
            }
            i = 0;
            while (i < n) {
                this.arr[i++] = src[off++];
            }
        }
    }

    @Override
    public void get(int i, FloatBuffer dst, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            while (i < z) {
                dst.put((float)this.arr[i++]);
            }
        } else {
            int n = i + len - this.samples;
            while (i < this.samples) {
                dst.put((float)this.arr[i++]);
            }
            i = 0;
            while (i < n) {
                dst.put((float)this.arr[i++]);
            }
        }
    }

    @Override
    public void set(int i, FloatBuffer src, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            while (i < z) {
                this.arr[i++] = src.get();
            }
        } else {
            int n = i + len - this.samples;
            while (i < this.samples) {
                this.arr[i++] = src.get();
            }
            i = 0;
            while (i < n) {
                this.arr[i++] = src.get();
            }
        }
    }

    @Override
    public void add(int i, double[] src, int off, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            while (i < z) {
                int n = i++;
                this.arr[n] = this.arr[n] + src[off++];
            }
        } else {
            int n = i + len - this.samples;
            while (i < this.samples) {
                int n2 = i++;
                this.arr[n2] = this.arr[n2] + src[off++];
            }
            i = 0;
            while (i < n) {
                int n3 = i++;
                this.arr[n3] = this.arr[n3] + src[off++];
            }
        }
    }

    @Override
    public void add(int i, float[] src, int off, int len) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            while (i < z) {
                int n = i++;
                this.arr[n] = this.arr[n] + (double)src[off++];
            }
        } else {
            int n = i + len - this.samples;
            while (i < this.samples) {
                int n2 = i++;
                this.arr[n2] = this.arr[n2] + (double)src[off++];
            }
            i = 0;
            while (i < n) {
                int n3 = i++;
                this.arr[n3] = this.arr[n3] + (double)src[off++];
            }
        }
    }

    @Override
    public void multiply(int i, int len, double v) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            while (i < z) {
                int n = i++;
                this.arr[n] = this.arr[n] * v;
            }
        } else {
            int n = i + len - this.samples;
            while (i < this.samples) {
                int n2 = i++;
                this.arr[n2] = this.arr[n2] * v;
            }
            i = 0;
            while (i < n) {
                int n3 = i++;
                this.arr[n3] = this.arr[n3] * v;
            }
        }
    }

    @Override
    public void multiply(int i, int len, float v) {
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            while (i < z) {
                int n = i++;
                this.arr[n] = this.arr[n] * (double)v;
            }
        } else {
            int n = i + len - this.samples;
            while (i < this.samples) {
                int n2 = i++;
                this.arr[n2] = this.arr[n2] * (double)v;
            }
            i = 0;
            while (i < n) {
                int n3 = i++;
                this.arr[n3] = this.arr[n3] * (double)v;
            }
        }
    }

    @Override
    public double maxDouble(int i, int len) {
        if (len < 1) {
            return Double.NaN;
        }
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            double r = this.arr[i++];
            while (i < z) {
                if (this.arr[i] > r) {
                    r = this.arr[i];
                }
                ++i;
            }
            return r;
        }
        int n = i + len - this.samples;
        double r = this.arr[i++];
        while (i < this.samples) {
            if (this.arr[i] > r) {
                r = this.arr[i];
            }
            ++i;
        }
        for (i = 0; i < n; ++i) {
            if (!(this.arr[i] > r)) continue;
            r = this.arr[i];
        }
        return r;
    }

    @Override
    public double minDouble(int i, int len) {
        if (len < 1) {
            return Double.NaN;
        }
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            double r = this.arr[i++];
            while (i < z) {
                if (this.arr[i] < r) {
                    r = this.arr[i];
                }
                ++i;
            }
            return r;
        }
        int n = i + len - this.samples;
        double r = this.arr[i++];
        while (i < this.samples) {
            if (this.arr[i] < r) {
                r = this.arr[i];
            }
            ++i;
        }
        for (i = 0; i < n; ++i) {
            if (!(this.arr[i] < r)) continue;
            r = this.arr[i];
        }
        return r;
    }

    @Override
    public float maxFloat(int i, int len) {
        if (len < 1) {
            return Float.NaN;
        }
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            double r = this.arr[i++];
            while (i < z) {
                if (this.arr[i] > r) {
                    r = this.arr[i];
                }
                ++i;
            }
            return (float)r;
        }
        int n = i + len - this.samples;
        double r = this.arr[i++];
        while (i < this.samples) {
            if (this.arr[i] > r) {
                r = this.arr[i];
            }
            ++i;
        }
        for (i = 0; i < n; ++i) {
            if (!(this.arr[i] > r)) continue;
            r = this.arr[i];
        }
        return (float)r;
    }

    @Override
    public float minFloat(int i, int len) {
        if (len < 1) {
            return Float.NaN;
        }
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            double r = this.arr[i++];
            while (i < z) {
                if (this.arr[i] < r) {
                    r = this.arr[i];
                }
                ++i;
            }
            return (float)r;
        }
        int n = i + len - this.samples;
        double r = this.arr[i++];
        while (i < this.samples) {
            if (this.arr[i] < r) {
                r = this.arr[i];
            }
            ++i;
        }
        for (i = 0; i < n; ++i) {
            if (!(this.arr[i] < r)) continue;
            r = this.arr[i];
        }
        return (float)r;
    }

    @Override
    public double peakDouble(int i, int len) {
        double max;
        double min;
        if (len < 1) {
            return Double.NaN;
        }
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            max = min = this.arr[i++];
            while (i < z) {
                double v = this.arr[i];
                if (v > max) {
                    max = v;
                } else if (v < min) {
                    min = v;
                }
                ++i;
            }
        } else {
            double v;
            int n = i + len - this.samples;
            max = min = this.arr[i++];
            while (i < this.samples) {
                v = this.arr[i];
                if (v > max) {
                    max = v;
                } else if (v < min) {
                    min = v;
                }
                ++i;
            }
            for (i = 0; i < n; ++i) {
                v = this.arr[i];
                if (v > max) {
                    max = v;
                    continue;
                }
                if (!(v < min)) continue;
                min = v;
            }
        }
        return Math.abs(min) > max ? min : max;
    }

    @Override
    public float peakFloat(int i, int len) {
        double max;
        double min;
        if (len < 1) {
            return Float.NaN;
        }
        if ((i = (this.o + i) % this.samples) + len <= this.samples) {
            int z = i + len;
            max = min = this.arr[i++];
            while (i < z) {
                double v = this.arr[i];
                if (v > max) {
                    max = v;
                } else if (v < min) {
                    min = v;
                }
                ++i;
            }
        } else {
            double v;
            int n = i + len - this.samples;
            max = min = this.arr[i++];
            while (i < this.samples) {
                v = this.arr[i];
                if (v > max) {
                    max = v;
                } else if (v < min) {
                    min = v;
                }
                ++i;
            }
            for (i = 0; i < n; ++i) {
                v = this.arr[i];
                if (v > max) {
                    max = v;
                    continue;
                }
                if (!(v < min)) continue;
                min = v;
            }
        }
        return Math.abs(min) > max ? (float)min : (float)max;
    }

    @Override
    public int ofs() {
        return this.o;
    }

    @Override
    public void ofs(int ofs) {
        this.o = ofs;
    }

    @Override
    public void skip(int len) {
        this.o = (this.o + len) % this.samples;
    }
}

