/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class DoubleArraySampleBuffer
extends AbstractSampleBuffer {
    protected final double[] arr;

    public DoubleArraySampleBuffer(int channels, int samples, float frameRate, double[] arr) {
        super(channels, samples, frameRate);
        this.arr = arr;
    }

    public final double[] array() {
        return this.arr;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public double getDouble(int i) {
        return this.arr[i];
    }

    @Override
    public float getFloat(int i) {
        return (float)this.arr[i];
    }

    @Override
    public void set(int i, double v) {
        this.arr[i] = v;
    }

    @Override
    public void set(int i, float v) {
        this.arr[i] = v;
    }

    @Override
    public void get(int i, double[] dst, int off, int len) {
        System.arraycopy(this.arr, i, dst, off, len);
    }

    @Override
    public void set(int i, double[] src, int off, int len) {
        System.arraycopy(src, off, this.arr, i, len);
    }

    @Override
    public void get(int i, DoubleBuffer dst, int len) {
        dst.put(this.arr, i, len);
    }

    @Override
    public void set(int i, DoubleBuffer src, int len) {
        src.get(this.arr, i, len);
    }

    @Override
    public void get(int i, float[] dst, int off, int len) {
        int z = i + len;
        while (i < z) {
            dst[off++] = (float)this.arr[i++];
        }
    }

    @Override
    public void set(int i, float[] src, int off, int len) {
        int z = i + len;
        while (i < z) {
            this.arr[i++] = src[off++];
        }
    }

    @Override
    public void get(int i, FloatBuffer dst, int len) {
        int z = i + len;
        while (i < z) {
            dst.put((float)this.arr[i++]);
        }
    }

    @Override
    public void set(int i, FloatBuffer src, int len) {
        int z = i + len;
        while (i < z) {
            this.arr[i++] = src.get();
        }
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        src.get(off, this.arr, i, len);
    }

    @Override
    public void add(int i, double v) {
        int n = i;
        this.arr[n] = this.arr[n] + v;
    }

    @Override
    public void add(int i, float v) {
        int n = i;
        this.arr[n] = this.arr[n] + (double)v;
    }

    @Override
    public void add(int i, double[] src, int off, int len) {
        int z = i + len;
        while (i < z) {
            int n = i++;
            this.arr[n] = this.arr[n] + src[off++];
        }
    }

    @Override
    public void add(int i, float[] src, int off, int len) {
        int z = i + len;
        while (i < z) {
            int n = i++;
            this.arr[n] = this.arr[n] + (double)src[off++];
        }
    }

    @Override
    public void clear(int i, int len) {
        Arrays.fill(this.arr, i, i + len, 0.0);
    }

    @Override
    public void fill(int i, int len, double v) {
        Arrays.fill(this.arr, i, i + len, v);
    }

    @Override
    public void fill(int i, int len, float v) {
        Arrays.fill(this.arr, i, i + len, (double)v);
    }

    @Override
    public void multiply(int i, int len, double v) {
        int z = i + len;
        while (i < z) {
            int n = i++;
            this.arr[n] = this.arr[n] * v;
        }
    }

    @Override
    public void multiply(int i, int len, float v) {
        int z = i + len;
        while (i < z) {
            int n = i++;
            this.arr[n] = this.arr[n] * (double)v;
        }
    }

    @Override
    public double minDouble(int i, int len) {
        if (len < 1) {
            return Double.NaN;
        }
        int z = i + len;
        double r = this.arr[i++];
        while (i < z) {
            if (this.arr[i] < r) {
                r = this.arr[i];
            }
            ++i;
        }
        return r;
    }

    @Override
    public float minFloat(int i, int len) {
        if (len < 1) {
            return Float.NaN;
        }
        int z = i + len;
        double r = this.arr[i++];
        while (i < z) {
            if (this.arr[i] < r) {
                r = this.arr[i];
            }
            ++i;
        }
        return (float)r;
    }

    @Override
    public double maxDouble(int i, int len) {
        if (len < 1) {
            return Double.NaN;
        }
        int z = i + len;
        double r = this.arr[i++];
        while (i < z) {
            if (this.arr[i] > r) {
                r = this.arr[i];
            }
            ++i;
        }
        return r;
    }

    @Override
    public float maxFloat(int i, int len) {
        if (len < 1) {
            return Float.NaN;
        }
        int z = i + len;
        double r = this.arr[i++];
        while (i < z) {
            if (this.arr[i] > r) {
                r = this.arr[i];
            }
            ++i;
        }
        return (float)r;
    }

    @Override
    public double peakDouble(int i, int len) {
        double min;
        if (len < 1) {
            return Double.NaN;
        }
        int z = i + len;
        double max = min = this.arr[i++];
        while (i < z) {
            double v = this.arr[i];
            if (v > max) {
                max = v;
            } else if (v < min) {
                min = v;
            }
            ++i;
        }
        return Math.abs(min) > max ? min : max;
    }

    @Override
    public float peakFloat(int i, int len) {
        double min;
        if (len < 1) {
            return Float.NaN;
        }
        int z = i + len;
        double max = min = this.arr[i++];
        while (i < z) {
            double v = this.arr[i];
            if (v > max) {
                max = v;
            } else if (v < min) {
                min = v;
            }
            ++i;
        }
        return Math.abs(min) > max ? (float)min : (float)max;
    }
}

