/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractSampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;

public class DoubleArraySampleModel
extends AbstractSampleModel {
    private volatile double[] arr;
    private volatile int num;

    public DoubleArraySampleModel(int channels, float frameRate, double[] arr, int samples) {
        super(channels, frameRate);
        this.arr = arr;
        this.num = samples;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.num < 1;
    }

    @Override
    public long getSamples() {
        return this.num;
    }

    @Override
    public double getDouble(long i) {
        return this.arr[(int)i];
    }

    @Override
    public float getFloat(long i) throws IOException {
        return (float)this.arr[(int)i];
    }

    @Override
    public void set(long i, double v) {
        this.arr[(int)i] = v;
    }

    @Override
    public void set(long i, float v) {
        this.arr[(int)i] = v;
    }

    @Override
    public void get(long i, double[] dst, int off, int len) {
        System.arraycopy(this.arr, (int)i, dst, off, len);
    }

    @Override
    public void set(long i, double[] src, int off, int len) {
        System.arraycopy(src, off, this.arr, (int)i, len);
    }

    @Override
    public void get(long i, DoubleBuffer dst, int len) {
        dst.put(this.arr, (int)i, len);
    }

    @Override
    public void set(long i, DoubleBuffer src, int len) {
        src.get(this.arr, (int)i, len);
    }

    @Override
    public void get(long i, float[] dst, int off, int len) {
        int x = (int)i;
        int z = x + len;
        while (x < z) {
            dst[off++] = (float)this.arr[x++];
        }
    }

    @Override
    public void set(long i, float[] src, int off, int len) {
        int x = (int)i;
        int z = x + len;
        while (x < z) {
            this.arr[x++] = src[off++];
        }
    }

    @Override
    public void get(long i, FloatBuffer dst, int len) {
        int x = (int)i;
        int z = x + len;
        while (x < z) {
            dst.put((float)this.arr[x++]);
        }
    }

    @Override
    public void set(long i, FloatBuffer src, int len) {
        int x = (int)i;
        int z = x + len;
        while (x < z) {
            this.arr[x++] = src.get();
        }
    }

    @Override
    public void get(long i, SampleBuffer dst, int off, int len) {
        dst.set(off, this.arr, (int)i, len);
    }

    @Override
    public void set(long i, SampleBuffer src, int off, int len) {
        src.get(off, this.arr, (int)i, len);
    }

    @Override
    public void clear(long i, int len) {
        int x = (int)i;
        Arrays.fill(this.arr, x, x + len, 0.0);
    }

    @Override
    public synchronized long append(int len) {
        int x = this.num;
        int z = x + len;
        if (z > this.arr.length) {
            this.resize(z);
        }
        this.num = z;
        return x;
    }

    @Override
    public synchronized long append(double[] src, int off, int len) {
        int x = this.num;
        int z = x + len;
        if (z > this.arr.length) {
            this.resize(z);
        }
        System.arraycopy(src, off, this.arr, this.num, len);
        this.num = z;
        return x;
    }

    @Override
    public synchronized long append(DoubleBuffer src, int len) {
        int x = this.num;
        int z = x + len;
        if (z > this.arr.length) {
            this.resize(z);
        }
        src.get(this.arr, this.num, len);
        this.num = z;
        return x;
    }

    @Override
    public synchronized long append(float[] src, int off, int len) {
        int x = this.num;
        int z = x + len;
        if (z > this.arr.length) {
            this.resize(z);
        }
        int i = x;
        while (i < z) {
            this.arr[i++] = src[off++];
        }
        this.num = z;
        return x;
    }

    @Override
    public synchronized long append(FloatBuffer src, int len) {
        int x = this.num;
        int z = x + len;
        if (z > this.arr.length) {
            this.resize(z);
        }
        int i = x;
        while (i < z) {
            this.arr[i++] = src.get();
        }
        this.num = z;
        return x;
    }

    @Override
    public synchronized long append(SampleBuffer src, int off, int len) {
        int x = this.num;
        int z = x + len;
        if (z > this.arr.length) {
            this.resize(z);
        }
        src.get(off, this.arr, this.num, len);
        this.num = z;
        return x;
    }

    @Override
    public synchronized void remove(long i, int len) {
        if (len < 1) {
            throw new IllegalArgumentException("len=" + len);
        }
        int x = (int)i;
        if (x < 0) {
            throw new ArrayIndexOutOfBoundsException(x);
        }
        int y = x + len;
        if (y > this.num) {
            throw new ArrayIndexOutOfBoundsException(this.num);
        }
        System.arraycopy(this.arr, y, this.arr, x, this.num - y);
        int z = this.num - len;
        Arrays.fill(this.arr, z, this.num, 0.0);
        this.num = z;
    }

    @Override
    public synchronized void insert(long i, int len) {
        if (len < 1) {
            throw new IllegalArgumentException("len=" + len);
        }
        int x = (int)i;
        if (x < 0) {
            throw new ArrayIndexOutOfBoundsException(x);
        }
        int z = this.num + len;
        if (z > this.arr.length) {
            this.resize(z);
        }
        int y = x + len;
        System.arraycopy(this.arr, x, this.arr, y, this.num - x);
        this.num = z;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public synchronized void close() throws IOException {
        this.num = 0;
        this.arr = null;
    }

    protected synchronized void resize(int minSize) {
        double[] newArray = this.create(minSize);
        System.arraycopy(this.arr, 0, newArray, 0, this.num);
        this.arr = newArray;
    }

    protected double[] create(int minSize) {
        return new double[Math.max(minSize, this.num * 2)];
    }
}

