/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleTypes;

public class DoubleMsbByteArraySampleBuffer
extends AbstractByteArraySampleBuffer {
    public DoubleMsbByteArraySampleBuffer(int channels, float frameRate, int samples, byte[] arr) {
        super(channels, frameRate, samples, SampleTypes.Double64Msb, arr);
    }

    @Override
    protected double getD(int o) {
        return Double.longBitsToDouble((long)(this.arr[o + 7] & 0xFF | (this.arr[o + 6] & 0xFF) << 8 | (this.arr[o + 5] & 0xFF) << 16) | (long)(this.arr[o + 4] & 0xFF) << 24 | (long)(this.arr[o + 3] & 0xFF) << 32 | (long)(this.arr[o + 2] & 0xFF) << 40 | (long)(this.arr[o + 1] & 0xFF) << 48 | (long)(this.arr[o] & 0xFF) << 56);
    }

    @Override
    protected float getF(int o) {
        return (float)Double.longBitsToDouble((long)(this.arr[o + 7] & 0xFF | (this.arr[o + 6] & 0xFF) << 8 | (this.arr[o + 5] & 0xFF) << 16) | (long)(this.arr[o + 4] & 0xFF) << 24 | (long)(this.arr[o + 3] & 0xFF) << 32 | (long)(this.arr[o + 2] & 0xFF) << 40 | (long)(this.arr[o + 1] & 0xFF) << 48 | (long)(this.arr[o] & 0xFF) << 56);
    }

    @Override
    protected void setD(int o, double v) {
        long x = Double.doubleToRawLongBits(v);
        this.arr[o] = (byte)(x >> 56);
        this.arr[o + 1] = (byte)(x >> 48);
        this.arr[o + 2] = (byte)(x >> 40);
        this.arr[o + 3] = (byte)(x >> 32);
        this.arr[o + 4] = (byte)(x >> 24);
        this.arr[o + 5] = (byte)(x >> 16);
        this.arr[o + 6] = (byte)(x >> 8);
        this.arr[o + 7] = (byte)(x & 0xFFL);
    }

    @Override
    protected void setF(int o, float v) {
        long x = Double.doubleToRawLongBits(v);
        this.arr[o] = (byte)(x >> 56);
        this.arr[o + 1] = (byte)(x >> 48);
        this.arr[o + 2] = (byte)(x >> 40);
        this.arr[o + 3] = (byte)(x >> 32);
        this.arr[o + 4] = (byte)(x >> 24);
        this.arr[o + 5] = (byte)(x >> 16);
        this.arr[o + 6] = (byte)(x >> 8);
        this.arr[o + 7] = (byte)(x & 0xFFL);
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        if (src instanceof DoubleMsbByteArraySampleBuffer) {
            DoubleMsbByteArraySampleBuffer s = (DoubleMsbByteArraySampleBuffer)src;
            System.arraycopy(s.arr, off * 8, this.arr, i * 8, len * 8);
        } else {
            super.set(i, src, off, len);
        }
    }
}

