/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractSampleModel;
import com.spacekiller.util.sound.SampleBuffer;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class DummySampleModel
extends AbstractSampleModel {
    protected long samples;
    protected double dummyValue;

    public DummySampleModel(int channels, float frameRate) {
        this(channels, frameRate, 0L, 0.0);
    }

    public DummySampleModel(int channels, float frameRate, long samples, double dummyValue) {
        super(channels, frameRate);
        this.samples = samples;
        this.dummyValue = dummyValue;
    }

    @Override
    public final boolean isEmpty() {
        return this.samples < 1L;
    }

    @Override
    public final long getSamples() {
        return this.samples;
    }

    public void setSamples(long samples) {
        this.samples = samples;
    }

    public double getDummyValue() {
        return this.dummyValue;
    }

    public void setDummyValue(double dummyValue) {
        this.dummyValue = dummyValue;
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public float getFloat(long i) throws IOException {
        return (float)this.dummyValue;
    }

    @Override
    public double getDouble(long i) throws IOException {
        return this.dummyValue;
    }

    @Override
    public void get(long i, double[] dst, int off, int len) throws IOException {
        double val = this.dummyValue;
        int end = off + len;
        while (off < end) {
            dst[off++] = val;
        }
    }

    @Override
    public void get(long i, float[] dst, int off, int len) throws IOException {
        float val = (float)this.dummyValue;
        int end = off + len;
        while (off < end) {
            dst[off++] = val;
        }
    }

    @Override
    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        double val = this.dummyValue;
        while (len-- > 0) {
            dst.put(val);
        }
    }

    @Override
    public void get(long i, FloatBuffer dst, int len) throws IOException {
        float val = (float)this.dummyValue;
        while (len-- > 0) {
            dst.put(val);
        }
    }

    @Override
    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        dst.fill(off, len, this.dummyValue);
    }

    @Override
    public void set(long i, float v) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, double v) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear(long i, int len) throws IOException {
    }

    @Override
    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

