/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.FFT;

public class FFTImpl
implements FFT {
    private static final double LOG2 = StrictMath.log(2.0);
    private int n;
    private int nv2;
    private int ln;

    public FFTImpl(int frames) {
        this.n = frames;
        this.nv2 = this.n / 2;
        this.ln = (int)(StrictMath.log(this.n) / LOG2 + 0.5);
    }

    @Override
    public void fft(double[] real, double[] imag) {
        double t_i;
        double t_r;
        int i;
        int j = 1;
        for (i = 1; i < this.n; ++i) {
            int k;
            if (i < j) {
                t_r = real[i - 1];
                t_i = imag[i - 1];
                real[i - 1] = real[j - 1];
                imag[i - 1] = imag[j - 1];
                real[j - 1] = t_r;
                imag[j - 1] = t_i;
            }
            for (k = this.nv2; k < j; j -= k, k /= 2) {
            }
            j += k;
        }
        for (int l = 1; l <= this.ln; ++l) {
            int le = (int)(StrictMath.exp((double)l * LOG2) + 0.5);
            int le1 = le / 2;
            double u_r = 1.0;
            double u_i = 0.0;
            double w_r = StrictMath.cos(Math.PI / (double)le1);
            double w_i = -StrictMath.sin(Math.PI / (double)le1);
            for (j = 1; j <= le1; ++j) {
                for (i = j; i <= this.n; i += le) {
                    int ip = i + le1;
                    t_r = real[ip - 1] * u_r - u_i * imag[ip - 1];
                    t_i = imag[ip - 1] * u_r + u_i * real[ip - 1];
                    real[ip - 1] = real[i - 1] - t_r;
                    imag[ip - 1] = imag[i - 1] - t_i;
                    real[i - 1] = real[i - 1] + t_r;
                    imag[i - 1] = imag[i - 1] + t_i;
                }
                t_r = u_r * w_r - w_i * u_i;
                u_i = w_r * u_i + w_i * u_r;
                u_r = t_r;
            }
        }
    }

    @Override
    public void ifft(double[] real, double[] imag) {
        double t_i;
        double t_r;
        int i;
        int j = 1;
        for (i = 1; i < this.n; ++i) {
            int k;
            if (i < j) {
                t_r = real[i - 1];
                t_i = imag[i - 1];
                real[i - 1] = real[j - 1];
                imag[i - 1] = imag[j - 1];
                real[j - 1] = t_r;
                imag[j - 1] = t_i;
            }
            for (k = this.nv2; k < j; j -= k, k /= 2) {
            }
            j += k;
        }
        for (int l = 1; l <= this.ln; ++l) {
            int le = (int)(StrictMath.exp((double)l * LOG2) + 0.5);
            int le1 = le / 2;
            double u_r = 1.0;
            double u_i = 0.0;
            double w_r = StrictMath.cos(Math.PI / (double)le1);
            double w_i = StrictMath.sin(Math.PI / (double)le1);
            for (j = 1; j <= le1; ++j) {
                for (i = j; i <= this.n; i += le) {
                    int ip = i + le1;
                    t_r = real[ip - 1] * u_r - u_i * imag[ip - 1];
                    t_i = imag[ip - 1] * u_r + u_i * real[ip - 1];
                    real[ip - 1] = real[i - 1] - t_r;
                    imag[ip - 1] = imag[i - 1] - t_i;
                    real[i - 1] = real[i - 1] + t_r;
                    imag[i - 1] = imag[i - 1] + t_i;
                }
                t_r = u_r * w_r - w_i * u_i;
                u_i = w_r * u_i + w_i * u_r;
                u_r = t_r;
            }
        }
    }
}

