/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleTypes;

public class FloatLsbByteArraySampleBuffer
extends AbstractByteArraySampleBuffer {
    public FloatLsbByteArraySampleBuffer(int channels, float frameRate, int samples, byte[] arr) {
        super(channels, frameRate, samples, SampleTypes.Float32Lsb, arr);
    }

    @Override
    protected double getD(int o) {
        return Float.intBitsToFloat(this.arr[o] & 0xFF | (this.arr[o + 1] & 0xFF) << 8 | (this.arr[o + 2] & 0xFF) << 16 | (this.arr[o + 3] & 0xFF) << 24);
    }

    @Override
    protected float getF(int o) {
        return Float.intBitsToFloat(this.arr[o] & 0xFF | (this.arr[o + 1] & 0xFF) << 8 | (this.arr[o + 2] & 0xFF) << 16 | (this.arr[o + 3] & 0xFF) << 24);
    }

    @Override
    protected void setD(int o, double v) {
        int x = Float.floatToRawIntBits((float)v);
        this.arr[o] = (byte)(x & 0xFF);
        this.arr[o + 1] = (byte)(x >> 8);
        this.arr[o + 2] = (byte)(x >> 16);
        this.arr[o + 3] = (byte)(x >> 24);
    }

    @Override
    protected void setF(int o, float v) {
        int x = Float.floatToRawIntBits(v);
        this.arr[o] = (byte)(x & 0xFF);
        this.arr[o + 1] = (byte)(x >> 8);
        this.arr[o + 2] = (byte)(x >> 16);
        this.arr[o + 3] = (byte)(x >> 24);
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        if (src instanceof FloatLsbByteArraySampleBuffer) {
            FloatLsbByteArraySampleBuffer s = (FloatLsbByteArraySampleBuffer)src;
            System.arraycopy(s.arr, off * 4, this.arr, i * 4, len * 4);
        } else {
            super.set(i, src, off, len);
        }
    }
}

