/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;

public class FormatConversionProviderWrapper
extends FormatConversionProvider {
    private static final Logger logger = Logger.getLogger(FormatConversionProviderWrapper.class.getName());
    private static final AudioFormat.Encoding[] NO_ENCODINGS = new AudioFormat.Encoding[0];
    private static final AudioFormat[] NO_FORMATS = new AudioFormat[0];
    private FormatConversionProvider codec;

    protected FormatConversionProviderWrapper() {
    }

    public FormatConversionProviderWrapper(FormatConversionProvider codec) {
        this();
        this.codec = codec;
    }

    protected void handleException(Throwable e) {
        if (logger.isLoggable(Level.FINER)) {
            String msg = "Audio codec '" + this.codec + "' failed: " + e;
            logger.finer(msg);
        }
    }

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            return NO_ENCODINGS;
        }
        try {
            return c.getSourceEncodings();
        }
        catch (Throwable e) {
            this.handleException(e);
            return NO_ENCODINGS;
        }
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            return NO_ENCODINGS;
        }
        try {
            return c.getTargetEncodings();
        }
        catch (Throwable e) {
            this.handleException(e);
            return NO_ENCODINGS;
        }
    }

    @Override
    public boolean isSourceEncodingSupported(AudioFormat.Encoding sourceEncoding) {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            return false;
        }
        try {
            return c.isSourceEncodingSupported(sourceEncoding);
        }
        catch (Throwable e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public boolean isTargetEncodingSupported(AudioFormat.Encoding targetEncoding) {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            return false;
        }
        try {
            return c.isTargetEncodingSupported(targetEncoding);
        }
        catch (Throwable e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            return NO_ENCODINGS;
        }
        try {
            return c.getTargetEncodings(sourceFormat);
        }
        catch (Throwable e) {
            this.handleException(e);
            return NO_ENCODINGS;
        }
    }

    @Override
    public boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            return false;
        }
        try {
            return c.isConversionSupported(targetEncoding, sourceFormat);
        }
        catch (Throwable e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            return NO_FORMATS;
        }
        try {
            return c.getTargetFormats(targetEncoding, sourceFormat);
        }
        catch (Throwable e) {
            this.handleException(e);
            return NO_FORMATS;
        }
    }

    @Override
    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            return false;
        }
        try {
            return c.isConversionSupported(targetFormat, sourceFormat);
        }
        catch (Throwable e) {
            this.handleException(e);
            return false;
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            throw new IllegalArgumentException();
        }
        try {
            return c.getAudioInputStream(targetEncoding, sourceStream);
        }
        catch (IllegalArgumentException e) {
            this.handleException(e);
            throw e;
        }
        catch (Throwable e) {
            this.handleException(e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        FormatConversionProvider c = this.codec;
        if (c == null) {
            throw new IllegalArgumentException();
        }
        try {
            return c.getAudioInputStream(targetFormat, sourceStream);
        }
        catch (IllegalArgumentException e) {
            this.handleException(e);
            throw e;
        }
        catch (Throwable e) {
            this.handleException(e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String toString() {
        return super.toString() + "[codec=" + this.codec + "]";
    }

    protected FormatConversionProvider getCodec() {
        return this.codec;
    }

    protected void setCodec(FormatConversionProvider codec) {
        this.codec = codec;
    }
}

