/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleTypes;

public class Int16MsbByteArraySampleBuffer
extends AbstractByteArraySampleBuffer {
    private static final int MAX = Short.MAX_VALUE;
    private static final int MIN = Short.MIN_VALUE;
    private static final double MULd = 32768.0;
    private static final float MULf = 32768.0f;

    public Int16MsbByteArraySampleBuffer(int channels, float frameRate, int samples, byte[] arr) {
        super(channels, frameRate, samples, SampleTypes.Int16Msb, arr);
    }

    @Override
    protected double getD(int o) {
        return (double)(this.arr[o + 1] & 0xFF | this.arr[o] << 8) / 32768.0;
    }

    @Override
    protected float getF(int o) {
        return (float)(this.arr[o + 1] & 0xFF | this.arr[o] << 8) / 32768.0f;
    }

    @Override
    protected void setD(int o, double v) {
        int x = (int)Math.round(v * 32768.0);
        if (x > Short.MAX_VALUE) {
            x = Short.MAX_VALUE;
        } else if (x < Short.MIN_VALUE) {
            x = Short.MIN_VALUE;
        }
        this.arr[o + 1] = (byte)(x & 0xFF);
        this.arr[o] = (byte)(x >> 8);
    }

    @Override
    protected void setF(int o, float v) {
        int x = Math.round(v * 32768.0f);
        if (x > Short.MAX_VALUE) {
            x = Short.MAX_VALUE;
        } else if (x < Short.MIN_VALUE) {
            x = Short.MIN_VALUE;
        }
        this.arr[o + 1] = (byte)(x & 0xFF);
        this.arr[o] = (byte)(x >> 8);
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        if (src instanceof Int16MsbByteArraySampleBuffer) {
            Int16MsbByteArraySampleBuffer s = (Int16MsbByteArraySampleBuffer)src;
            System.arraycopy(s.arr, off * 2, this.arr, i * 2, len * 2);
        } else {
            super.set(i, src, off, len);
        }
    }
}

