/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleTypes;

public class Int24LsbByteArraySampleBuffer
extends AbstractByteArraySampleBuffer {
    private static final int MAX = 0x7FFFFF;
    private static final int MIN = -8388608;
    private static final double MULd = 8388608.0;
    private static final float MULf = 8388608.0f;

    public Int24LsbByteArraySampleBuffer(int channels, float frameRate, int samples, byte[] arr) {
        super(channels, frameRate, samples, SampleTypes.Int24Lsb, arr);
    }

    @Override
    protected double getD(int o) {
        return (double)(this.arr[o] & 0xFF | (this.arr[o + 1] & 0xFF) << 8 | this.arr[o + 2] << 16) / 8388608.0;
    }

    @Override
    protected float getF(int o) {
        return (float)(this.arr[o] & 0xFF | (this.arr[o + 1] & 0xFF) << 8 | this.arr[o + 2] << 16) / 8388608.0f;
    }

    @Override
    protected void setD(int o, double v) {
        int x = (int)Math.round(v * 8388608.0);
        if (x > 0x7FFFFF) {
            x = 0x7FFFFF;
        } else if (x < -8388608) {
            x = -8388608;
        }
        this.arr[o] = (byte)(x & 0xFF);
        this.arr[o + 1] = (byte)(x >> 8);
        this.arr[o + 2] = (byte)(x >> 16);
    }

    @Override
    protected void setF(int o, float v) {
        int x = Math.round(v * 8388608.0f);
        if (x > 0x7FFFFF) {
            x = 0x7FFFFF;
        } else if (x < -8388608) {
            x = -8388608;
        }
        this.arr[o] = (byte)(x & 0xFF);
        this.arr[o + 1] = (byte)(x >> 8);
        this.arr[o + 2] = (byte)(x >> 16);
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        if (src instanceof Int24LsbByteArraySampleBuffer) {
            Int24LsbByteArraySampleBuffer s = (Int24LsbByteArraySampleBuffer)src;
            System.arraycopy(s.arr, off * 3, this.arr, i * 3, len * 3);
        } else {
            super.set(i, src, off, len);
        }
    }
}

