/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleTypes;

public class Int32Lsb24ByteArraySampleBuffer
extends AbstractByteArraySampleBuffer {
    private static final int MAX = 0x7FFFFF;
    private static final int MIN = -8388608;
    private static final double MULd = 8388608.0;
    private static final float MULf = 8388608.0f;

    public Int32Lsb24ByteArraySampleBuffer(int channels, float frameRate, int samples, byte[] arr) {
        super(channels, frameRate, samples, SampleTypes.Int32Lsb24, arr);
    }

    @Override
    protected double getD(int o) {
        return (double)(this.arr[o] & 0xFF | (this.arr[o + 1] & 0xFF) << 8 | (this.arr[o + 2] & 0xFF) << 16 | this.arr[o + 3] << 24) / 8388608.0;
    }

    @Override
    protected float getF(int o) {
        return (float)(this.arr[o] & 0xFF | (this.arr[o + 1] & 0xFF) << 8 | (this.arr[o + 2] & 0xFF) << 16 | this.arr[o + 3] << 24) / 8388608.0f;
    }

    @Override
    protected void setD(int o, double v) {
        int x = (int)Math.round(v * 8388608.0);
        if (x > 0x7FFFFF) {
            x = 0x7FFFFF;
        } else if (x < -8388608) {
            x = -8388608;
        }
        this.arr[o] = (byte)(x & 0xFF);
        this.arr[o + 1] = (byte)(x >> 8);
        this.arr[o + 2] = (byte)(x >> 16);
        this.arr[o + 3] = (byte)(x >> 24);
    }

    @Override
    protected void setF(int o, float v) {
        int x = Math.round(v * 8388608.0f);
        if (x > 0x7FFFFF) {
            x = 0x7FFFFF;
        } else if (x < -8388608) {
            x = -8388608;
        }
        this.arr[o] = (byte)(x & 0xFF);
        this.arr[o + 1] = (byte)(x >> 8);
        this.arr[o + 2] = (byte)(x >> 16);
        this.arr[o + 3] = (byte)(x >> 24);
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        if (src instanceof Int32Lsb24ByteArraySampleBuffer) {
            Int32Lsb24ByteArraySampleBuffer s = (Int32Lsb24ByteArraySampleBuffer)src;
            System.arraycopy(s.arr, off * 4, this.arr, i * 4, len * 4);
        } else {
            super.set(i, src, off, len);
        }
    }
}

