/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleTypes;

public class Int32MsbByteArraySampleBuffer
extends AbstractByteArraySampleBuffer {
    private static final int MAX = Integer.MAX_VALUE;
    private static final int MIN = Integer.MIN_VALUE;
    private static final double MUL = 2.147483648E9;

    public Int32MsbByteArraySampleBuffer(int channels, float frameRate, int samples, byte[] arr) {
        super(channels, frameRate, samples, SampleTypes.Int32Msb, arr);
    }

    @Override
    protected double getD(int o) {
        return (double)(this.arr[o + 3] & 0xFF | (this.arr[o + 2] & 0xFF) << 8 | (this.arr[o + 1] & 0xFF) << 16 | this.arr[o] << 24) / 2.147483648E9;
    }

    @Override
    protected float getF(int o) {
        return (float)((double)(this.arr[o + 3] & 0xFF | (this.arr[o + 2] & 0xFF) << 8 | (this.arr[o + 1] & 0xFF) << 16 | this.arr[o] << 24) / 2.147483648E9);
    }

    @Override
    protected void setD(int o, double v) {
        long x = Math.round(v * 2.147483648E9);
        if (x > Integer.MAX_VALUE) {
            x = Integer.MAX_VALUE;
        } else if (x < Integer.MIN_VALUE) {
            x = Integer.MIN_VALUE;
        }
        this.arr[o] = (byte)(x >> 24);
        this.arr[o + 1] = (byte)(x >> 16);
        this.arr[o + 2] = (byte)(x >> 8);
        this.arr[o + 3] = (byte)(x & 0xFFL);
    }

    @Override
    protected void setF(int o, float v) {
        long x = Math.round((double)v * 2.147483648E9);
        if (x > Integer.MAX_VALUE) {
            x = Integer.MAX_VALUE;
        } else if (x < Integer.MIN_VALUE) {
            x = Integer.MIN_VALUE;
        }
        this.arr[o] = (byte)(x >> 24);
        this.arr[o + 1] = (byte)(x >> 16);
        this.arr[o + 2] = (byte)(x >> 8);
        this.arr[o + 3] = (byte)(x & 0xFFL);
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        if (src instanceof Int32MsbByteArraySampleBuffer) {
            Int32MsbByteArraySampleBuffer s = (Int32MsbByteArraySampleBuffer)src;
            System.arraycopy(s.arr, off * 4, this.arr, i * 4, len * 4);
        } else {
            super.set(i, src, off, len);
        }
    }
}

