/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.AbstractByteArraySampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleTypes;

public class Int64MsbByteArraySampleBuffer
extends AbstractByteArraySampleBuffer {
    private static final long MAX = Long.MAX_VALUE;
    private static final double MUL = 9.223372036854776E18;

    public Int64MsbByteArraySampleBuffer(int channels, float frameRate, int samples, byte[] arr) {
        super(channels, frameRate, samples, SampleTypes.Int64Msb, arr);
    }

    @Override
    protected double getD(int o) {
        return (double)((long)(this.arr[o + 7] & 0xFF | (this.arr[o + 6] & 0xFF) << 8 | (this.arr[o + 5] & 0xFF) << 16) | ((long)this.arr[o + 4] & 0xFFL) << 24 | ((long)this.arr[o + 3] & 0xFFL) << 32 | ((long)this.arr[o + 2] & 0xFFL) << 40 | ((long)this.arr[o + 1] & 0xFFL) << 48 | ((long)this.arr[o] & 0xFFL) << 56) / 9.223372036854776E18;
    }

    @Override
    protected float getF(int o) {
        return (float)((double)((long)(this.arr[o + 7] & 0xFF | (this.arr[o + 6] & 0xFF) << 8 | (this.arr[o + 5] & 0xFF) << 16) | ((long)this.arr[o + 4] & 0xFFL) << 24 | ((long)this.arr[o + 3] & 0xFFL) << 32 | ((long)this.arr[o + 2] & 0xFFL) << 40 | ((long)this.arr[o + 1] & 0xFFL) << 48 | ((long)this.arr[o] & 0xFFL) << 56) / 9.223372036854776E18);
    }

    @Override
    protected void setD(int o, double v) {
        if (v > 1.0) {
            v = 1.0;
        } else if (v < -1.0) {
            v = -1.0;
        }
        long x = Math.round(v * 9.223372036854776E18);
        this.arr[o] = (byte)(x >> 56);
        this.arr[o + 1] = (byte)(x >> 48);
        this.arr[o + 2] = (byte)(x >> 40);
        this.arr[o + 3] = (byte)(x >> 32);
        this.arr[o + 4] = (byte)(x >> 24);
        this.arr[o + 5] = (byte)(x >> 16);
        this.arr[o + 6] = (byte)(x >> 8);
        this.arr[o + 7] = (byte)(x >> 0);
    }

    @Override
    protected void setF(int o, float v) {
        if (v > 1.0f) {
            v = 1.0f;
        } else if (v < -1.0f) {
            v = -1.0f;
        }
        long x = Math.round((double)v * 9.223372036854776E18);
        this.arr[o] = (byte)(x >> 56);
        this.arr[o + 1] = (byte)(x >> 48);
        this.arr[o + 2] = (byte)(x >> 40);
        this.arr[o + 3] = (byte)(x >> 32);
        this.arr[o + 4] = (byte)(x >> 24);
        this.arr[o + 5] = (byte)(x >> 16);
        this.arr[o + 6] = (byte)(x >> 8);
        this.arr[o + 7] = (byte)(x >> 0);
    }

    @Override
    public void set(int i, SampleBuffer src, int off, int len) {
        if (src instanceof Int64MsbByteArraySampleBuffer) {
            Int64MsbByteArraySampleBuffer s = (Int64MsbByteArraySampleBuffer)src;
            System.arraycopy(s.arr, off * 8, this.arr, i * 8, len * 8);
        } else {
            super.set(i, src, off, len);
        }
    }
}

