/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class MonoMixedSampleModel
implements SampleModel {
    private final SampleModel sm;
    private final int nc;
    private final boolean closeModel;

    public MonoMixedSampleModel(SampleModel model, boolean closeModel) {
        this.closeModel = closeModel;
        this.sm = model;
        this.nc = model.getChannels();
        if (this.nc < 2) {
            throw new IllegalArgumentException("Invalid number of model channels: " + this.nc + " < 2");
        }
    }

    public String toString() {
        return super.toString() + "[" + this.sm + "]";
    }

    @Override
    public final int getChannels() {
        return 1;
    }

    @Override
    public float getFrameRate() {
        return this.sm.getFrameRate();
    }

    @Override
    public long getSamples() {
        return this.sm.getSamples() / (long)this.nc;
    }

    @Override
    public boolean isEmpty() {
        return this.sm.getSamples() < 1L;
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public void flush() throws IOException {
        this.sm.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closeModel) {
            this.sm.close();
        }
    }

    @Override
    public void clear(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, float v) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, double v) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(long i) throws IOException {
        i *= (long)this.nc;
        double v = this.sm.getDouble(i++);
        for (int k = 1; k < this.nc; ++k) {
            v += this.sm.getDouble(i++);
        }
        return v / (double)this.nc;
    }

    @Override
    public float getFloat(long i) throws IOException {
        i *= (long)this.nc;
        float v = this.sm.getFloat(i++);
        for (int k = 1; k < this.nc; ++k) {
            v += this.sm.getFloat(i++);
        }
        return v / (float)this.nc;
    }

    @Override
    public void get(long i, double[] dst, int off, int len) throws IOException {
        i *= (long)this.nc;
        for (int j = 0; j < len; ++j) {
            double v = this.sm.getDouble(i++);
            for (int k = 1; k < this.nc; ++k) {
                v += this.sm.getDouble(i++);
            }
            dst[off++] = v / (double)this.nc;
        }
    }

    @Override
    public void get(long i, float[] dst, int off, int len) throws IOException {
        i *= (long)this.nc;
        for (int j = 0; j < len; ++j) {
            float v = this.sm.getFloat(i++);
            for (int k = 1; k < this.nc; ++k) {
                v += this.sm.getFloat(i++);
            }
            dst[off++] = v / (float)this.nc;
        }
    }

    @Override
    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        i *= (long)this.nc;
        for (int j = 0; j < len; ++j) {
            double v = this.sm.getDouble(i++);
            for (int k = 1; k < this.nc; ++k) {
                v += this.sm.getDouble(i++);
            }
            dst.put(v / (double)this.nc);
        }
    }

    @Override
    public void get(long i, FloatBuffer dst, int len) throws IOException {
        i *= (long)this.nc;
        for (int j = 0; j < len; ++j) {
            float v = this.sm.getFloat(i++);
            for (int k = 1; k < this.nc; ++k) {
                v += this.sm.getFloat(i++);
            }
            dst.put(v / (float)this.nc);
        }
    }

    @Override
    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        i *= (long)this.nc;
        for (int j = 0; j < len; ++j) {
            double v = this.sm.getDouble(i++);
            for (int k = 1; k < this.nc; ++k) {
                v += this.sm.getDouble(i++);
            }
            dst.set(off++, v / (double)this.nc);
        }
    }
}

