/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;

public class MultiChannelSampleModel
implements SampleModel {
    private final SampleModel[] cm;
    private final int nc;
    private final float frameRate;
    private final boolean closeModels;
    private long frames;

    public MultiChannelSampleModel(SampleModel[] models, boolean closeModels) {
        this.closeModels = closeModels;
        this.cm = models;
        this.nc = models.length;
        if (this.nc < 1) {
            throw new IllegalArgumentException("Invalid number of channels: " + this.nc + " < 1");
        }
        this.frameRate = models[0].getFrameRate();
        this.frames = models[0].getSamples();
        for (int i = 0; i < this.nc; ++i) {
            SampleModel sm = models[i];
            int modelChs = sm.getChannels();
            if (modelChs != 1) {
                throw new IllegalArgumentException("Invalid number of model channel(s): " + modelChs + " != 1");
            }
            float modelRate = sm.getFrameRate();
            if (modelRate != this.frameRate) {
                throw new IllegalArgumentException("Invalid audio model frame rate(s): " + modelRate + " != " + this.frameRate);
            }
            long samples = sm.getSamples();
            if (samples >= this.frames) continue;
            this.frames = samples;
        }
        if (this.frames < 0L) {
            this.frames = 0L;
        }
    }

    public String toString() {
        return super.toString() + "[channels=" + this.nc + ", frameRate=" + this.frameRate + "]";
    }

    @Override
    public final int getChannels() {
        return this.nc;
    }

    @Override
    public float getFrameRate() {
        return this.frameRate;
    }

    @Override
    public boolean isEmpty() {
        return this.frames < 1L;
    }

    @Override
    public long getSamples() {
        return this.frames * (long)this.nc;
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public void flush() throws IOException {
        for (int i = 0; i < this.nc; ++i) {
            this.cm[i].flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closeModels) {
            for (int i = 0; i < this.nc; ++i) {
                this.cm[i].close();
            }
        }
    }

    @Override
    public void clear(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, float v) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, double v) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long append(SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(long i) throws IOException {
        return this.cm[(int)(i % (long)this.nc)].getDouble(i / (long)this.nc);
    }

    @Override
    public float getFloat(long i) throws IOException {
        return this.cm[(int)(i % (long)this.nc)].getFloat(i / (long)this.nc);
    }

    @Override
    public void get(long i, double[] dst, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            dst[off++] = this.cm[(int)(i % (long)this.nc)].getDouble(i / (long)this.nc);
            ++i;
        }
    }

    @Override
    public void get(long i, float[] dst, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            dst[off++] = this.cm[(int)(i % (long)this.nc)].getFloat(i / (long)this.nc);
            ++i;
        }
    }

    @Override
    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        int k = 0;
        while (k < len) {
            dst.put(this.cm[(int)(i % (long)this.nc)].getDouble(i / (long)this.nc));
            ++k;
            ++i;
        }
    }

    @Override
    public void get(long i, FloatBuffer dst, int len) throws IOException {
        int k = 0;
        while (k < len) {
            dst.put(this.cm[(int)(i % (long)this.nc)].getFloat(i / (long)this.nc));
            ++k;
            ++i;
        }
    }

    @Override
    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        int end = off + len;
        while (off < end) {
            dst.set(off++, this.cm[(int)(i % (long)this.nc)].getDouble(i / (long)this.nc));
            ++i;
        }
    }
}

