/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;

public abstract class SampleType {
    private final String name;
    private final int hash;

    public SampleType(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        this.hash = name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return this.name.equals(((SampleType)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public final String getName() {
        return this.name;
    }

    public abstract String getTitle();

    public abstract int getSampleSize();

    public abstract int getSampleBits();

    public abstract boolean isRaw();

    public abstract boolean isSigned();

    public abstract boolean isBigEndian();

    public abstract boolean isFloating();

    public abstract SampleBuffer createSampleBuffer(int var1, float var2, int var3);

    public abstract RawSampleBuffer createRawSampleBuffer(int var1, float var2, int var3);

    public abstract ByteArraySampleBuffer createByteArraySampleBuffer(int var1, float var2, int var3);
}

