/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.ByteArraySampleBuffer;
import com.spacekiller.util.sound.DoubleArraySampleBuffer;
import com.spacekiller.util.sound.DoubleLsbByteArraySampleBuffer;
import com.spacekiller.util.sound.DoubleMsbByteArraySampleBuffer;
import com.spacekiller.util.sound.FloatArraySampleBuffer;
import com.spacekiller.util.sound.FloatLsbByteArraySampleBuffer;
import com.spacekiller.util.sound.FloatMsbByteArraySampleBuffer;
import com.spacekiller.util.sound.Int16LsbByteArraySampleBuffer;
import com.spacekiller.util.sound.Int16MsbByteArraySampleBuffer;
import com.spacekiller.util.sound.Int24LsbByteArraySampleBuffer;
import com.spacekiller.util.sound.Int24MsbByteArraySampleBuffer;
import com.spacekiller.util.sound.Int32Lsb24ByteArraySampleBuffer;
import com.spacekiller.util.sound.Int32LsbByteArraySampleBuffer;
import com.spacekiller.util.sound.Int32Msb24ByteArraySampleBuffer;
import com.spacekiller.util.sound.Int32MsbByteArraySampleBuffer;
import com.spacekiller.util.sound.Int64LsbByteArraySampleBuffer;
import com.spacekiller.util.sound.Int64MsbByteArraySampleBuffer;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleType;

public class SampleTypes {
    public static final Double64ArraySampleType Double64Array = new Double64ArraySampleType();
    public static final Float32ArraySampleType Float32Array = new Float32ArraySampleType();
    public static final Double64LsbSampleType Double64Lsb = new Double64LsbSampleType();
    public static final Double64MsbSampleType Double64Msb = new Double64MsbSampleType();
    public static final Float32LsbSampleType Float32Lsb = new Float32LsbSampleType();
    public static final Float32MsbSampleType Float32Msb = new Float32MsbSampleType();
    public static final Int64LsbSampleType Int64Lsb = new Int64LsbSampleType();
    public static final Int64MsbSampleType Int64Msb = new Int64MsbSampleType();
    public static final Int32LsbSampleType Int32Lsb = new Int32LsbSampleType();
    public static final Int32MsbSampleType Int32Msb = new Int32MsbSampleType();
    public static final Int32Lsb24SampleType Int32Lsb24 = new Int32Lsb24SampleType();
    public static final Int32Msb24SampleType Int32Msb24 = new Int32Msb24SampleType();
    public static final Int24LsbSampleType Int24Lsb = new Int24LsbSampleType();
    public static final Int24MsbSampleType Int24Msb = new Int24MsbSampleType();
    public static final Int16LsbSampleType Int16Lsb = new Int16LsbSampleType();
    public static final Int16MsbSampleType Int16Msb = new Int16MsbSampleType();

    protected SampleTypes() {
    }

    public static SampleType[] getSampleTypeArray() {
        return new SampleType[]{Double64Array, Float32Array, Double64Lsb, Float32Lsb, Int64Lsb, Int32Lsb, Int32Lsb24, Int24Lsb, Int16Lsb, Double64Msb, Float32Msb, Int64Msb, Int32Msb, Int32Msb24, Int24Msb, Int16Msb};
    }

    public static SampleType getSampleType(String name) {
        SampleType[] arr = SampleTypes.getSampleTypeArray();
        for (int i = 0; i < arr.length; ++i) {
            if (!name.equals(arr[i].getName())) continue;
            return arr[i];
        }
        return null;
    }

    protected static final class Int32Msb24SampleType
    extends AbstractSampleType {
        public Int32Msb24SampleType() {
            super("Int32Msb24");
        }

        @Override
        public String getTitle() {
            return "24/32 bit integer (MSB)";
        }

        @Override
        public int getSampleBits() {
            return 24;
        }

        @Override
        public int getSampleSize() {
            return 4;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return true;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int32Msb24ByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 4]);
        }
    }

    protected static final class Int32Lsb24SampleType
    extends AbstractSampleType {
        public Int32Lsb24SampleType() {
            super("Int32Lsb24");
        }

        @Override
        public String getTitle() {
            return "24/32 bit integer (LSB)";
        }

        @Override
        public int getSampleBits() {
            return 24;
        }

        @Override
        public int getSampleSize() {
            return 4;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int32Lsb24ByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 4]);
        }
    }

    protected static final class Int16MsbSampleType
    extends AbstractSampleType {
        public Int16MsbSampleType() {
            super("Int16Msb");
        }

        @Override
        public String getTitle() {
            return "16 bit integer (MSB)";
        }

        @Override
        public int getSampleBits() {
            return 16;
        }

        @Override
        public int getSampleSize() {
            return 2;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return true;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int16MsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 2]);
        }
    }

    protected static final class Int16LsbSampleType
    extends AbstractSampleType {
        public Int16LsbSampleType() {
            super("Int16Lsb");
        }

        @Override
        public String getTitle() {
            return "16 bit integer (LSB)";
        }

        @Override
        public int getSampleBits() {
            return 16;
        }

        @Override
        public int getSampleSize() {
            return 2;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int16LsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 2]);
        }
    }

    protected static final class Int24MsbSampleType
    extends AbstractSampleType {
        public Int24MsbSampleType() {
            super("Int24Msb");
        }

        @Override
        public String getTitle() {
            return "24 bit integer (MSB)";
        }

        @Override
        public int getSampleBits() {
            return 24;
        }

        @Override
        public int getSampleSize() {
            return 3;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return true;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int24MsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 3]);
        }
    }

    protected static final class Int24LsbSampleType
    extends AbstractSampleType {
        public Int24LsbSampleType() {
            super("Int24Lsb");
        }

        @Override
        public String getTitle() {
            return "24 bit integer (LSB)";
        }

        @Override
        public int getSampleBits() {
            return 24;
        }

        @Override
        public int getSampleSize() {
            return 3;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int24LsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 3]);
        }
    }

    protected static final class Int32MsbSampleType
    extends AbstractSampleType {
        public Int32MsbSampleType() {
            super("Int32Msb");
        }

        @Override
        public String getTitle() {
            return "32 bit integer (MSB)";
        }

        @Override
        public int getSampleBits() {
            return 32;
        }

        @Override
        public int getSampleSize() {
            return 4;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return true;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int32MsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 4]);
        }
    }

    protected static final class Int32LsbSampleType
    extends AbstractSampleType {
        public Int32LsbSampleType() {
            super("Int32Lsb");
        }

        @Override
        public String getTitle() {
            return "32 bit integer (LSB)";
        }

        @Override
        public int getSampleBits() {
            return 32;
        }

        @Override
        public int getSampleSize() {
            return 4;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int32LsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 4]);
        }
    }

    protected static final class Int64MsbSampleType
    extends AbstractSampleType {
        public Int64MsbSampleType() {
            super("Int64Msb");
        }

        @Override
        public String getTitle() {
            return "64 bit long (MSB)";
        }

        @Override
        public int getSampleBits() {
            return 64;
        }

        @Override
        public int getSampleSize() {
            return 8;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return true;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int64MsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 8]);
        }
    }

    protected static final class Int64LsbSampleType
    extends AbstractSampleType {
        public Int64LsbSampleType() {
            super("Int64Lsb");
        }

        @Override
        public String getTitle() {
            return "64 bit long (LSB)";
        }

        @Override
        public int getSampleBits() {
            return 64;
        }

        @Override
        public int getSampleSize() {
            return 8;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isFloating() {
            return false;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new Int64LsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 8]);
        }
    }

    protected static final class Float32MsbSampleType
    extends AbstractSampleType {
        public Float32MsbSampleType() {
            super("Float32Msb");
        }

        @Override
        public String getTitle() {
            return "32 bit float (MSB)";
        }

        @Override
        public int getSampleBits() {
            return 32;
        }

        @Override
        public int getSampleSize() {
            return 4;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return true;
        }

        @Override
        public boolean isFloating() {
            return true;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new FloatMsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 4]);
        }
    }

    protected static final class Float32LsbSampleType
    extends AbstractSampleType {
        public Float32LsbSampleType() {
            super("Float32Lsb");
        }

        @Override
        public String getTitle() {
            return "32 bit float (LSB)";
        }

        @Override
        public int getSampleBits() {
            return 32;
        }

        @Override
        public int getSampleSize() {
            return 4;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isFloating() {
            return true;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new FloatLsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 4]);
        }
    }

    protected static final class Double64MsbSampleType
    extends AbstractSampleType {
        public Double64MsbSampleType() {
            super("Double64Msb");
        }

        @Override
        public String getTitle() {
            return "64 bit double (MSB)";
        }

        @Override
        public int getSampleBits() {
            return 64;
        }

        @Override
        public int getSampleSize() {
            return 8;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return true;
        }

        @Override
        public boolean isFloating() {
            return true;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new DoubleMsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 8]);
        }
    }

    protected static final class Double64LsbSampleType
    extends AbstractSampleType {
        public Double64LsbSampleType() {
            super("Double64Lsb");
        }

        @Override
        public String getTitle() {
            return "64 bit double (LSB)";
        }

        @Override
        public int getSampleBits() {
            return 64;
        }

        @Override
        public int getSampleSize() {
            return 8;
        }

        @Override
        public boolean isRaw() {
            return true;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isFloating() {
            return true;
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return new DoubleLsbByteArraySampleBuffer(channels, frameRate, samples, new byte[samples * 8]);
        }
    }

    protected static final class Float32ArraySampleType
    extends AbstractSampleType {
        public Float32ArraySampleType() {
            super("Float32Array");
        }

        @Override
        public String getTitle() {
            return "32 bit float array";
        }

        @Override
        public int getSampleBits() {
            return 32;
        }

        @Override
        public int getSampleSize() {
            return 4;
        }

        @Override
        public boolean isRaw() {
            return false;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isFloating() {
            return true;
        }

        @Override
        public SampleBuffer createSampleBuffer(int channels, float frameRate, int samples) {
            return new FloatArraySampleBuffer(channels, samples, frameRate, new float[samples]);
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return null;
        }
    }

    protected static final class Double64ArraySampleType
    extends AbstractSampleType {
        public Double64ArraySampleType() {
            super("Double64Array");
        }

        @Override
        public String getTitle() {
            return "64 bit double array";
        }

        @Override
        public int getSampleBits() {
            return 64;
        }

        @Override
        public int getSampleSize() {
            return 8;
        }

        @Override
        public boolean isRaw() {
            return false;
        }

        @Override
        public boolean isSigned() {
            return true;
        }

        @Override
        public boolean isBigEndian() {
            return false;
        }

        @Override
        public boolean isFloating() {
            return true;
        }

        @Override
        public SampleBuffer createSampleBuffer(int channels, float frameRate, int samples) {
            return new DoubleArraySampleBuffer(channels, samples, frameRate, new double[samples]);
        }

        @Override
        public ByteArraySampleBuffer createByteArraySampleBuffer(int channels, float frameRate, int samples) {
            return null;
        }
    }

    protected static abstract class AbstractSampleType
    extends SampleType {
        public AbstractSampleType(String name) {
            super(name);
        }

        @Override
        public SampleBuffer createSampleBuffer(int channels, float frameRate, int samples) {
            return this.createRawSampleBuffer(channels, frameRate, samples);
        }

        @Override
        public RawSampleBuffer createRawSampleBuffer(int channels, float frameRate, int samples) {
            return this.createByteArraySampleBuffer(channels, frameRate, samples);
        }
    }
}

