/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.sound;

import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.sound.SampleTypes;
import com.spacekiller.util.sound.SoundFormat;
import javax.sound.sampled.AudioFormat;

public class SoundUtil {
    public static final AudioFormat.Encoding PCM_SIGNED = AudioFormat.Encoding.PCM_SIGNED;
    public static final AudioFormat.Encoding PCM_FLOAT = new PcmFloatEncoding("PCM_FLOAT");

    private SoundUtil() {
    }

    public static SampleType guessSampleType(AudioFormat format) {
        AudioFormat.Encoding encoding = format.getEncoding();
        int channels = format.getChannels();
        int frameSize = format.getFrameSize();
        int bits = format.getSampleSizeInBits();
        double sampleSize = (double)frameSize / (double)channels;
        if (PCM_SIGNED.equals(encoding)) {
            switch (bits) {
                case 16: {
                    if (sampleSize != 2.0) break;
                    if (format.isBigEndian()) {
                        return SampleTypes.Int16Msb;
                    }
                    return SampleTypes.Int16Lsb;
                }
                case 24: {
                    if (sampleSize == 3.0) {
                        if (format.isBigEndian()) {
                            return SampleTypes.Int24Msb;
                        }
                        return SampleTypes.Int24Lsb;
                    }
                    if (sampleSize != 4.0) break;
                    if (format.isBigEndian()) {
                        return SampleTypes.Int32Msb24;
                    }
                    return SampleTypes.Int32Lsb24;
                }
                case 32: {
                    if (sampleSize != 4.0) break;
                    if (format.isBigEndian()) {
                        return SampleTypes.Int32Msb;
                    }
                    return SampleTypes.Int32Lsb;
                }
                case 64: {
                    if (sampleSize != 8.0) break;
                    if (format.isBigEndian()) {
                        return SampleTypes.Int64Msb;
                    }
                    return SampleTypes.Int64Lsb;
                }
            }
        }
        if (PCM_FLOAT.equals(encoding)) {
            switch (bits) {
                case 32: {
                    if (sampleSize != 4.0) break;
                    if (format.isBigEndian()) {
                        return SampleTypes.Float32Msb;
                    }
                    return SampleTypes.Float32Lsb;
                }
                case 64: {
                    if (sampleSize != 8.0) break;
                    if (format.isBigEndian()) {
                        return SampleTypes.Double64Msb;
                    }
                    return SampleTypes.Double64Lsb;
                }
            }
        }
        return null;
    }

    public static AudioFormat createAudioFormat(SoundFormat format) throws Exception {
        int channels = format.getChannels();
        float frameRate = format.getFrameRate();
        SampleType sampleType = format.getSampleType();
        float sampleRate = frameRate;
        int sampleSizeInBits = sampleType.getSampleBits();
        int frameSize = sampleType.getSampleSize() * channels;
        boolean bigEndian = sampleType.isBigEndian();
        AudioFormat.Encoding encoding = sampleType.isFloating() ? PCM_FLOAT : PCM_SIGNED;
        if (!sampleType.isSigned()) {
            return null;
        }
        AudioFormat audioFormat = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
        return audioFormat;
    }

    protected static class PcmFloatEncoding
    extends AudioFormat.Encoding {
        protected PcmFloatEncoding(String name) {
            super(name);
        }
    }
}

