/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.file;

import com.spacekiller.util.Tools;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.midi.file.TrackModelFile;
import com.spacekiller.util.midi.file.TrackModelPart;
import com.spacekiller.util.midi.list.ListTrackModel;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.NodeDispatcher;
import com.spacekiller.util.midi.model.NodeListener;
import com.spacekiller.util.midi.model.TrackModel;
import com.spacekiller.util.midi.model.TrackNode;
import com.spacekiller.util.midi.tree.TreeTrackModel;
import java.util.Collection;

public class FileTrackModel
implements TrackModel {
    public static final int PART_MODEL_TYPE_LIST = 1;
    public static final int PART_MODEL_TYPE_TREE = 2;
    protected final int partModelType;
    protected final TrackModelFile trackModelFile;
    protected int maxLoadedParts;
    protected int ticksPerPart;
    protected final TrackModel dummyModel;
    protected final LockFactory lockFactory;
    protected final boolean fair;
    protected final ReadWriteLock lock;
    protected final SearchNode searchNode = new SearchNode();
    protected final NodeRemover nodeRemover = new NodeRemover();
    protected final NodeDispatcher nodeDispatcher;
    protected TrackModelPart[] partArray;
    protected int partCount;
    protected TrackModelPart firstLoaded;
    protected TrackModelPart lastLoaded;
    protected int loadedCount;
    protected TrackModelPart firstDirty;
    protected TrackModelPart lastDirty;
    protected int nodeCount;
    protected TrackNode firstNode;
    protected long firstTick;
    protected TrackNode lastNode;
    protected long lastTick;

    public FileTrackModel(int partModelType, TrackModelFile trackModelFile, int initPartCapacity, int maxLoadedParts, int ticksPerPart, LockFactory lockFactory, boolean fair) {
        if (initPartCapacity < 1) {
            throw new IllegalArgumentException("initPartCapacity: " + initPartCapacity + " < 1");
        }
        if (maxLoadedParts < 1) {
            throw new IllegalArgumentException("maxLoadedParts: " + maxLoadedParts + " < 1");
        }
        if (ticksPerPart < 1) {
            throw new IllegalArgumentException("ticksPerPart: " + ticksPerPart + " < 1");
        }
        this.lockFactory = lockFactory;
        this.fair = fair;
        this.lock = lockFactory.createReadWriteLock(fair);
        this.nodeDispatcher = new NodeDispatcher();
        this.partModelType = partModelType;
        this.trackModelFile = trackModelFile;
        this.maxLoadedParts = maxLoadedParts;
        this.ticksPerPart = ticksPerPart;
        this.dummyModel = this.createPartTrackModel(1, partModelType);
        int numParts = trackModelFile.getPartCount();
        if (numParts > initPartCapacity) {
            initPartCapacity = numParts;
        }
        this.partArray = new TrackModelPart[initPartCapacity];
        for (int i = 0; i < numParts; ++i) {
            TrackModelPart part = trackModelFile.getPartAt(i);
            int numNodes = part.nodeCount;
            if (numNodes < 1) continue;
            this.partArray[this.partCount++] = part;
            this.nodeCount += numNodes;
        }
        this.adjustFirst();
        this.adjustLast();
    }

    public String toString() {
        return super.toString() + "[" + this.trackModelFile + "]";
    }

    protected int partIndexFor(long tick) {
        int lo = 0;
        int hi = this.partCount - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            TrackModelPart part = this.partArray[i];
            if (tick < part.tickOfs) {
                hi = i - 1;
                continue;
            }
            if (tick >= part.tickEnd) {
                lo = i + 1;
                continue;
            }
            lo = i;
            break;
        }
        return lo;
    }

    protected int partIndexOf(long tick) {
        int index = this.partIndexFor(tick);
        if (index < this.partCount) {
            TrackModelPart part = this.partArray[index];
            if (tick >= part.tickOfs && tick < part.tickEnd) {
                return index;
            }
        }
        return -1;
    }

    protected TrackModel createPartTrackModel(int initCapacity) {
        if (initCapacity < 32) {
            initCapacity = 32;
        }
        return this.createPartTrackModel(initCapacity, this.partModelType);
    }

    protected TrackModel createPartTrackModel(int initCapacity, int partModelType) {
        switch (partModelType) {
            case 1: {
                return new ListTrackModel(initCapacity);
            }
            case 2: {
                return new TreeTrackModel();
            }
        }
        throw new IllegalArgumentException("Invalid partModelType: " + partModelType);
    }

    protected TrackModelPart alloc(int index, long tick) {
        TrackModelPart part;
        long tickOfs = tick - Tools.floorMod((long)tick, (long)this.ticksPerPart);
        long tickEnd = tickOfs + (long)this.ticksPerPart;
        if (index > 0) {
            part = this.partArray[index - 1];
            if (tickOfs < part.tickEnd) {
                tickOfs = part.tickEnd;
                tickEnd = tickOfs + (long)this.ticksPerPart;
            }
        }
        if (index < this.partCount) {
            part = this.partArray[index];
            if (tickEnd > part.tickOfs) {
                tickEnd = part.tickOfs;
            }
        }
        if (tickOfs > tick) {
            throw new IllegalStateException("tickOfs=" + tickOfs + " > " + tick);
        }
        if (tickEnd <= tick) {
            throw new IllegalStateException("tickEnd=" + tickEnd + " <= " + tick);
        }
        try {
            part = this.trackModelFile.createPart(tickOfs, tickEnd);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.partCount < this.partArray.length) {
            if (index < this.partCount) {
                System.arraycopy(this.partArray, index, this.partArray, index + 1, this.partCount - index);
            }
            this.partArray[index] = part;
        } else {
            TrackModelPart[] arr = new TrackModelPart[this.partCount * 2];
            if (index > 0) {
                System.arraycopy(this.partArray, 0, arr, 0, index);
            }
            if (index < this.partCount) {
                System.arraycopy(this.partArray, index, arr, index + 1, this.partCount - index);
            }
            arr[index] = part;
            this.partArray = arr;
        }
        ++this.partCount;
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(int index, TrackModelPart part) {
        part.trackModel = null;
        part.loaded = false;
        FileTrackModel fileTrackModel = this;
        synchronized (fileTrackModel) {
            if (part.dirty) {
                if (part.prevDirty == null) {
                    this.firstDirty = part.nextDirty;
                } else {
                    part.prevDirty.nextDirty = part.nextDirty;
                }
                if (part.nextDirty == null) {
                    this.lastDirty = part.prevDirty;
                } else {
                    part.nextDirty.prevDirty = part.prevDirty;
                }
                part.prevDirty = null;
                part.nextDirty = null;
                part.dirty = false;
            }
            --this.partCount;
            if (index < this.partCount) {
                System.arraycopy(this.partArray, index + 1, this.partArray, index, this.partCount - index);
            }
        }
        try {
            this.trackModelFile.deletePart(part);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(TrackModelPart part) {
        TrackModelPart trackModelPart = part;
        synchronized (trackModelPart) {
            if (part.loaded) {
                return;
            }
            FileTrackModel fileTrackModel = this;
            synchronized (fileTrackModel) {
                while (this.loadedCount >= this.maxLoadedParts) {
                    TrackModelPart other = this.firstLoaded;
                    while (other != null) {
                        if (other.lock.tryLockWrite()) {
                            try {
                                this.unload(other);
                                break;
                            }
                            finally {
                                other.lock.unlockWrite();
                            }
                        }
                        other = other.nextLoaded;
                    }
                    if (this.loadedCount < this.maxLoadedParts || (other = this.firstLoaded) == null) continue;
                    other.lock.lockWrite();
                    try {
                        this.unload(other);
                        break;
                    }
                    finally {
                        other.lock.unlockWrite();
                    }
                }
            }
            try {
                int initCapacity = part.nodeCount;
                TrackModel trackModel = this.createPartTrackModel(initCapacity);
                if (part.blockOfs == 0L) {
                    part.trackModel = trackModel;
                } else {
                    this.trackModelFile.loadPart(part, trackModel);
                    part.trackModel = trackModel;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.markLoaded(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unload(TrackModelPart part) {
        if (part.dirty) {
            this.save(part);
        }
        FileTrackModel fileTrackModel = this;
        synchronized (fileTrackModel) {
            if (part.prevLoaded == null) {
                this.firstLoaded = part.nextLoaded;
            } else {
                part.prevLoaded.nextLoaded = part.nextLoaded;
            }
            if (part.nextLoaded == null) {
                this.lastLoaded = part.prevLoaded;
            } else {
                part.nextLoaded.prevLoaded = part.prevLoaded;
            }
            part.prevLoaded = null;
            part.nextLoaded = null;
            part.loaded = false;
            part.trackModel = null;
            --this.loadedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(TrackModelPart part) {
        FileTrackModel fileTrackModel = this;
        synchronized (fileTrackModel) {
            if (!part.dirty) {
                return;
            }
            if (part.prevDirty == null) {
                this.firstDirty = part.nextDirty;
            } else {
                part.prevDirty.nextDirty = part.nextDirty;
            }
            if (part.nextDirty == null) {
                this.lastDirty = part.prevDirty;
            } else {
                part.nextDirty.prevDirty = part.prevDirty;
            }
            part.prevDirty = null;
            part.nextDirty = null;
            part.dirty = false;
        }
        try {
            this.trackModelFile.savePart(part);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void flush() {
        block11: {
            this.lock.lockRead();
            while (true) lbl-1000:
            // 3 sources

            {
                var2_2 = this;
                synchronized (var2_2) {
                    part = this.firstDirty;
                    if (part == null) {
                        break block11;
                    }
                }
                try {
                    part.lock.lockRead();
                    this.save(part);
                }
                finally {
                    part.lock.unlockRead();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                this.lock.unlockRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.lock.lockWrite();
            this.flush();
            try {
                this.trackModelFile.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    protected synchronized void markLoaded(TrackModelPart part) {
        if (part.loaded) {
            return;
        }
        part.prevLoaded = this.lastLoaded;
        if (this.lastLoaded == null) {
            this.firstLoaded = part;
        } else {
            this.lastLoaded.nextLoaded = part;
        }
        this.lastLoaded = part;
        part.loaded = true;
        ++this.loadedCount;
    }

    protected synchronized void markDirty(TrackModelPart part) {
        if (part.dirty) {
            return;
        }
        part.prevDirty = this.lastDirty;
        if (this.lastDirty == null) {
            this.firstDirty = part;
        } else {
            this.lastDirty.nextDirty = part;
        }
        this.lastDirty = part;
        part.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        try {
            this.lock.lockRead();
            boolean bl = this.nodeCount < 1;
            return bl;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNodeCount() {
        try {
            this.lock.lockRead();
            int n = this.nodeCount;
            return n;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNodeCount(long ofs, long end) {
        int count = 0;
        try {
            this.lock.lockRead();
            for (int index = this.partIndexFor(ofs); index < this.partCount; ++index) {
                int cnt;
                TrackModelPart part = this.partArray[index];
                if (part.tickOfs >= end) {
                    break;
                }
                try {
                    part.lock.lockRead();
                    if (!part.loaded) {
                        this.load(part);
                    }
                    cnt = part.trackModel.getNodeCount(ofs, end);
                }
                finally {
                    part.lock.unlockRead();
                }
                if (cnt <= 0) continue;
                count += cnt;
            }
        }
        finally {
            this.lock.unlockRead();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNodes(long ofs, long end, NodeConsumer dst) {
        int count = 0;
        try {
            this.lock.lockRead();
            for (int index = this.partIndexFor(ofs); index < this.partCount; ++index) {
                int cnt;
                TrackModelPart part = this.partArray[index];
                if (part.tickOfs >= end) {
                    break;
                }
                try {
                    part.lock.lockRead();
                    if (!part.loaded) {
                        this.load(part);
                    }
                    cnt = part.trackModel.getNodes(ofs, end, dst);
                }
                finally {
                    part.lock.unlockRead();
                }
                if (cnt <= 0) continue;
                count += cnt;
            }
        }
        finally {
            this.lock.unlockRead();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNodes(long ofs, long end, Node[] dst, int x, int z) {
        int count = 0;
        try {
            this.lock.lockRead();
            for (int index = this.partIndexFor(ofs); index < this.partCount; ++index) {
                int cnt;
                TrackModelPart part = this.partArray[index];
                if (part.tickOfs >= end) {
                    break;
                }
                try {
                    part.lock.lockRead();
                    if (!part.loaded) {
                        this.load(part);
                    }
                    cnt = part.trackModel.getNodes(ofs, end, dst, x, z);
                }
                finally {
                    part.lock.unlockRead();
                }
                if (cnt < 0) {
                    int n = -1;
                    return n;
                }
                x += cnt;
                count += cnt;
            }
        }
        finally {
            this.lock.unlockRead();
        }
        return count;
    }

    @Override
    public TrackNode newNode(long tick, TrackNode node) {
        return this.dummyModel.newNode(tick, node);
    }

    @Override
    public TrackNode newNode(long tick, int status) {
        return this.dummyModel.newNode(tick, status);
    }

    @Override
    public TrackNode newNode(long tick, int status, int data1) {
        return this.dummyModel.newNode(tick, status, data1);
    }

    @Override
    public TrackNode newNode(long tick, int status, int data1, int data2) {
        return this.dummyModel.newNode(tick, status, data1, data2);
    }

    @Override
    public TrackNode newNode(long tick, int status, byte[] data, int off, int len) {
        return this.dummyModel.newNode(tick, status, data, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addNode(TrackNode node) {
        long tick = node.getTick();
        try {
            TrackModelPart part;
            this.lock.lockWrite();
            int index = this.partIndexFor(tick);
            if (index < this.partCount) {
                part = this.partArray[index];
                if (tick >= part.tickOfs && tick < part.tickEnd) {
                    boolean bl = this.addNode(tick, node, part);
                    return bl;
                }
            }
            if (!this.addNode(tick, node, part = this.alloc(index, tick))) {
                this.delete(index, part);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addNode(long tick, TrackNode node, TrackModelPart part) {
        try {
            part.lock.lockWrite();
            if (!part.loaded) {
                this.load(part);
            }
            if (!part.trackModel.addNode(node)) {
                boolean bl = false;
                return bl;
            }
            this.markDirty(part);
        }
        finally {
            part.lock.unlockWrite();
        }
        if (this.nodeCount < 1) {
            this.firstNode = node;
            this.firstTick = tick;
            this.lastNode = node;
            this.lastTick = tick;
        } else {
            if (tick < this.firstTick) {
                this.firstNode = node;
                this.firstTick = tick;
            }
            if (tick >= this.lastTick) {
                this.lastNode = node;
                this.lastTick = tick;
            }
        }
        ++this.nodeCount;
        this.nodeDispatcher.fireNodeAdded(node);
        return true;
    }

    @Override
    public int addNodes(long ofs, long end, Collection nodes) {
        int count = 0;
        for (TrackNode node : nodes) {
            long tick = node.getTick();
            if (tick < ofs || tick >= end || !this.addNode(node)) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(TrackNode node) {
        long tick = node.getTick();
        try {
            this.lock.lockWrite();
            int index = this.partIndexOf(tick);
            if (index < 0) {
                boolean bl = false;
                return bl;
            }
            TrackModelPart part = this.partArray[index];
            try {
                part.lock.lockWrite();
                if (!part.loaded) {
                    this.load(part);
                }
                if (!part.trackModel.removeNode(node)) {
                    this.searchNode.src = node;
                    this.searchNode.fnd = null;
                    part.trackModel.getNodes(tick, tick + 1L, this.searchNode);
                    node = this.searchNode.fnd;
                    if (node == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!part.trackModel.removeNode(node)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                if (part.trackModel.isEmpty()) {
                    this.delete(index, part);
                } else {
                    this.markDirty(part);
                }
            }
            finally {
                part.lock.unlockWrite();
            }
            --this.nodeCount;
            if (this.nodeCount < 1) {
                this.firstNode = null;
                this.lastNode = null;
            } else {
                if (tick == this.firstTick) {
                    this.adjustFirst();
                }
                if (tick == this.lastTick) {
                    this.adjustLast();
                }
            }
            this.nodeDispatcher.fireNodeRemoved(node);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustFirst() {
        if (this.partCount < 1) {
            this.firstNode = null;
            return;
        }
        TrackModelPart part = this.partArray[0];
        try {
            part.lock.lockRead();
            if (!part.loaded) {
                this.load(part);
            }
            this.firstNode = (TrackNode)part.trackModel.getFirst();
            this.firstTick = this.firstNode.getTick();
        }
        finally {
            part.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustLast() {
        if (this.partCount < 1) {
            this.lastNode = null;
            return;
        }
        TrackModelPart part = this.partArray[this.partCount - 1];
        try {
            part.lock.lockRead();
            if (!part.loaded) {
                this.load(part);
            }
            this.lastNode = (TrackNode)part.trackModel.getLast();
            this.lastTick = this.lastNode.getTick();
        }
        finally {
            part.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeNodes(long ofs, long end) {
        int count = 0;
        try {
            this.lock.lockWrite();
            for (int index = this.partIndexFor(ofs); index < this.partCount; ++index) {
                TrackModelPart part = this.partArray[index];
                if (part.tickOfs >= end) break;
                try {
                    int cnt;
                    part.lock.lockWrite();
                    if (!part.loaded) {
                        this.load(part);
                    }
                    if ((cnt = part.trackModel.removeNodes(ofs, end, this.nodeRemover)) <= 0) continue;
                    count += cnt;
                    if (part.trackModel.isEmpty()) {
                        this.delete(index, part);
                        --index;
                        continue;
                    }
                    this.markDirty(part);
                    continue;
                }
                finally {
                    part.lock.unlockWrite();
                }
            }
            if (count > 0) {
                this.nodeCount -= count;
                if (ofs <= this.firstTick) {
                    this.adjustFirst();
                }
                if (end > this.lastTick) {
                    this.adjustLast();
                }
            }
        }
        finally {
            this.lock.unlockWrite();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeNodes(long ofs, long end, NodeConsumer dst) {
        NodeRemoverConsumer remover = new NodeRemoverConsumer(dst);
        int count = 0;
        try {
            this.lock.lockWrite();
            for (int index = this.partIndexFor(ofs); index < this.partCount; ++index) {
                TrackModelPart part = this.partArray[index];
                if (part.tickOfs >= end) break;
                try {
                    int cnt;
                    part.lock.lockWrite();
                    if (!part.loaded) {
                        this.load(part);
                    }
                    if ((cnt = part.trackModel.removeNodes(ofs, end, remover)) <= 0) continue;
                    count += cnt;
                    if (part.trackModel.isEmpty()) {
                        this.delete(index, part);
                        --index;
                        continue;
                    }
                    this.markDirty(part);
                    continue;
                }
                finally {
                    part.lock.unlockWrite();
                }
            }
            if (count > 0) {
                this.nodeCount -= count;
                if (ofs <= this.firstTick) {
                    this.adjustFirst();
                }
                if (end > this.lastTick) {
                    this.adjustLast();
                }
            }
        }
        finally {
            this.lock.unlockWrite();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getFirst() {
        try {
            this.lock.lockRead();
            TrackNode trackNode = this.firstNode;
            return trackNode;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getLast() {
        try {
            this.lock.lockRead();
            TrackNode trackNode = this.lastNode;
            return trackNode;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getAfter(long tick) {
        try {
            this.lock.lockRead();
            for (int index = this.partIndexFor(tick); index < this.partCount; ++index) {
                TrackModelPart part = this.partArray[index];
                try {
                    TrackNode node;
                    part.lock.lockRead();
                    if (!part.loaded) {
                        this.load(part);
                    }
                    if ((node = (TrackNode)part.trackModel.getAfter(tick)) != null) {
                        TrackNode trackNode = node;
                        return trackNode;
                    }
                    if (tick >= part.tickEnd) continue;
                    Node node2 = null;
                    return node2;
                }
                finally {
                    part.lock.unlockRead();
                }
            }
            Node node = null;
            return node;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getBefore(long tick) {
        try {
            this.lock.lockRead();
            for (int index = this.partIndexFor(tick - 1L); index >= 0; --index) {
                TrackModelPart part = this.partArray[index];
                try {
                    TrackNode node;
                    part.lock.lockRead();
                    if (!part.loaded) {
                        this.load(part);
                    }
                    if ((node = (TrackNode)part.trackModel.getBefore(tick)) != null) {
                        TrackNode trackNode = node;
                        return trackNode;
                    }
                    if (tick < part.tickOfs) continue;
                    Node node2 = null;
                    return node2;
                }
                finally {
                    part.lock.unlockRead();
                }
            }
            Node node = null;
            return node;
        }
        finally {
            this.lock.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIntegrity() throws IllegalStateException {
        try {
            this.lock.lockRead();
            long count = 0L;
            for (int index = 0; index < this.partCount; ++index) {
                TrackModelPart part = this.partArray[index];
                try {
                    part.lock.lockRead();
                    if (!part.loaded) {
                        this.load(part);
                    }
                    part.trackModel.checkIntegrity();
                    count += (long)part.trackModel.getNodeCount();
                    continue;
                }
                finally {
                    part.lock.unlockRead();
                }
            }
            if ((long)this.nodeCount != count) {
                throw new IllegalStateException("Invalid nodeCount: " + this.nodeCount + " != " + count);
            }
        }
        finally {
            this.lock.unlockRead();
        }
        this.trackModelFile.checkIntegrity();
    }

    @Override
    public void registerNodeListener(NodeListener listener) {
        this.nodeDispatcher.addNodeListener(listener);
    }

    @Override
    public void unregisterNodeListener(NodeListener listener) {
        this.nodeDispatcher.removeNodeListener(listener);
    }

    protected static class SearchNode
    implements NodeConsumer {
        protected TrackNode src;
        protected TrackNode fnd;

        protected SearchNode() {
        }

        @Override
        public boolean consume(Node node) {
            TrackNode n = (TrackNode)node;
            if (this.src.compare(n)) {
                this.fnd = n;
                return false;
            }
            return true;
        }
    }

    protected class NodeRemoverConsumer
    extends NodeRemover {
        final NodeConsumer cons;

        public NodeRemoverConsumer(NodeConsumer cons) {
            this.cons = cons;
        }

        @Override
        public boolean consume(Node node) {
            if (!this.cons.consume(node)) {
                return false;
            }
            return super.consume(node);
        }
    }

    protected class NodeRemover
    implements NodeConsumer {
        protected NodeRemover() {
        }

        @Override
        public boolean consume(Node node) {
            FileTrackModel.this.nodeDispatcher.fireNodeRemoved(node);
            return true;
        }
    }
}

