/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.file;

import com.spacekiller.util.Data;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.ReadWriteLock;
import com.spacekiller.util.midi.file.TrackModelFile;
import com.spacekiller.util.midi.file.TrackModelFrag;
import com.spacekiller.util.midi.file.TrackModelHole;
import com.spacekiller.util.midi.file.TrackModelPart;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.TrackModel;
import com.spacekiller.util.midi.model.TrackNode;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TrackModelFileImpl
implements TrackModelFile {
    private static final Logger logger = Logger.getLogger(TrackModelFileImpl.class.getName());
    public static final String TRACK_MODEL_FILE_EXTENSION = ".wlm";
    private static final byte[] HEADER_MAGIC = "WlMd".getBytes();
    public static final int VERSION_0 = 0;
    public static final int VERSION = 0;
    public static final byte CLEAN = 117;
    public static final byte DIRTY = 39;
    public static final byte TAG_BLOCK = -77;
    public static final byte TAG_HOLE = -96;
    public static final byte TAG_FOOTER = -2;
    public static final byte TAG_NODE = -32;
    public static final byte TAG_NODE1 = -31;
    public static final byte TAG_NODE2 = -30;
    public static final byte TAG_NODE3 = -29;
    public static final byte TAG_END = -64;
    public static final int MAGIC_LEN = 4;
    public static final int HEAD_OFS_VERSION = 4;
    public static final int HEAD_OFS_DIRTY = 8;
    public static final int HEAD_OFS_RES1 = 9;
    public static final int HEAD_OFS_FIRST = 10;
    public static final int HEAD_OFS_TICKRATE = 18;
    public static final int HEADER_LEN = 22;
    public static final int BLOCK_OFS_DIRTY = 0;
    public static final int BLOCK_OFS_TAG = 1;
    public static final int BLOCK_OFS_NEXT = 2;
    public static final int BLOCK_OFS_TICKOFS = 10;
    public static final int BLOCK_OFS_TICKEND = 18;
    public static final int BLOCK_OFS_NODECOUNT = 26;
    public static final int BLOCK_OFS_DATALEN = 30;
    public static final int BLOCK_HEADER_LEN = 34;
    public static final int HOLE_HEADER_LEN = 10;
    public static final int FOOTER_LEN = 10;
    public static final int PART_INIT_CAPACITY = 8;
    public static final int BUF_INIT_SIZE = 1024;
    public static final int MAX_SYSEX_DATA_LEN = 0x800000;
    protected final LockFactory lockFactory;
    protected final boolean fair;
    private final boolean readOnly;
    private final File file;
    private RandomAccessFile raf;
    private int version;
    private float tickRate;
    private long firstOfs;
    private long footerOfs;
    private TrackModelPart[] parts;
    private int partCount;
    private TrackModelFrag firstFrag;
    private TrackModelFrag lastFrag;
    private TrackModelPart firstPart;
    private TrackModelPart lastPart;
    private TrackModelHole firstHole;
    private TrackModelHole lastHole;
    private final NodeWriter nodeWriter;
    protected byte[] buf;

    public TrackModelFileImpl(File file, boolean readOnly, int bufInitSize, LockFactory lockFactory, boolean fair) throws IOException {
        this.lockFactory = lockFactory;
        this.fair = fair;
        this.readOnly = readOnly;
        this.file = file;
        RandomAccessFile raf = readOnly ? new RandomAccessFile(file, "r") : new RandomAccessFile(file, "rw");
        this.raf = raf;
        this.version = 0;
        int partInitCapacity = 8;
        this.parts = new TrackModelPart[partInitCapacity];
        if (bufInitSize < 22) {
            bufInitSize = 22;
        }
        if (bufInitSize < 34) {
            bufInitSize = 34;
        }
        this.buf = new byte[bufInitSize];
        this.nodeWriter = new NodeWriter();
        this.firstOfs = -1L;
        this.footerOfs = -1L;
        if (raf.length() > 0L) {
            this.readFileStructure();
        } else {
            this.footerOfs = this.firstOfs = 22L;
            this.writeFileHeader();
            this.writeFileFooter();
        }
    }

    public String toString() {
        return super.toString() + "[file=" + this.file + "]";
    }

    @Override
    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTrackModelFile(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            raf.seek(0L);
            if (raf.length() < (long)HEADER_MAGIC.length) {
                boolean bl = false;
                return bl;
            }
            byte[] magic = new byte[HEADER_MAGIC.length];
            raf.readFully(magic);
            boolean bl = Arrays.equals(magic, HEADER_MAGIC);
            return bl;
        }
        finally {
            raf.close();
        }
    }

    protected synchronized void readFileStructure() throws IOException {
        boolean dirtyHeader;
        byte[] buf = new byte[Math.max(22, 34)];
        this.raf.seek(0L);
        this.raf.readFully(buf, 0, 22);
        for (int i = 0; i < 4; ++i) {
            if (buf[i] == HEADER_MAGIC[i]) continue;
            throw new StreamCorruptedException("Invalid track model file magic: #" + i);
        }
        this.version = Data.getInt((byte[])buf, (int)4);
        if (this.version < 0 || this.version > 0) {
            throw new StreamCorruptedException("Unsupported track model file version: " + this.version + ", current=" + 0);
        }
        boolean bl = dirtyHeader = buf[8] != 117;
        if (dirtyHeader) {
            throw new StreamCorruptedException("Header is dirty!");
        }
        this.firstOfs = Data.getLong((byte[])buf, (int)10);
        if (this.firstOfs != 22L) {
            throw new StreamCorruptedException("Unexpected first block offset: " + this.firstOfs + " != " + 22);
        }
        this.tickRate = Data.getFloat((byte[])buf, (int)18);
        long fragOfs = this.firstOfs;
        TrackModelFrag prevFrag = null;
        TrackModelPart prevPart = null;
        TrackModelHole prevHole = null;
        while (true) {
            this.raf.seek(fragOfs);
            this.raf.readFully(buf, 0, 10);
            boolean dirtyFrag = buf[0] != 117;
            byte tag = buf[1];
            long nextOfs = Data.getLong((byte[])buf, (int)2);
            if (dirtyFrag) {
                throw new StreamCorruptedException("Fragment is dirty: fragOfs=" + fragOfs + ", tag=" + tag);
            }
            if (nextOfs < fragOfs + 10L) {
                throw new StreamCorruptedException("Invalid next fragment offset: " + nextOfs + " < " + (fragOfs + 10L) + ", fragOfs=" + fragOfs);
            }
            switch (tag) {
                case -77: {
                    this.raf.readFully(buf, 10, 24);
                    long tickOfs = Data.getLong((byte[])buf, (int)10);
                    long tickEnd = Data.getLong((byte[])buf, (int)18);
                    int nodeCount = Data.getInt((byte[])buf, (int)26);
                    int dataLen = Data.getInt((byte[])buf, (int)30);
                    if (tickOfs >= tickEnd) {
                        throw new StreamCorruptedException("Invalid block tick range: " + tickOfs + " >= " + tickEnd + ", fragOfs=" + fragOfs);
                    }
                    if ((long)dataLen != nextOfs - fragOfs) {
                        throw new StreamCorruptedException("Invalid block dataLen: " + dataLen + " != " + (nextOfs - fragOfs) + ", fragOfs=" + fragOfs);
                    }
                    TrackModelPart part = this.createPart(tickOfs, tickEnd);
                    part.blockOfs = fragOfs;
                    part.blockEnd = nextOfs;
                    part.nodeCount = nodeCount;
                    part.prevFrag = prevFrag;
                    part.prevPart = prevPart;
                    if (prevFrag == null) {
                        this.firstFrag = part;
                    } else {
                        prevFrag.nextFrag = part;
                    }
                    if (prevPart == null) {
                        this.firstPart = part;
                    } else {
                        prevPart.nextPart = part;
                    }
                    prevFrag = part;
                    prevPart = part;
                    break;
                }
                case -96: {
                    TrackModelHole hole = new TrackModelHole();
                    hole.blockOfs = fragOfs;
                    hole.blockEnd = nextOfs;
                    hole.prevFrag = prevFrag;
                    hole.prevHole = prevHole;
                    if (prevFrag == null) {
                        this.firstFrag = hole;
                    } else {
                        prevFrag.nextFrag = hole;
                    }
                    if (prevHole == null) {
                        this.firstHole = hole;
                    } else {
                        prevHole.nextHole = hole;
                    }
                    prevFrag = hole;
                    prevHole = hole;
                    break;
                }
                case -2: {
                    nextOfs = 0L;
                    break;
                }
                default: {
                    throw new StreamCorruptedException("Invalid block header tag " + tag + " at offset " + fragOfs);
                }
            }
            if (nextOfs == 0L) break;
            fragOfs = nextOfs;
        }
        this.footerOfs = fragOfs;
        this.lastFrag = prevFrag;
        this.lastPart = prevPart;
        this.lastHole = prevHole;
    }

    protected synchronized void writeFileHeader() throws IOException {
        byte[] buf = new byte[22];
        System.arraycopy(HEADER_MAGIC, 0, buf, 0, 4);
        Data.setInt((byte[])buf, (int)4, (int)0);
        buf[8] = 39;
        buf[9] = 0;
        Data.setLong((byte[])buf, (int)10, (long)this.firstOfs);
        Data.setFloat((byte[])buf, (int)18, (float)this.tickRate);
        this.raf.seek(0L);
        this.raf.write(buf, 0, 22);
        this.raf.seek(8L);
        this.raf.write(117);
    }

    protected synchronized void writeFileFooter() throws IOException {
        long fileSize = this.footerOfs + 10L;
        this.raf.seek(this.footerOfs);
        this.raf.write(39);
        this.raf.write(-2);
        this.raf.writeLong(fileSize);
        this.raf.setLength(fileSize);
        this.raf.seek(this.footerOfs);
        this.raf.write(117);
    }

    @Override
    public synchronized int getPartCount() {
        return this.partCount;
    }

    @Override
    public synchronized TrackModelPart getPartAt(int index) {
        return this.parts[index];
    }

    protected int partIndexFor(long tick) {
        int lo = 0;
        int hi = this.partCount - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            TrackModelPart part = this.parts[i];
            if (tick < part.tickOfs) {
                hi = i - 1;
                continue;
            }
            if (tick >= part.tickEnd) {
                lo = i + 1;
                continue;
            }
            lo = i;
            break;
        }
        return lo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackModelPart createPart(long tickOfs, long tickEnd) throws IOException {
        if (tickOfs >= tickEnd) {
            throw new IllegalArgumentException("Invalid tick range: tickOfs" + tickOfs + ", tickEnd=" + tickEnd);
        }
        ReadWriteLock partLock = this.lockFactory.createReadWriteLock(this.fair);
        TrackModelPart part = new TrackModelPart(partLock, tickOfs, tickEnd);
        part.blockOfs = 0L;
        TrackModelFileImpl trackModelFileImpl = this;
        synchronized (trackModelFileImpl) {
            int index = this.partIndexFor(tickOfs);
            if (this.partCount < this.parts.length) {
                if (index < this.partCount) {
                    System.arraycopy(this.parts, index, this.parts, index + 1, this.partCount - index);
                }
                this.parts[index] = part;
            } else {
                TrackModelPart[] arr = new TrackModelPart[this.partCount * 2];
                if (index > 0) {
                    System.arraycopy(this.parts, 0, arr, 0, index);
                }
                if (index < this.partCount) {
                    System.arraycopy(this.parts, index, arr, index + 1, this.partCount - index);
                }
                arr[index] = part;
                this.parts = arr;
            }
            ++this.partCount;
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadPart(TrackModelPart part, TrackModel trackModel) throws IOException {
        TrackModelFileImpl trackModelFileImpl = this;
        synchronized (trackModelFileImpl) {
            long ofs = part.blockOfs;
            if (ofs < 1L) {
                return;
            }
            int numBytes = (int)(part.blockEnd - ofs);
            if (numBytes > this.buf.length) {
                this.buf = new byte[numBytes];
            }
            this.raf.seek(ofs);
            this.raf.readFully(this.buf, 0, numBytes);
            int numNodes = 0;
            long ptck = part.tickOfs;
            int off = 34;
            block10: while (off < numBytes) {
                switch (this.buf[off]) {
                    case -29: {
                        int rtck = Data.getInt((byte[])this.buf, (int)(++off));
                        off += 4;
                        int status = this.buf[off++] & 0xFF;
                        int data1 = this.buf[off++] & 0xFF;
                        int data2 = this.buf[off++] & 0xFF;
                        trackModel.addNode(trackModel.newNode(ptck + (long)rtck, status, data1, data2));
                        ++numNodes;
                        continue block10;
                    }
                    case -30: {
                        int rtck = Data.getInt((byte[])this.buf, (int)(++off));
                        off += 4;
                        int status = this.buf[off++] & 0xFF;
                        int data1 = this.buf[off++] & 0xFF;
                        trackModel.addNode(trackModel.newNode(ptck + (long)rtck, status, data1));
                        ++numNodes;
                        continue block10;
                    }
                    case -31: {
                        int rtck = Data.getInt((byte[])this.buf, (int)(++off));
                        off += 4;
                        int status = this.buf[off++] & 0xFF;
                        trackModel.addNode(trackModel.newNode(ptck + (long)rtck, status));
                        ++numNodes;
                        continue block10;
                    }
                    case -32: {
                        int rtck = Data.getInt((byte[])this.buf, (int)(++off));
                        int datLen = Data.getInt((byte[])this.buf, (int)(off += 4));
                        off += 4;
                        if (datLen < 1 || datLen > 0x800000) {
                            throw new StreamCorruptedException("Invalid sysex-data length: " + datLen);
                        }
                        byte[] dat = new byte[datLen];
                        System.arraycopy(this.buf, off, dat, 0, datLen);
                        off += datLen;
                        int status = dat[0] & 0xFF;
                        trackModel.addNode(trackModel.newNode(ptck + (long)rtck, status, dat, 0, datLen));
                        ++numNodes;
                        continue block10;
                    }
                    case -64: {
                        break block10;
                    }
                    default: {
                        throw new StreamCorruptedException("Invalid node tag: part=" + part + ", off=" + off + ", tag=0x" + Integer.toHexString(this.buf[off] & 0xFF));
                    }
                }
            }
            part.nodeCount = numNodes;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded part: " + part);
        }
    }

    private IOException failReadOnly() {
        return new IOException("TrackModelFile is read-only: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePart(TrackModelPart part) throws IOException {
        if (this.readOnly) {
            throw this.failReadOnly();
        }
        TrackModelFileImpl trackModelFileImpl = this;
        synchronized (trackModelFileImpl) {
            TrackModel model = part.trackModel;
            int nodeCount = model.getNodeCount();
            this.nodeWriter.reset(part, nodeCount);
            int numNodes = model.getNodes(part.tickOfs, part.tickEnd, this.nodeWriter);
            int numBytes = this.nodeWriter.off;
            part.nodeCount = nodeCount;
            if (part.blockOfs != 0L) {
                this.makeHole(part);
            }
            int reqBytes = numBytes + 10;
            TrackModelHole hole = this.firstHole;
            while (hole != null && hole.blockEnd - hole.blockOfs <= (long)reqBytes) {
                hole = hole.nextHole;
            }
            if (hole == null) {
                long nextOfs;
                long newOfs = this.footerOfs;
                this.footerOfs = nextOfs = newOfs + (long)numBytes;
                this.writeFileFooter();
                part.blockOfs = newOfs;
                part.blockEnd = nextOfs;
                part.prevFrag = this.lastFrag;
                if (this.lastFrag == null) {
                    this.firstFrag = part;
                } else {
                    this.lastFrag.nextFrag = part;
                }
                this.lastFrag = part;
                part.prevPart = this.lastPart;
                if (this.lastPart == null) {
                    this.firstPart = part;
                } else {
                    this.lastPart.nextPart = part;
                }
                this.lastPart = part;
            } else {
                long nextOfs;
                long newOfs = hole.blockOfs;
                hole.blockOfs = nextOfs = newOfs + (long)numBytes;
                this.writeHole(hole);
                part.blockOfs = newOfs;
                part.blockEnd = nextOfs;
                part.prevPart = (TrackModelPart)hole.prevFrag;
                part.nextPart = (TrackModelPart)hole.nextFrag;
                part.prevFrag = hole.prevFrag;
                part.nextFrag = hole;
                hole.prevFrag = part;
                if (part.prevFrag == null) {
                    this.firstFrag = part;
                } else {
                    part.prevFrag.nextFrag = part;
                }
                if (part.prevPart == null) {
                    this.firstPart = part;
                } else {
                    part.prevPart.nextPart = part;
                }
                if (part.nextPart == null) {
                    this.lastPart = part;
                } else {
                    part.nextPart.prevPart = part;
                }
            }
            this.buf[0] = 39;
            this.buf[1] = -77;
            Data.setLong((byte[])this.buf, (int)2, (long)part.blockEnd);
            Data.setLong((byte[])this.buf, (int)10, (long)part.tickOfs);
            Data.setLong((byte[])this.buf, (int)18, (long)part.tickEnd);
            Data.setInt((byte[])this.buf, (int)26, (int)numNodes);
            Data.setInt((byte[])this.buf, (int)30, (int)numBytes);
            this.raf.seek(part.blockOfs);
            this.raf.write(this.buf, 0, numBytes);
            this.raf.seek(part.blockOfs);
            this.raf.write(117);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Saved part: " + part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePart(TrackModelPart part) throws IOException {
        if (this.readOnly) {
            throw this.failReadOnly();
        }
        TrackModelFileImpl trackModelFileImpl = this;
        synchronized (trackModelFileImpl) {
            int index = this.partIndexFor(part.tickOfs);
            if (index >= this.partCount) {
                throw new IllegalArgumentException("Part not found: " + part);
            }
            if (this.parts[index] != part) {
                throw new IllegalArgumentException("Part not found: " + part + ", index=" + index);
            }
            --this.partCount;
            if (index < this.partCount) {
                System.arraycopy(this.parts, index + 1, this.parts, index, this.partCount - index);
            }
            this.makeHole(part);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Deleted part: " + part);
        }
    }

    protected void makeHole(TrackModelPart part) throws IOException {
        if (part.blockOfs == 0L) {
            return;
        }
        TrackModelFrag pf = part.prevFrag;
        TrackModelFrag nf = part.nextFrag;
        if (nf == null) {
            if (part.blockEnd != this.footerOfs) {
                throw new IllegalStateException("Invalid last part end offset: " + part.blockEnd + " != " + this.footerOfs);
            }
            this.unlinkPart(part);
            if (pf != null && pf.isHole()) {
                this.unlinkHole((TrackModelHole)pf);
                this.footerOfs = pf.blockOfs;
            } else {
                this.footerOfs = part.blockOfs;
            }
            this.writeFileFooter();
            return;
        }
        if (pf != null && pf.isHole()) {
            TrackModelHole hole = (TrackModelHole)pf;
            if (nf != null && nf.isHole()) {
                hole.blockEnd = nf.blockEnd;
                this.unlinkPart(part);
                this.unlinkHole((TrackModelHole)nf);
                this.writeHole(hole);
                return;
            }
            hole.blockEnd = part.blockEnd;
            this.unlinkPart(part);
            this.writeHole(hole);
            return;
        }
        if (nf != null && nf.isHole()) {
            TrackModelHole hole = (TrackModelHole)nf;
            hole.blockOfs = part.blockOfs;
            this.unlinkPart(part);
            this.writeHole(hole);
            return;
        }
        TrackModelHole hole = new TrackModelHole();
        hole.blockOfs = part.blockOfs;
        hole.blockEnd = part.blockEnd;
        hole.prevFrag = part.prevFrag;
        hole.nextFrag = part.nextFrag;
        this.unlinkPart(part);
        if (hole.prevFrag == null) {
            this.firstFrag = hole;
        } else {
            hole.prevFrag.nextFrag = hole;
        }
        if (hole.nextFrag == null) {
            this.lastFrag = hole;
        } else {
            hole.nextFrag.prevFrag = hole;
        }
        hole.prevHole = this.findPrevHole(hole);
        hole.nextHole = this.findNextHole(hole);
        if (hole.prevHole == null) {
            this.firstHole = hole;
        } else {
            hole.prevHole.nextHole = hole;
        }
        if (hole.nextHole == null) {
            this.lastHole = hole;
        } else {
            hole.nextHole.prevHole = hole;
        }
        this.writeHole(hole);
    }

    protected void writeHole(TrackModelHole hole) throws IOException {
        this.buf[0] = 39;
        this.buf[1] = -96;
        Data.setLong((byte[])this.buf, (int)2, (long)hole.blockEnd);
        this.raf.seek(hole.blockOfs);
        this.raf.write(this.buf, 0, 10);
        this.raf.seek(hole.blockOfs);
        this.raf.write(117);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        TrackModelFileImpl trackModelFileImpl = this;
        synchronized (trackModelFileImpl) {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
        }
    }

    protected void unlinkPart(TrackModelPart part) {
        if (part.prevFrag == null) {
            this.firstFrag = part.nextFrag;
        } else {
            part.prevFrag.nextFrag = part.nextFrag;
        }
        if (part.nextFrag == null) {
            this.lastFrag = part.prevFrag;
        } else {
            part.nextFrag.prevFrag = part.prevFrag;
        }
        part.prevFrag = null;
        part.nextFrag = null;
        if (part.prevPart == null) {
            this.firstPart = part.nextPart;
        } else {
            part.prevPart.nextPart = part.nextPart;
        }
        if (part.nextPart == null) {
            this.lastPart = part.prevPart;
        } else {
            part.nextPart.prevPart = part.prevPart;
        }
        part.prevPart = null;
        part.nextPart = null;
    }

    protected void unlinkHole(TrackModelHole hole) {
        if (hole.prevFrag == null) {
            this.firstFrag = hole.nextFrag;
        } else {
            hole.prevFrag.nextFrag = hole.nextFrag;
        }
        if (hole.nextFrag == null) {
            this.lastFrag = hole.prevFrag;
        } else {
            hole.nextFrag.prevFrag = hole.prevFrag;
        }
        hole.prevFrag = null;
        hole.nextFrag = null;
        if (hole.prevHole == null) {
            this.firstHole = hole.nextHole;
        } else {
            hole.prevHole.nextHole = hole.nextHole;
        }
        if (hole.nextHole == null) {
            this.lastHole = hole.prevHole;
        } else {
            hole.nextHole.prevHole = hole.prevHole;
        }
        hole.prevHole = null;
        hole.nextHole = null;
    }

    protected TrackModelHole findPrevHole(TrackModelFrag frag) {
        TrackModelFrag prev;
        while ((prev = frag.prevFrag) != null) {
            if (prev.isHole()) {
                return (TrackModelHole)prev;
            }
            frag = prev;
        }
        return null;
    }

    protected TrackModelHole findNextHole(TrackModelFrag frag) {
        TrackModelFrag next;
        while ((next = frag.nextFrag) != null) {
            if (next.isHole()) {
                return (TrackModelHole)next;
            }
            frag = next;
        }
        return null;
    }

    protected TrackModelPart findPrevPart(TrackModelFrag frag) {
        TrackModelFrag prev;
        while ((prev = frag.prevFrag) != null) {
            if (prev.isPart()) {
                return (TrackModelPart)prev;
            }
            frag = prev;
        }
        return null;
    }

    protected TrackModelPart findNextPart(TrackModelFrag frag) {
        TrackModelFrag next;
        while ((next = frag.nextFrag) != null) {
            if (next.isPart()) {
                return (TrackModelPart)next;
            }
            frag = next;
        }
        return null;
    }

    @Override
    public void checkIntegrity() throws IllegalStateException {
        TrackModelPart part;
        TrackModelFrag prevFrag = null;
        TrackModelPart prevPart = null;
        TrackModelHole prevHole = null;
        int numPart = 0;
        TrackModelFrag frag = this.firstFrag;
        while (frag != null) {
            if (prevFrag != null && frag.blockOfs != prevFrag.blockEnd) {
                throw new IllegalStateException("Invalid frag offset: " + frag.blockOfs + " != " + prevFrag.blockEnd);
            }
            if (frag.prevFrag != prevFrag) {
                throw new IllegalStateException("Invalid previous frag: " + frag.prevFrag + " != " + prevFrag);
            }
            if (frag.isPart()) {
                part = (TrackModelPart)frag;
                if (prevPart == null && part != this.firstPart) {
                    throw new IllegalStateException("Invalid first part: " + part + " != " + this.firstPart);
                }
                if (part.prevPart != prevPart) {
                    throw new IllegalStateException("Invalid previous part: " + part.prevPart + " != " + prevPart);
                }
                prevPart = part;
                ++numPart;
            }
            if (frag.isHole()) {
                TrackModelHole hole = (TrackModelHole)frag;
                if (prevHole == null && hole != this.firstHole) {
                    throw new IllegalStateException("Invalid first hole: " + hole + " != " + this.firstHole);
                }
                if (hole.prevHole != prevHole) {
                    throw new IllegalStateException("Invalid previous hole: " + hole.prevHole + " != " + prevHole);
                }
                if (prevFrag != null && prevFrag.isHole()) {
                    throw new IllegalStateException("Invalid continuous holes: prevFrag=" + prevFrag + ", hole=" + hole);
                }
                prevHole = hole;
            }
            prevFrag = frag;
            frag = frag.nextFrag;
        }
        if (prevFrag != this.lastFrag) {
            throw new IllegalStateException("Invalid last frag: " + prevFrag + " != " + this.lastFrag);
        }
        if (prevPart != this.lastPart) {
            throw new IllegalStateException("Invalid last part: " + prevPart + " != " + this.lastPart);
        }
        if (prevHole != this.lastHole) {
            throw new IllegalStateException("Invalid last hole: " + prevHole + " != " + this.lastHole);
        }
        if (this.lastHole != null && this.lastHole == this.lastFrag) {
            throw new IllegalStateException("Invalid ending hole: " + this.lastHole + " == " + this.lastFrag);
        }
        int numSavePart = 0;
        long prevTickEnd = 0L;
        for (int i = 0; i < this.partCount; ++i) {
            part = this.parts[i];
            if (part.tickOfs >= part.tickEnd) {
                throw new IllegalStateException("Invalid tick range: " + part.tickOfs + " >= " + part.tickEnd);
            }
            if (i > 0 && part.tickOfs < prevTickEnd) {
                throw new IllegalStateException("Invalid tick order: " + part.tickOfs + " < " + prevTickEnd);
            }
            if (part.blockOfs != 0L) {
                ++numSavePart;
            }
            prevTickEnd = part.tickEnd;
        }
        if (numPart != numSavePart) {
            throw new IllegalStateException("Invalid number of saved parts: " + numPart + " != " + numSavePart);
        }
    }

    @Override
    public synchronized float getTickRate() {
        return this.tickRate;
    }

    @Override
    public synchronized void setTickRate(float tickRate) throws IOException {
        if (this.readOnly) {
            throw this.failReadOnly();
        }
        this.tickRate = tickRate;
        this.writeFileHeader();
    }

    protected class NodeWriter
    implements NodeConsumer {
        protected TrackModelPart part;
        protected int off;

        protected NodeWriter() {
        }

        protected void reset(TrackModelPart part, int nodeCount) {
            this.part = part;
            this.off = 34;
        }

        protected void ensure(int bufLen) {
            if (TrackModelFileImpl.this.buf.length < bufLen) {
                byte[] arr = new byte[Math.max(TrackModelFileImpl.this.buf.length * 2, bufLen)];
                System.arraycopy(TrackModelFileImpl.this.buf, 0, arr, 0, this.off);
                TrackModelFileImpl.this.buf = arr;
            }
        }

        @Override
        public boolean consume(Node node) {
            TrackNode n = (TrackNode)node;
            int rtck = (int)(n.getTick() - this.part.tickOfs);
            int len = n.getLength();
            switch (len) {
                case 3: {
                    this.ensure(this.off + 8);
                    TrackModelFileImpl.this.buf[this.off++] = -29;
                    Data.setInt((byte[])TrackModelFileImpl.this.buf, (int)this.off, (int)rtck);
                    this.off += 4;
                    TrackModelFileImpl.this.buf[this.off++] = (byte)n.getStatus();
                    TrackModelFileImpl.this.buf[this.off++] = (byte)n.getData1();
                    TrackModelFileImpl.this.buf[this.off++] = (byte)n.getData2();
                    return true;
                }
                case 2: {
                    this.ensure(this.off + 7);
                    TrackModelFileImpl.this.buf[this.off++] = -30;
                    Data.setInt((byte[])TrackModelFileImpl.this.buf, (int)this.off, (int)rtck);
                    this.off += 4;
                    TrackModelFileImpl.this.buf[this.off++] = (byte)n.getStatus();
                    TrackModelFileImpl.this.buf[this.off++] = (byte)n.getData1();
                    return true;
                }
                case 1: {
                    this.ensure(this.off + 6);
                    TrackModelFileImpl.this.buf[this.off++] = -31;
                    Data.setInt((byte[])TrackModelFileImpl.this.buf, (int)this.off, (int)rtck);
                    this.off += 4;
                    TrackModelFileImpl.this.buf[this.off++] = (byte)n.getStatus();
                    return true;
                }
            }
            if (len < 1 || len > 0x800000) {
                throw new IllegalArgumentException("Invalid sysex-data length: " + len);
            }
            this.ensure(this.off + 9 + len);
            TrackModelFileImpl.this.buf[this.off++] = -32;
            Data.setInt((byte[])TrackModelFileImpl.this.buf, (int)this.off, (int)rtck);
            this.off += 4;
            Data.setInt((byte[])TrackModelFileImpl.this.buf, (int)this.off, (int)len);
            this.off += 4;
            n.read(0, TrackModelFileImpl.this.buf, this.off, len);
            this.off += len;
            return true;
        }
    }
}

