/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.list;

import com.spacekiller.util.midi.list.AbstractNode;
import com.spacekiller.util.midi.model.Model;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import java.util.Arrays;

public abstract class AbstractList
implements Model {
    protected AbstractNode[] array;
    protected int size;
    protected AbstractNode first;
    protected AbstractNode last;

    public AbstractList(int initCapacity) {
        this.array = new AbstractNode[initCapacity];
        this.size = 0;
    }

    protected AbstractNode after(long tick) {
        int index = this.nodeIndex(tick);
        if (index < this.size) {
            return this.array[index];
        }
        return null;
    }

    protected AbstractNode before(long tick) {
        int index = this.nodeIndex(tick);
        if (index > 0) {
            return this.array[index - 1];
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size < 1;
    }

    @Override
    public int getNodeCount() {
        return this.size;
    }

    protected Node getNodeAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index < this.size) {
            return this.array[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    protected int nodeIndex(long tick) {
        int lo = 0;
        int hi = this.size - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            if (this.array[i].tick < tick) {
                lo = i + 1;
                continue;
            }
            hi = i - 1;
        }
        return lo;
    }

    protected int nodeIndex(AbstractNode node) {
        if (node == null) {
            return -1;
        }
        long t = node.tick;
        int index = this.nodeIndex(t);
        int siz = this.size;
        for (int i = index; i < siz; ++i) {
            AbstractNode x = this.array[i];
            if (x == node) {
                return i;
            }
            if (x.tick != t) break;
        }
        return -1;
    }

    @Override
    public int getNodeCount(long ofs, long end) {
        int o = this.nodeIndex(ofs);
        int e = this.nodeIndex(end);
        return e - o;
    }

    @Override
    public int getNodes(long ofs, long end, NodeConsumer dst) {
        int i;
        int o = this.nodeIndex(ofs);
        int e = this.nodeIndex(end);
        for (i = o; i < e && dst.consume(this.array[i]); ++i) {
        }
        return i - o;
    }

    @Override
    public int getNodes(long ofs, long end, Node[] dst, int x, int z) {
        int o = this.nodeIndex(ofs);
        int v = z - x;
        int e = this.nodeIndex(end);
        int n = e - o;
        if (v > n) {
            v = n;
        }
        if (v > 0) {
            System.arraycopy(this.array, o, dst, x, v);
        }
        if (v < n) {
            return -1;
        }
        return v;
    }

    public int getExtendedNodes(long ofs, long end, Node[] dst, int x, int z) {
        int n;
        int v;
        int o = this.nodeIndex(ofs);
        int e = this.nodeIndex(end);
        if (o > 0) {
            --o;
        }
        if (e < this.size) {
            ++e;
        }
        if ((v = z - x) > (n = e - o)) {
            v = n;
        }
        if (v > 0) {
            System.arraycopy(this.array, o, dst, x, v);
        }
        if (v < n) {
            return -1;
        }
        return v;
    }

    public int getExtendedNodes(long ofs, long end, NodeConsumer dst) {
        int i;
        int o = this.nodeIndex(ofs);
        int e = this.nodeIndex(end);
        if (o > 0) {
            --o;
        }
        if (e < this.size) {
            ++e;
        }
        for (i = o; i < e && dst.consume(this.array[i]); ++i) {
        }
        return i - o;
    }

    protected boolean insNode(AbstractNode n) {
        if (n.prev != null || n.next != null || n == this.first || n == this.last) {
            return false;
        }
        this.ins(n);
        return true;
    }

    protected boolean delNode(AbstractNode n) {
        int index = this.nodeIndex(n);
        if (index < 0) {
            return false;
        }
        this.del(index, n);
        return true;
    }

    protected int delNodes(long ofs, long end) {
        if (this.size < 1) {
            return 0;
        }
        int x = this.nodeIndex(ofs);
        int z = this.nodeIndex(end);
        int n = z - x;
        if (n < 1) {
            return 0;
        }
        this.del(x, z);
        return n;
    }

    protected int delNodes(long ofs, long end, NodeConsumer cons) {
        int i;
        if (this.size < 1) {
            return 0;
        }
        int x = this.nodeIndex(ofs);
        int z = this.nodeIndex(end);
        for (i = x; i < z && cons.consume(this.array[i]); ++i) {
        }
        if (i > x) {
            this.del(x, i);
            return i - x;
        }
        return 0;
    }

    protected int delAllNodes() {
        int n = this.size;
        if (n > 0) {
            this.del(0, n);
            return n;
        }
        return 0;
    }

    @Override
    public void checkIntegrity() throws IllegalStateException {
        int i;
        int siz = this.size;
        if (siz > 0) {
            if (siz > this.array.length) {
                throw new IllegalStateException("Invalid size: " + siz + " > " + this.array.length);
            }
            AbstractNode prev = this.array[0];
            if (prev == null) {
                throw new IllegalStateException("Node is null at index 0");
            }
            for (int i2 = 1; i2 < siz; ++i2) {
                AbstractNode node = this.array[i2];
                if (node == null) {
                    throw new IllegalStateException("Node is null at index " + i2);
                }
                if (node.tick < prev.tick) {
                    throw new IllegalStateException("Invalid node tick order at index " + i2 + ": " + node.tick + " < " + prev.tick);
                }
                prev = node;
            }
        }
        AbstractNode first = this.first;
        AbstractNode last = this.last;
        if (siz > 0) {
            if (first == null) {
                throw new IllegalStateException("Invalid first: null, size=" + siz);
            }
            if (last == null) {
                throw new IllegalStateException("Invalid last: null, size=" + siz);
            }
        } else {
            if (first != null) {
                throw new IllegalStateException("Invalid first: " + first + " != null, size=" + siz);
            }
            if (last != null) {
                throw new IllegalStateException("Invalid last: " + last + " != null, size=" + siz);
            }
        }
        AbstractNode node = first;
        AbstractNode prev = null;
        for (i = 0; i < siz && node != null; ++i) {
            if (node.prev != prev) {
                throw new IllegalStateException("Invalid prev: " + node.prev + " != " + prev);
            }
            prev = node;
            node = node.next;
        }
        if (last != prev) {
            throw new IllegalStateException("Invalid last: " + last + " != " + prev);
        }
        if (i != siz) {
            throw new IllegalStateException("Invalid nodes: " + i + " != " + siz);
        }
    }

    public boolean has(AbstractNode node) {
        return this.nodeIndex(node) >= 0;
    }

    private void ins(AbstractNode n) {
        if (this.size < 1) {
            this.ins(0, n);
            return;
        }
        long t = n.tick;
        if (t >= this.array[this.size - 1].tick) {
            int i = this.size;
            this.ins(i, n);
            return;
        }
        int i = this.nodeIndex(t + 1L);
        this.ins(i, n);
    }

    private void ins(int index, AbstractNode node) {
        if (this.size < this.array.length) {
            if (index < this.size) {
                System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
            }
            this.array[index] = node;
            ++this.size;
        } else {
            AbstractNode[] arr = new AbstractNode[this.size * 2];
            if (index > 0) {
                System.arraycopy(this.array, 0, arr, 0, index);
            }
            if (index < this.size) {
                System.arraycopy(this.array, index, arr, index + 1, this.size - index);
            }
            arr[index] = node;
            this.array = arr;
            ++this.size;
        }
        if (index < 1) {
            node.next = this.first;
            if (this.first != null) {
                this.first.prev = node;
            }
            this.first = node;
        } else {
            AbstractNode prev;
            node.prev = prev = this.array[index - 1];
            prev.next = node;
        }
        if (index < this.size - 1) {
            AbstractNode next;
            node.next = next = this.array[index + 1];
            next.prev = node;
        } else {
            node.prev = this.last;
            if (this.last != null) {
                this.last.next = node;
            }
            this.last = node;
        }
    }

    private void del(int index, AbstractNode node) {
        if (node.prev == null) {
            this.first = node.next;
        } else {
            node.prev.next = node.next;
        }
        if (node.next == null) {
            this.last = node.prev;
        } else {
            node.next.prev = node.prev;
        }
        node.prev = null;
        node.next = null;
        --this.size;
        if (index < this.size) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index);
        }
        this.array[this.size] = null;
    }

    private void del(int off, int end) {
        AbstractNode prev = this.array[off].prev;
        AbstractNode next = this.array[end - 1].next;
        for (int i = off; i < end; ++i) {
            AbstractNode node = this.array[i];
            node.prev = null;
            node.next = null;
        }
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
        }
        int rest = this.size - end;
        if (rest > 0) {
            System.arraycopy(this.array, end, this.array, off, rest);
        }
        rest = this.size;
        this.size += off - end;
        Arrays.fill(this.array, this.size, rest, null);
    }

    protected int buildFromSortedUniqueArray(AbstractNode[] arr, int off, int len) {
        if (this.size > 0) {
            throw new IllegalStateException("Model is not empty!");
        }
        int end = off + len;
        int hi = end - 1;
        int lo = off;
        if (hi < lo) {
            return 0;
        }
        for (int i = off; i < end; ++i) {
            AbstractNode node = arr[i];
            node.prev = null;
            node.next = null;
        }
        do {
            this.ins(arr[lo++]);
        } while (lo <= hi);
        return this.size;
    }
}

