/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.list;

import com.spacekiller.util.midi.list.AbstractList;
import com.spacekiller.util.midi.list.ListTrackNode;
import com.spacekiller.util.midi.list.TrackNode1;
import com.spacekiller.util.midi.list.TrackNode2;
import com.spacekiller.util.midi.list.TrackNode3;
import com.spacekiller.util.midi.list.TrackNodeN;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.TrackModelAccess;
import com.spacekiller.util.midi.model.TrackNode;

public abstract class AbstractTrackModel
extends AbstractList
implements TrackModelAccess {
    public AbstractTrackModel(int initCapacity) {
        super(initCapacity);
    }

    @Override
    public TrackNode newNode(long tick, TrackNode node) {
        int len = node.getLength();
        switch (len) {
            case 3: {
                return new TrackNode3(tick, node.getStatus(), node.getData1(), node.getData2());
            }
            case 2: {
                return new TrackNode2(tick, node.getStatus(), node.getData1());
            }
            case 1: {
                return new TrackNode1(tick, node.getStatus());
            }
        }
        byte[] data = new byte[len];
        node.read(0, data, 0, len);
        return new TrackNodeN(tick, data[0] & 0xFF, data, 0, len);
    }

    @Override
    public TrackNode newNode(long tick, int status) {
        return new TrackNode1(tick, status);
    }

    @Override
    public TrackNode newNode(long tick, int status, int data1) {
        return new TrackNode2(tick, status, data1);
    }

    @Override
    public TrackNode newNode(long tick, int status, int data1, int data2) {
        return new TrackNode3(tick, status, data1, data2);
    }

    @Override
    public TrackNode newNode(long tick, int status, byte[] data, int off, int len) {
        return new TrackNodeN(tick, status, data, off, len);
    }

    @Override
    public boolean containsNode(TrackNode node) {
        return this.has((ListTrackNode)node);
    }

    @Override
    public Node getFirst() {
        return (ListTrackNode)this.first;
    }

    public ListTrackNode getTrackFirst() {
        return (ListTrackNode)this.first;
    }

    @Override
    public Node getLast() {
        return (ListTrackNode)this.last;
    }

    public ListTrackNode getTrackLast() {
        return (ListTrackNode)this.last;
    }

    @Override
    public Node getAfter(long tick) {
        return (ListTrackNode)this.after(tick);
    }

    public ListTrackNode getTrackAfter(long tick) {
        return (ListTrackNode)this.after(tick);
    }

    @Override
    public Node getBefore(long tick) {
        return (ListTrackNode)this.before(tick);
    }

    public ListTrackNode getTrackBefore(long tick) {
        return (ListTrackNode)this.before(tick);
    }

    @Override
    public TrackNode getPrev(TrackNode node) {
        return (ListTrackNode)((ListTrackNode)node).prev;
    }

    public ListTrackNode getTrackPrev(TrackNode node) {
        return (ListTrackNode)((ListTrackNode)node).prev;
    }

    @Override
    public TrackNode getNext(TrackNode node) {
        return (ListTrackNode)((ListTrackNode)node).next;
    }

    public ListTrackNode getTrackNext(TrackNode node) {
        return (ListTrackNode)((ListTrackNode)node).next;
    }

    @Override
    public void checkIntegrity() throws IllegalStateException {
        super.checkIntegrity();
    }
}

