/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.list;

import com.spacekiller.util.midi.list.AbstractStateModel;
import com.spacekiller.util.midi.list.ListStateNode;
import com.spacekiller.util.midi.model.MidiNode;
import com.spacekiller.util.midi.model.MidiStateImpl;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.TrackModel;

public class ListStateModel
extends AbstractStateModel {
    public static final int DEFAULT_INIT_CAPACITY = 8;
    protected final TrackModel trackModel;
    protected final long ticksPerState;
    protected long lastTick;
    protected long endTick;
    protected ListStateNode endNode;
    protected MidiStateImpl endState;
    protected long validEnd;

    public ListStateModel(TrackModel trackModel, long ticksPerState, int initCapacity) {
        super(initCapacity);
        if (ticksPerState < 1L) {
            throw new IllegalArgumentException("ticksPerState: " + ticksPerState + " < 1");
        }
        this.trackModel = trackModel;
        this.ticksPerState = ticksPerState;
        this.endTick = Long.MIN_VALUE;
        this.validEnd = Long.MIN_VALUE;
        trackModel.registerNodeListener(this);
        if (trackModel.isEmpty()) {
            this.validEnd = Long.MAX_VALUE;
        }
        this.adjustLastTick();
    }

    protected long stateTick(long tick) {
        return this.ticksPerState + tick - tick % this.ticksPerState;
    }

    @Override
    public void nodeAdded(Node node) {
        long tick = node.getTick();
        if (tick >= this.lastTick) {
            this.lastTick = tick;
            if (tick < this.validEnd) {
                if (tick < this.endTick) {
                    this.endState.update((MidiNode)node);
                    return;
                }
                this.endTick = this.stateTick(tick);
                this.endState = this.endState == null ? new MidiStateImpl(this.endTick) : this.endState.snapshot(this.endTick);
                this.endState.update((MidiNode)node);
                this.endNode = new ListStateNode(this.endTick, this.endState);
                this.insNode(this.endNode);
            }
        } else if (tick < this.validEnd) {
            this.validEnd = tick;
        }
    }

    @Override
    public void nodeRemoved(Node node) {
        long tick = node.getTick();
        if (tick == this.lastTick) {
            this.adjustLastTick();
        }
        if (tick < this.validEnd) {
            this.validEnd = tick;
        }
    }

    @Override
    public boolean isValid(long tickEnd) {
        return tickEnd <= this.validEnd;
    }

    @Override
    public void validate(long tickEnd) {
        long tick;
        Node tn;
        long prevTick;
        MidiStateImpl prevState;
        if (tickEnd <= this.validEnd) {
            return;
        }
        ListStateNode prevNode = (ListStateNode)this.getBefore(this.validEnd + 1L);
        if (prevNode == null) {
            prevState = null;
            prevTick = Long.MIN_VALUE;
            tn = this.trackModel.getFirst();
        } else {
            prevState = (MidiStateImpl)prevNode.getState();
            prevTick = prevNode.tick;
            tn = this.trackModel.getAfter(prevTick);
        }
        while (tn != null) {
            MidiStateImpl state;
            ListStateNode stateNode;
            tick = this.stateTick(tn.getTick());
            ListStateNode listStateNode = stateNode = prevNode == null ? null : this.getStateNext(prevNode);
            if (stateNode == null) {
                state = new MidiStateImpl(tick);
                stateNode = new ListStateNode(tick, state);
                this.insNode(stateNode);
            } else if (stateNode.tick == tick) {
                state = (MidiStateImpl)stateNode.getState();
            } else {
                if (stateNode.tick < tick) {
                    this.delNode(stateNode);
                }
                state = new MidiStateImpl(tick);
                stateNode = new ListStateNode(tick, state);
                this.insNode(stateNode);
            }
            state.reset(prevState);
            this.trackModel.getNodes(prevTick, tick, state);
            prevNode = stateNode;
            prevState = state;
            prevTick = tick;
            tn = this.trackModel.getAfter(tick);
            if (tick < tickEnd) continue;
        }
        if (tn == null) {
            tick = prevNode == null ? Long.MIN_VALUE : prevNode.tick + 1L;
            this.delNodes(tick, Long.MAX_VALUE);
            this.validEnd = Long.MAX_VALUE;
        } else {
            this.validEnd = prevNode.tick;
        }
    }

    protected void adjustLastTick() {
        MidiNode n = (MidiNode)this.trackModel.getLast();
        this.lastTick = n == null ? Long.MIN_VALUE : n.getTick();
    }

    @Override
    public void close() {
        this.trackModel.unregisterNodeListener(this);
    }

    @Override
    public void checkIntegrity() throws IllegalStateException {
        ListStateNode lastStateNode;
        super.checkIntegrity();
        MidiNode n = (MidiNode)this.trackModel.getLast();
        if (n == null) {
            if (this.lastTick != Long.MIN_VALUE) {
                throw new IllegalStateException("Invalid lastTick: " + this.lastTick + ", null");
            }
        } else if (this.lastTick != n.getTick()) {
            throw new IllegalStateException("Invalid lastTick: " + this.lastTick + " != " + n.getTick());
        }
        if (this.endNode != (lastStateNode = this.getStateLast())) {
            throw new IllegalStateException("Invalid endNode: " + this.endNode + " != " + lastStateNode);
        }
        if (this.endNode != null && this.endTick != this.endNode.getTick()) {
            throw new IllegalStateException("Invalid endTick: " + this.endTick + " != " + this.endNode.getTick());
        }
    }
}

