/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.list;

import com.spacekiller.util.midi.list.AbstractNode;
import com.spacekiller.util.midi.list.AbstractTrackModel;
import com.spacekiller.util.midi.list.ListTrackNode;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.model.NodeDispatcher;
import com.spacekiller.util.midi.model.NodeListener;
import com.spacekiller.util.midi.model.TrackNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public class ListTrackModel
extends AbstractTrackModel {
    public static final int DEFAULT_INIT_CAPACITY = 32;
    protected static final TickComparator TICK_COMPARATOR = new TickComparator();
    protected final NodeRemover nodeRemover = new NodeRemover();
    protected final NodeDispatcher nodeDispatcher = new NodeDispatcher();

    public ListTrackModel() {
        this(32);
    }

    public ListTrackModel(int initCapacity) {
        super(initCapacity);
    }

    @Override
    public boolean addNode(TrackNode node) {
        ListTrackNode n = (ListTrackNode)node;
        if (!this.insNode(n)) {
            return false;
        }
        this.nodeDispatcher.fireNodeAdded(n);
        return true;
    }

    @Override
    public int addNodes(long ofs, long end, Collection nodes) {
        int num = nodes.size();
        if (num < 1) {
            return 0;
        }
        AbstractNode[] arr = nodes.toArray(new ListTrackNode[num]);
        Arrays.sort(arr, TICK_COMPARATOR);
        if (this.size > 0) {
            int ins = 0;
            for (int i = 0; i < num; ++i) {
                ListTrackNode node = arr[i];
                long tick = node.tick;
                if (tick >= end || tick < ofs || !this.addNode(node)) continue;
                ++ins;
            }
            return ins;
        }
        int cnt = 0;
        ListTrackNode prev = null;
        for (int i = 0; i < num; ++i) {
            ListTrackNode node = arr[i];
            arr[i] = null;
            long tick = node.tick;
            if (tick >= end || tick < ofs || node.prev != null || node.next != null) continue;
            node.prev = prev;
            if (prev != null) {
                prev.next = node;
            }
            arr[cnt++] = node;
            prev = node;
        }
        if (cnt < 1) {
            return 0;
        }
        int ins = this.buildFromSortedUniqueArray(arr, 0, cnt);
        for (int i = 0; i < cnt; ++i) {
            this.nodeDispatcher.fireNodeAdded(arr[i]);
        }
        return ins;
    }

    @Override
    public boolean removeNode(TrackNode node) {
        ListTrackNode n = (ListTrackNode)node;
        if (!this.delNode(n)) {
            return false;
        }
        this.nodeDispatcher.fireNodeRemoved(n);
        return true;
    }

    @Override
    public int removeNodes(long ofs, long end) {
        return this.delNodes(ofs, end, this.nodeRemover);
    }

    @Override
    public int removeNodes(long ofs, long end, NodeConsumer dst) {
        NodeRemoverConsumer remover = new NodeRemoverConsumer(dst);
        return this.delNodes(ofs, end, remover);
    }

    @Override
    public void registerNodeListener(NodeListener listener) {
        this.nodeDispatcher.addNodeListener(listener);
    }

    @Override
    public void unregisterNodeListener(NodeListener listener) {
        this.nodeDispatcher.removeNodeListener(listener);
    }

    protected static class TickComparator
    implements Comparator {
        protected TickComparator() {
        }

        public int compare(Object o1, Object o2) {
            ListTrackNode n1 = (ListTrackNode)o1;
            ListTrackNode n2 = (ListTrackNode)o2;
            long t1 = n1.tick;
            long t2 = n2.tick;
            if (t1 < t2) {
                return -1;
            }
            if (t1 > t2) {
                return 1;
            }
            return 0;
        }
    }

    protected class NodeRemoverConsumer
    extends NodeRemover {
        final NodeConsumer cons;

        public NodeRemoverConsumer(NodeConsumer cons) {
            this.cons = cons;
        }

        @Override
        public boolean consume(Node node) {
            if (!this.cons.consume(node)) {
                return false;
            }
            return super.consume(node);
        }
    }

    protected class NodeRemover
    implements NodeConsumer {
        protected NodeRemover() {
        }

        @Override
        public boolean consume(Node node) {
            ListTrackModel.this.nodeDispatcher.fireNodeRemoved(node);
            return true;
        }
    }
}

