/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.list;

import com.spacekiller.util.midi.list.ListTrackNode;
import com.spacekiller.util.midi.model.MidiNode;

public class TrackNode3
extends ListTrackNode {
    protected byte data1;
    protected byte data2;

    public TrackNode3(long tick, int status, int data1, int data2) {
        super(tick, status);
        this.data1 = (byte)data1;
        this.data2 = (byte)data2;
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public int getData1() {
        return this.data1 & 0x7F;
    }

    @Override
    public int getData2() {
        return this.data2 & 0x7F;
    }

    @Override
    public int read(int ofs, byte[] dst, int off, int len) {
        if (len < 1) {
            return 0;
        }
        switch (ofs) {
            case 0: {
                dst[off++] = this.status;
                if (len < 2) {
                    return 1;
                }
                dst[off++] = this.data1;
                if (len < 3) {
                    return 2;
                }
                dst[off] = this.data2;
                return 3;
            }
            case 1: {
                dst[off++] = this.data1;
                if (len < 2) {
                    return 1;
                }
                dst[off] = this.data2;
                return 2;
            }
            case 2: {
                dst[off] = this.data2;
                return 1;
            }
        }
        return -1;
    }

    @Override
    public boolean compare(MidiNode o) {
        if (o == this) {
            return true;
        }
        return o.getTick() == this.tick && o.getStatus() == this.status && o.getLength() == 3 && o.getData1() == this.data1 && o.getData2() == this.data2;
    }
}

