/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.model;

import com.spacekiller.util.midi.model.MidiNode;
import com.spacekiller.util.midi.model.MidiState;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import java.util.Arrays;

public class MidiStateImpl
implements MidiState,
NodeConsumer {
    private static final int STATES_INIT_CAPACITY = 4;
    protected long tick;
    protected NoteStates notes;
    protected ControlStates ctrls;
    protected ChannelStates program;
    protected ChannelStates pressure;
    protected ChannelStates pitch;

    protected static int retainActiveNotes(MidiNode[] src, int num, MidiNode[] dst) {
        int act = 0;
        block5: for (int i = 0; i < num; ++i) {
            MidiNode n = src[i];
            switch (n.getStatus() & 0xF0) {
                case 128: {
                    continue block5;
                }
                case 144: {
                    if (n.getData2() == 0) continue block5;
                    dst[act++] = n;
                    continue block5;
                }
                case 160: {
                    dst[act++] = n;
                }
            }
        }
        return act;
    }

    public MidiStateImpl(long tick) {
        this.tick = tick;
    }

    public String toString() {
        return super.toString() + "[tick=" + this.tick + "]";
    }

    @Override
    public long getTick() {
        return this.tick;
    }

    @Override
    public int getNotes(NodeConsumer dst) {
        return this.notes == null ? 0 : this.notes.getStates(dst);
    }

    @Override
    public int getCtrls(NodeConsumer dst) {
        return this.ctrls == null ? 0 : this.ctrls.getStates(dst);
    }

    @Override
    public int getProgram(NodeConsumer dst) {
        return this.program == null ? 0 : this.program.getStates(dst);
    }

    @Override
    public int getPressure(NodeConsumer dst) {
        return this.pressure == null ? 0 : this.pressure.getStates(dst);
    }

    @Override
    public int getPitch(NodeConsumer dst) {
        return this.pitch == null ? 0 : this.pitch.getStates(dst);
    }

    public void update(MidiNode node) {
        int status = node.getStatus();
        switch (status & 0xF0) {
            case 128: 
            case 144: 
            case 160: {
                if (this.notes == null) {
                    this.notes = new NoteStates(4);
                }
                this.notes.set(status & 0xF, node.getData1(), node);
                return;
            }
            case 176: {
                if (this.ctrls == null) {
                    this.ctrls = new ControlStates(4);
                }
                this.ctrls.set(status & 0xF, node.getData1(), node);
                return;
            }
            case 192: {
                if (this.program == null) {
                    this.program = new ChannelStates(4);
                }
                this.program.set(status & 0xF, node);
                return;
            }
            case 208: {
                if (this.pressure == null) {
                    this.pressure = new ChannelStates(4);
                }
                this.pressure.set(status & 0xF, node);
                return;
            }
            case 224: {
                if (this.pitch == null) {
                    this.pitch = new ChannelStates(4);
                }
                this.pitch.set(status & 0xF, node);
                return;
            }
        }
    }

    @Override
    public boolean consume(Node node) {
        this.update((MidiNode)node);
        return true;
    }

    public void reset(MidiStateImpl prev) {
        ChannelStates prevPitch;
        ChannelStates prevPressure;
        ChannelStates prevProgram;
        ControlStates prevCtrls;
        MidiNode[] arr;
        int num;
        if (this.notes != null) {
            this.notes.clear();
        }
        if (this.ctrls != null) {
            this.ctrls.clear();
        }
        if (this.program != null) {
            this.program.clear();
        }
        if (this.pressure != null) {
            this.pressure.clear();
        }
        if (this.pitch != null) {
            this.pitch.clear();
        }
        if (prev == null) {
            return;
        }
        NoteStates prevNotes = prev.notes;
        int n = num = prevNotes == null ? 0 : prevNotes.size;
        if (num > 0) {
            if (this.notes == null) {
                this.notes = new NoteStates(num);
                arr = this.notes.arr;
            } else {
                arr = this.notes.arr.length < num ? new MidiNode[num] : this.notes.arr;
            }
            int act = MidiStateImpl.retainActiveNotes(prevNotes.arr, num, arr);
            this.notes.arr = arr;
            this.notes.size = act;
        }
        int n2 = num = (prevCtrls = prev.ctrls) == null ? 0 : prevCtrls.size;
        if (num > 0) {
            if (this.ctrls == null) {
                this.ctrls = new ControlStates(num);
                arr = this.ctrls.arr;
            } else {
                arr = this.ctrls.arr.length < num ? new MidiNode[num] : this.ctrls.arr;
            }
            System.arraycopy(prevCtrls.arr, 0, arr, 0, num);
            this.ctrls.arr = arr;
            this.ctrls.size = num;
        }
        int n3 = num = (prevProgram = prev.program) == null ? 0 : prevProgram.size;
        if (num > 0) {
            if (this.program == null) {
                this.program = new ChannelStates(num);
                arr = this.program.arr;
            } else {
                arr = this.program.arr.length < num ? new MidiNode[num] : this.program.arr;
            }
            System.arraycopy(prevProgram.arr, 0, arr, 0, num);
            this.program.arr = arr;
            this.program.size = num;
        }
        int n4 = num = (prevPressure = prev.pressure) == null ? 0 : prevPressure.size;
        if (num > 0) {
            if (this.pressure == null) {
                this.pressure = new ChannelStates(num);
                arr = this.pressure.arr;
            } else {
                arr = this.pressure.arr.length < num ? new MidiNode[num] : this.pressure.arr;
            }
            System.arraycopy(prevPressure.arr, 0, arr, 0, num);
            this.pressure.arr = arr;
            this.pressure.size = num;
        }
        int n5 = num = (prevPitch = prev.pitch) == null ? 0 : prevPitch.size;
        if (num > 0) {
            if (this.pitch == null) {
                this.pitch = new ChannelStates(num);
                arr = this.pitch.arr;
            } else {
                arr = this.pitch.arr.length < num ? new MidiNode[num] : this.pitch.arr;
            }
            System.arraycopy(prevPitch.arr, 0, arr, 0, num);
            this.pitch.arr = arr;
            this.pitch.size = num;
        }
    }

    public MidiStateImpl snapshot(long tick) {
        MidiStateImpl snap = new MidiStateImpl(tick);
        if (this.notes != null) {
            snap.notes = this.notes.snapshotNoteStates();
        }
        if (this.ctrls != null) {
            snap.ctrls = this.ctrls.snapshotControlStates();
        }
        if (this.program != null) {
            snap.program = this.program.snapshotChannelStates();
        }
        if (this.pressure != null) {
            snap.pressure = this.pressure.snapshotChannelStates();
        }
        if (this.pitch != null) {
            snap.pitch = this.pitch.snapshotChannelStates();
        }
        return snap;
    }

    protected static class NoteStates
    extends States {
        public NoteStates(int initCapacity) {
            super(initCapacity);
        }

        public NoteStates(MidiNode[] arr, int size) {
            super(arr, size);
        }

        public void set(int channel, int data1, MidiNode node) {
            int index = this.index(channel, data1);
            if (index < this.size && this.arr[index].getData1() == data1 && (this.arr[index].getStatus() & 0xF) == channel) {
                this.arr[index] = node;
                return;
            }
            this.add(node, index);
        }

        public NoteStates snapshotNoteStates() {
            int num = this.size;
            if (num < 1) {
                return null;
            }
            Object[] old = this.arr;
            MidiNode[] a = new MidiNode[num];
            System.arraycopy(old, 0, a, 0, num);
            this.arr = a;
            int act = MidiStateImpl.retainActiveNotes((MidiNode[])old, num, (MidiNode[])old);
            Arrays.fill(old, act, num, null);
            return new NoteStates((MidiNode[])old, act);
        }
    }

    protected static class ControlStates
    extends States {
        public ControlStates(int initCapacity) {
            super(initCapacity);
        }

        public ControlStates(MidiNode[] arr, int size) {
            super(arr, size);
        }

        public void set(int channel, int data1, MidiNode node) {
            int index = this.index(channel, data1);
            if (index < this.size && this.arr[index].getData1() == data1 && (this.arr[index].getStatus() & 0xF) == channel) {
                this.arr[index] = node;
                return;
            }
            this.add(node, index);
        }

        public ControlStates snapshotControlStates() {
            int num = this.size;
            if (num < 1) {
                return null;
            }
            MidiNode[] old = this.arr;
            MidiNode[] a = new MidiNode[num];
            System.arraycopy(old, 0, a, 0, num);
            this.arr = a;
            return new ControlStates(old, num);
        }
    }

    protected static class ChannelStates
    extends States {
        public ChannelStates(int initCapacity) {
            super(initCapacity);
        }

        public ChannelStates(MidiNode[] arr, int size) {
            super(arr, size);
        }

        public void set(int channel, MidiNode node) {
            int index = this.index(channel);
            if (index < this.size && (this.arr[index].getStatus() & 0xF) == channel) {
                this.arr[index] = node;
                return;
            }
            this.add(node, index);
        }

        public ChannelStates snapshotChannelStates() {
            int num = this.size;
            if (num < 1) {
                return null;
            }
            MidiNode[] old = this.arr;
            MidiNode[] a = new MidiNode[num];
            System.arraycopy(old, 0, a, 0, num);
            this.arr = a;
            return new ChannelStates(old, num);
        }
    }

    protected static abstract class States {
        protected MidiNode[] arr;
        protected int size;

        public States(int initCapacity) {
            this.arr = new MidiNode[initCapacity];
        }

        public States(MidiNode[] arr, int size) {
            this.arr = arr;
            this.size = size;
        }

        public int getStates(NodeConsumer dst) {
            int i;
            for (i = 0; i < this.size && dst.consume(this.arr[i]); ++i) {
            }
            return i;
        }

        protected void add(MidiNode node, int index) {
            if (this.size < this.arr.length) {
                if (index < this.size) {
                    System.arraycopy(this.arr, index, this.arr, index + 1, this.size - index);
                }
                this.arr[index] = node;
                ++this.size;
                return;
            }
            MidiNode[] dst = new MidiNode[this.size * 2];
            System.arraycopy(this.arr, 0, dst, 0, this.size);
            if (index > 0) {
                System.arraycopy(this.arr, 0, dst, 0, index);
            }
            if (index < this.size) {
                System.arraycopy(this.arr, index, dst, index + 1, this.size - index);
            }
            dst[index] = node;
            this.arr = dst;
            ++this.size;
        }

        public void clear() {
            int num = this.size;
            if (num > 0) {
                this.size = 0;
                Arrays.fill(this.arr, 0, num, null);
            }
        }

        protected int index(int channel) {
            int lo = 0;
            int hi = this.size - 1;
            while (lo <= hi) {
                int i = lo + hi >> 1;
                int ch = this.arr[i].getStatus() & 0xF;
                if (ch < channel) {
                    lo = i + 1;
                    continue;
                }
                if (ch > channel) {
                    hi = i - 1;
                    continue;
                }
                lo = i;
                break;
            }
            return lo;
        }

        protected int index(int channel, int data1) {
            int lo = 0;
            int hi = this.size - 1;
            while (lo <= hi) {
                int i = lo + hi >> 1;
                int ch = this.arr[i].getStatus() & 0xF;
                if (ch < channel) {
                    lo = i + 1;
                    continue;
                }
                if (ch > channel) {
                    hi = i - 1;
                    continue;
                }
                int d1 = this.arr[i].getData1();
                if (d1 < data1) {
                    lo = i + 1;
                    continue;
                }
                if (d1 > data1) {
                    hi = i - 1;
                    continue;
                }
                lo = i;
                break;
            }
            return lo;
        }
    }
}

