/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.model;

import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeListener;

public class NodeDispatcher {
    private static final NodeListener[] NONE = new NodeListener[0];
    private NodeListener[] array = NONE;

    public synchronized void addNodeListener(NodeListener listener) {
        if (listener == null) {
            return;
        }
        NodeListener[] old = this.array;
        int num = old.length;
        NodeListener[] arr = new NodeListener[num + 1];
        System.arraycopy(old, 0, arr, 0, num);
        arr[num] = listener;
        this.array = arr;
    }

    public synchronized void removeNodeListener(NodeListener listener) {
        if (listener == null) {
            return;
        }
        NodeListener[] old = this.array;
        int num = old.length;
        for (int i = 0; i < num; ++i) {
            if (old[i] != listener) continue;
            if (num == 1) {
                this.array = NONE;
            } else {
                NodeListener[] arr = new NodeListener[--num];
                if (i > 0) {
                    System.arraycopy(old, 0, arr, 0, i);
                }
                if (i < num) {
                    System.arraycopy(old, i + 1, arr, i, num - i);
                }
                this.array = arr;
            }
            return;
        }
    }

    public void fireNodeAdded(Node node) {
        NodeListener[] arr = this.array;
        int num = arr.length;
        int i = 0;
        while (i < num) {
            arr[i++].nodeAdded(node);
        }
    }

    public void fireNodeRemoved(Node node) {
        NodeListener[] arr = this.array;
        int num = arr.length;
        int i = 0;
        while (i < num) {
            arr[i++].nodeRemoved(node);
        }
    }
}

