/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.tree;

import com.spacekiller.util.midi.model.Node;

public abstract class AbstractNode
implements Node {
    protected AbstractNode par;
    protected AbstractNode lef;
    protected AbstractNode rig;
    protected boolean col = true;
    protected long tick;

    public AbstractNode(long tick) {
        this.tick = tick;
    }

    public String toString() {
        return super.toString() + "[tick=" + this.tick + "]";
    }

    @Override
    public long getTick() {
        return this.tick;
    }

    protected AbstractNode getFirst() {
        AbstractNode n = this;
        while (n.lef != null) {
            n = n.lef;
        }
        return n;
    }

    protected AbstractNode getLast() {
        AbstractNode n = this;
        while (n.rig != null) {
            n = n.rig;
        }
        return n;
    }

    protected AbstractNode getBefore(long t) {
        if (t <= this.tick) {
            return this.lef == null ? null : this.lef.getBefore(t);
        }
        if (this.rig != null) {
            AbstractNode node = this.rig.getBefore(t);
            return node == null ? this : node;
        }
        return this;
    }

    protected AbstractNode getAfter(long t) {
        if (t > this.tick) {
            return this.rig == null ? null : this.rig.getAfter(t);
        }
        if (this.lef != null) {
            AbstractNode node = this.lef.getAfter(t);
            return node == null ? this : node;
        }
        return this;
    }

    protected AbstractNode getPrev() {
        if (this.lef != null) {
            return this.lef.getLast();
        }
        AbstractNode n = this.par;
        if (n == null) {
            return null;
        }
        if (n.rig == this) {
            return n;
        }
        AbstractNode p = n.par;
        while (p != null) {
            if (p.rig == n) {
                return p;
            }
            n = p;
            p = n.par;
        }
        return null;
    }

    protected AbstractNode getNext() {
        if (this.rig != null) {
            return this.rig.getFirst();
        }
        AbstractNode n = this.par;
        if (n == null) {
            return null;
        }
        if (n.lef == this) {
            return n;
        }
        AbstractNode p = n.par;
        while (p != null) {
            if (p.lef == n) {
                return p;
            }
            n = p;
            p = n.par;
        }
        return null;
    }
}

