/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.tree;

import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.TrackModelAccess;
import com.spacekiller.util.midi.model.TrackNode;
import com.spacekiller.util.midi.tree.AbstractTree;
import com.spacekiller.util.midi.tree.TrackNode1;
import com.spacekiller.util.midi.tree.TrackNode2;
import com.spacekiller.util.midi.tree.TrackNode3;
import com.spacekiller.util.midi.tree.TrackNodeN;
import com.spacekiller.util.midi.tree.TreeTrackNode;

public abstract class AbstractTrackModel
extends AbstractTree
implements TrackModelAccess {
    @Override
    public TrackNode newNode(long tick, TrackNode node) {
        int len = node.getLength();
        switch (len) {
            case 3: {
                return new TrackNode3(tick, node.getStatus(), node.getData1(), node.getData2());
            }
            case 2: {
                return new TrackNode2(tick, node.getStatus(), node.getData1());
            }
            case 1: {
                return new TrackNode1(tick, node.getStatus());
            }
        }
        byte[] data = new byte[len];
        node.read(0, data, 0, len);
        return new TrackNodeN(tick, data[0] & 0xFF, data, 0, len);
    }

    @Override
    public TrackNode newNode(long tick, int status) {
        return new TrackNode1(tick, status);
    }

    @Override
    public TrackNode newNode(long tick, int status, int data1) {
        return new TrackNode2(tick, status, data1);
    }

    @Override
    public TrackNode newNode(long tick, int status, int data1, int data2) {
        return new TrackNode3(tick, status, data1, data2);
    }

    @Override
    public TrackNode newNode(long tick, int status, byte[] data, int off, int len) {
        return new TrackNodeN(tick, status, data, off, len);
    }

    @Override
    public boolean containsNode(TrackNode node) {
        return this.has((TreeTrackNode)node);
    }

    @Override
    public Node getFirst() {
        return this.root == null ? null : (TreeTrackNode)this.root.getFirst();
    }

    public TreeTrackNode getTrackFirst() {
        return this.root == null ? null : (TreeTrackNode)this.root.getFirst();
    }

    @Override
    public Node getLast() {
        return this.root == null ? null : (TreeTrackNode)this.root.getLast();
    }

    public TreeTrackNode getTrackLast() {
        return this.root == null ? null : (TreeTrackNode)this.root.getLast();
    }

    @Override
    public Node getAfter(long tick) {
        return this.root == null ? null : (TreeTrackNode)this.root.getAfter(tick);
    }

    public TreeTrackNode getTrackAfter(long tick) {
        return this.root == null ? null : (TreeTrackNode)this.root.getAfter(tick);
    }

    @Override
    public Node getBefore(long tick) {
        return this.root == null ? null : (TreeTrackNode)this.root.getBefore(tick);
    }

    public TreeTrackNode getTrackBefore(long tick) {
        return this.root == null ? null : (TreeTrackNode)this.root.getBefore(tick);
    }

    @Override
    public TrackNode getPrev(TrackNode node) {
        return (TreeTrackNode)((TreeTrackNode)node).getPrev();
    }

    public TreeTrackNode getTrackPrev(TrackNode node) {
        return (TreeTrackNode)((TreeTrackNode)node).getPrev();
    }

    @Override
    public TrackNode getNext(TrackNode node) {
        return (TreeTrackNode)((TreeTrackNode)node).getNext();
    }

    public TreeTrackNode getTrackNext(TrackNode node) {
        return (TreeTrackNode)((TreeTrackNode)node).getNext();
    }

    @Override
    public void checkIntegrity() throws IllegalStateException {
        super.checkIntegrity();
    }
}

