/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.tree;

import com.spacekiller.util.midi.model.Model;
import com.spacekiller.util.midi.model.Node;
import com.spacekiller.util.midi.model.NodeConsumer;
import com.spacekiller.util.midi.tree.AbstractNode;

public abstract class AbstractTree
implements Model {
    protected static final boolean RED = false;
    protected static final boolean BLK = true;
    protected AbstractNode root;
    protected int size;

    @Override
    public boolean isEmpty() {
        return this.size < 1;
    }

    @Override
    public int getNodeCount() {
        return this.size;
    }

    @Override
    public int getNodeCount(long ofs, long end) {
        if (this.root == null) {
            return 0;
        }
        int n = 0;
        for (AbstractNode node = this.root.getAfter(ofs); node != null && node.tick < end; node = node.getNext()) {
            ++n;
        }
        return n;
    }

    @Override
    public int getNodes(long ofs, long end, NodeConsumer dst) {
        if (this.root == null) {
            return 0;
        }
        int n = 0;
        for (AbstractNode node = this.root.getAfter(ofs); node != null && node.tick < end; node = node.getNext()) {
            if (!dst.consume(node)) {
                return n;
            }
            ++n;
        }
        return n;
    }

    @Override
    public int getNodes(long ofs, long end, Node[] dst, int x, int z) {
        if (this.root == null) {
            return 0;
        }
        int i = x;
        for (AbstractNode node = this.root.getAfter(ofs); node != null && node.tick < end; node = node.getNext()) {
            if (i >= z) {
                return -1;
            }
            dst[i++] = node;
        }
        return i - x;
    }

    public int getExtendedNodes(long ofs, long end, NodeConsumer dst) {
        if (this.root == null) {
            return 0;
        }
        AbstractNode node = this.root.getAfter(ofs);
        if (node == null) {
            return 0;
        }
        AbstractNode w = node.getPrev();
        if (w != null && !dst.consume(w)) {
            return 0;
        }
        int n = 0;
        while (node != null && node.tick < end) {
            if (!dst.consume(node)) {
                return n;
            }
            ++n;
            node = node.getNext();
        }
        if (node != null && !dst.consume(node)) {
            return n;
        }
        return n;
    }

    public int getExtendedNodes(long ofs, long end, Node[] dst, int x, int z) {
        if (this.root == null) {
            return 0;
        }
        AbstractNode node = this.root.getAfter(ofs);
        if (node == null) {
            return 0;
        }
        int i = x;
        AbstractNode w = node.getPrev();
        if (w != null) {
            if (i < z) {
                dst[i++] = w;
            } else {
                return -1;
            }
        }
        while (node != null && node.tick < end) {
            if (i >= z) {
                return -1;
            }
            dst[i++] = node;
            node = node.getNext();
        }
        if (node != null) {
            if (i < z) {
                dst[i++] = node;
            } else {
                return -1;
            }
        }
        return i - x;
    }

    protected boolean insNode(AbstractNode n) {
        if (n.par != null || n.lef != null || n.rig != null || n == this.root) {
            return false;
        }
        this.ins(n);
        return true;
    }

    protected boolean delNode(AbstractNode n) {
        if (this.has(n)) {
            this.del(n);
            return true;
        }
        return false;
    }

    protected int delNodes(long ofs, long end) {
        if (this.root == null) {
            return 0;
        }
        int n = 0;
        AbstractNode node = this.root.getBefore(end);
        while (node != null && node.tick >= ofs) {
            AbstractNode p = node.getPrev();
            this.del(node);
            node = p;
            ++n;
        }
        return n;
    }

    protected int delNodes(long ofs, long end, NodeConsumer cons) {
        if (this.root == null) {
            return 0;
        }
        int n = 0;
        AbstractNode node = this.root.getBefore(end);
        while (node != null && node.tick >= ofs && cons.consume(node)) {
            AbstractNode p = node.getPrev();
            this.del(node);
            node = p;
            ++n;
        }
        return n;
    }

    protected int delAllNodes() {
        int n = this.size;
        if (n > 0) {
            this.root = null;
            this.size = 0;
        }
        return n;
    }

    @Override
    public void checkIntegrity() throws IllegalStateException {
        AbstractNode p;
        AbstractNode first;
        if (this.size < 0) {
            throw new IllegalStateException("Invalid size: " + this.size + " < 0");
        }
        if (this.size == 0) {
            if (this.root != null) {
                throw new IllegalStateException("Invalid root: " + this.root + " != null");
            }
            return;
        }
        if (this.root == null) {
            throw new IllegalStateException("Invalid root: null");
        }
        AbstractNode node = first = this.root.getFirst();
        AbstractNode prev = null;
        int num = 0;
        while (node != null) {
            p = node.getPrev();
            if (p != prev) {
                throw new IllegalStateException("Invalid prev node: " + p + " != " + prev + ", node=" + node);
            }
            if (prev != null && prev.tick > node.tick) {
                throw new IllegalStateException("Invalid tick order: " + prev.tick + " > " + node.tick + ", node=" + node);
            }
            prev = node;
            node = node.getNext();
            ++num;
        }
        if (this.size != num) {
            throw new IllegalStateException("Invalid size: " + this.size + " != " + num);
        }
        p = this.root.getLast();
        if (prev != p) {
            throw new IllegalStateException("Invalid last node: " + prev + " != " + p);
        }
    }

    protected boolean has(AbstractNode n) {
        AbstractNode r = this.root;
        if (r == null) {
            return false;
        }
        while (n != null) {
            if (n == r) {
                return true;
            }
            n = n.par;
        }
        return false;
    }

    private void ins(AbstractNode n) {
        AbstractNode p;
        long pt;
        AbstractNode r = this.root;
        if (r == null) {
            this.root = n;
            this.size = 1;
            return;
        }
        long nt = n.tick;
        do {
            p = r;
        } while ((r = nt < (pt = r.tick) ? r.lef : r.rig) != null);
        n.par = p;
        if (nt < pt) {
            p.lef = n;
        } else {
            p.rig = n;
        }
        this.fixAfterIns(n);
        ++this.size;
    }

    private void del(AbstractNode p) {
        AbstractNode rep;
        --this.size;
        if (p.lef != null && p.rig != null) {
            AbstractNode s = p.getNext();
            if (p.col) {
                p.col = s.col;
                s.col = true;
            } else {
                p.col = s.col;
                s.col = false;
            }
            s.lef = p.lef;
            p.lef = null;
            if (s.lef != null) {
                s.lef.par = s;
            }
            if (s == p.rig) {
                p.rig = s.rig;
                s.rig = p;
                if (p.rig != null) {
                    p.rig.par = p;
                }
                AbstractNode x = p.par;
                p.par = s;
                s.par = x;
                if (x == null) {
                    this.root = s;
                } else if (x.rig == p) {
                    x.rig = s;
                } else {
                    x.lef = s;
                }
            } else {
                AbstractNode x = p.rig;
                p.rig = s.rig;
                s.rig = x;
                if (p.rig != null) {
                    p.rig.par = p;
                }
                if (s.rig != null) {
                    s.rig.par = s;
                }
                x = p.par;
                p.par = s.par;
                s.par = x;
                if (x == null) {
                    this.root = s;
                } else if (x.rig == p) {
                    x.rig = s;
                } else {
                    x.lef = s;
                }
                x = p.par;
                if (x.rig == s) {
                    x.rig = p;
                } else {
                    x.lef = p;
                }
            }
        }
        AbstractNode abstractNode = rep = p.lef != null ? p.lef : p.rig;
        if (rep != null) {
            rep.par = p.par;
            if (p.par == null) {
                this.root = rep;
            } else if (p == p.par.lef) {
                p.par.lef = rep;
            } else {
                p.par.rig = rep;
            }
            p.par = null;
            p.rig = null;
            p.lef = null;
            if (p.col) {
                this.fixAfterDel(rep);
            }
        } else if (p.par == null) {
            this.root = null;
        } else {
            if (p.col) {
                this.fixAfterDel(p);
            }
            if (p.par != null) {
                if (p == p.par.lef) {
                    p.par.lef = null;
                } else if (p == p.par.rig) {
                    p.par.rig = null;
                }
                p.par = null;
            }
        }
    }

    private static boolean colorOf(AbstractNode p) {
        return p == null ? true : p.col;
    }

    private static AbstractNode parentOf(AbstractNode p) {
        return p == null ? null : p.par;
    }

    private static void setColor(AbstractNode p, boolean c) {
        if (p != null) {
            p.col = c;
        }
    }

    private static AbstractNode leftOf(AbstractNode p) {
        return p == null ? null : p.lef;
    }

    private static AbstractNode rightOf(AbstractNode p) {
        return p == null ? null : p.rig;
    }

    private void rotateLeft(AbstractNode p) {
        if (p != null) {
            AbstractNode r = p.rig;
            p.rig = r.lef;
            if (r.lef != null) {
                r.lef.par = p;
            }
            r.par = p.par;
            if (p.par == null) {
                this.root = r;
            } else if (p.par.lef == p) {
                p.par.lef = r;
            } else {
                p.par.rig = r;
            }
            r.lef = p;
            p.par = r;
        }
    }

    private void rotateRight(AbstractNode p) {
        if (p != null) {
            AbstractNode l = p.lef;
            p.lef = l.rig;
            if (l.rig != null) {
                l.rig.par = p;
            }
            l.par = p.par;
            if (p.par == null) {
                this.root = l;
            } else if (p.par.rig == p) {
                p.par.rig = l;
            } else {
                p.par.lef = l;
            }
            l.rig = p;
            p.par = l;
        }
    }

    private void fixAfterIns(AbstractNode x) {
        x.col = false;
        while (x != null && x != this.root && !x.par.col) {
            AbstractNode y;
            if (AbstractTree.parentOf(x) == AbstractTree.leftOf(AbstractTree.parentOf(AbstractTree.parentOf(x)))) {
                y = AbstractTree.rightOf(AbstractTree.parentOf(AbstractTree.parentOf(x)));
                if (!AbstractTree.colorOf(y)) {
                    AbstractTree.setColor(AbstractTree.parentOf(x), true);
                    AbstractTree.setColor(y, true);
                    AbstractTree.setColor(AbstractTree.parentOf(AbstractTree.parentOf(x)), false);
                    x = AbstractTree.parentOf(AbstractTree.parentOf(x));
                    continue;
                }
                if (x == AbstractTree.rightOf(AbstractTree.parentOf(x))) {
                    x = AbstractTree.parentOf(x);
                    this.rotateLeft(x);
                }
                AbstractTree.setColor(AbstractTree.parentOf(x), true);
                AbstractTree.setColor(AbstractTree.parentOf(AbstractTree.parentOf(x)), false);
                this.rotateRight(AbstractTree.parentOf(AbstractTree.parentOf(x)));
                continue;
            }
            y = AbstractTree.leftOf(AbstractTree.parentOf(AbstractTree.parentOf(x)));
            if (!AbstractTree.colorOf(y)) {
                AbstractTree.setColor(AbstractTree.parentOf(x), true);
                AbstractTree.setColor(y, true);
                AbstractTree.setColor(AbstractTree.parentOf(AbstractTree.parentOf(x)), false);
                x = AbstractTree.parentOf(AbstractTree.parentOf(x));
                continue;
            }
            if (x == AbstractTree.leftOf(AbstractTree.parentOf(x))) {
                x = AbstractTree.parentOf(x);
                this.rotateRight(x);
            }
            AbstractTree.setColor(AbstractTree.parentOf(x), true);
            AbstractTree.setColor(AbstractTree.parentOf(AbstractTree.parentOf(x)), false);
            this.rotateLeft(AbstractTree.parentOf(AbstractTree.parentOf(x)));
        }
        this.root.col = true;
    }

    private void fixAfterDel(AbstractNode x) {
        while (x != this.root && AbstractTree.colorOf(x)) {
            AbstractNode sib;
            if (x == AbstractTree.leftOf(AbstractTree.parentOf(x))) {
                sib = AbstractTree.rightOf(AbstractTree.parentOf(x));
                if (!AbstractTree.colorOf(sib)) {
                    AbstractTree.setColor(sib, true);
                    AbstractTree.setColor(AbstractTree.parentOf(x), false);
                    this.rotateLeft(AbstractTree.parentOf(x));
                    sib = AbstractTree.rightOf(AbstractTree.parentOf(x));
                }
                if (AbstractTree.colorOf(AbstractTree.leftOf(sib)) && AbstractTree.colorOf(AbstractTree.rightOf(sib))) {
                    AbstractTree.setColor(sib, false);
                    x = AbstractTree.parentOf(x);
                    continue;
                }
                if (AbstractTree.colorOf(AbstractTree.rightOf(sib))) {
                    AbstractTree.setColor(AbstractTree.leftOf(sib), true);
                    AbstractTree.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = AbstractTree.rightOf(AbstractTree.parentOf(x));
                }
                AbstractTree.setColor(sib, AbstractTree.colorOf(AbstractTree.parentOf(x)));
                AbstractTree.setColor(AbstractTree.parentOf(x), true);
                AbstractTree.setColor(AbstractTree.rightOf(sib), true);
                this.rotateLeft(AbstractTree.parentOf(x));
                x = this.root;
                continue;
            }
            sib = AbstractTree.leftOf(AbstractTree.parentOf(x));
            if (!AbstractTree.colorOf(sib)) {
                AbstractTree.setColor(sib, true);
                AbstractTree.setColor(AbstractTree.parentOf(x), false);
                this.rotateRight(AbstractTree.parentOf(x));
                sib = AbstractTree.leftOf(AbstractTree.parentOf(x));
            }
            if (AbstractTree.colorOf(AbstractTree.rightOf(sib)) && AbstractTree.colorOf(AbstractTree.leftOf(sib))) {
                AbstractTree.setColor(sib, false);
                x = AbstractTree.parentOf(x);
                continue;
            }
            if (AbstractTree.colorOf(AbstractTree.leftOf(sib))) {
                AbstractTree.setColor(AbstractTree.rightOf(sib), true);
                AbstractTree.setColor(sib, false);
                this.rotateLeft(sib);
                sib = AbstractTree.leftOf(AbstractTree.parentOf(x));
            }
            AbstractTree.setColor(sib, AbstractTree.colorOf(AbstractTree.parentOf(x)));
            AbstractTree.setColor(AbstractTree.parentOf(x), true);
            AbstractTree.setColor(AbstractTree.leftOf(sib), true);
            this.rotateRight(AbstractTree.parentOf(x));
            x = this.root;
        }
        AbstractTree.setColor(x, true);
    }

    protected static int computeRedLevel(int sz) {
        int level = 0;
        int m = sz - 1;
        while (m >= 0) {
            ++level;
            m = m / 2 - 1;
        }
        return level;
    }

    protected int buildFromSortedUniqueArray(AbstractNode[] arr, int off, int len) {
        if (this.size > 0) {
            throw new IllegalStateException("Model is not empty!");
        }
        int end = off + len;
        int hi = end - 1;
        int lo = off;
        if (hi < lo) {
            return 0;
        }
        for (int i = off; i < end; ++i) {
            AbstractNode node = arr[i];
            node.par = null;
            node.lef = null;
            node.rig = null;
            node.col = true;
        }
        do {
            this.ins(arr[lo++]);
        } while (lo <= hi);
        return this.size;
    }
}

