/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.tree;

import com.spacekiller.util.midi.model.MidiNode;
import com.spacekiller.util.midi.tree.TreeTrackNode;

public class TrackNode2
extends TreeTrackNode {
    protected byte data1;

    public TrackNode2(long tick, int status, int data1) {
        super(tick, status);
        this.data1 = (byte)data1;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public int getData1() {
        return this.data1 & 0x7F;
    }

    @Override
    public int getData2() {
        return 0;
    }

    @Override
    public int read(int ofs, byte[] dst, int off, int len) {
        if (len < 1) {
            return 0;
        }
        switch (ofs) {
            case 0: {
                dst[off++] = this.status;
                if (len < 2) {
                    return 1;
                }
                dst[off] = this.data1;
                return 2;
            }
            case 1: {
                dst[off] = this.data1;
                return 1;
            }
        }
        return -1;
    }

    @Override
    public boolean compare(MidiNode o) {
        if (o == this) {
            return true;
        }
        return o.getTick() == this.tick && o.getStatus() == this.status && o.getLength() == 2 && o.getData1() == this.data1;
    }
}

