/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.tree;

import com.spacekiller.util.midi.model.MidiNode;
import com.spacekiller.util.midi.tree.TreeTrackNode;

public class TrackNodeN
extends TreeTrackNode {
    protected byte[] data;
    protected int off;
    protected int len;

    public TrackNodeN(long tick, int status, byte[] data, int off, int len) {
        super(tick, status);
        this.data = data;
        this.off = off;
        this.len = len;
    }

    @Override
    public int getLength() {
        return this.len;
    }

    @Override
    public int getData1() {
        if (this.len > 1) {
            return this.data[this.off + 1] & 0x7F;
        }
        return 0;
    }

    @Override
    public int getData2() {
        if (this.len > 2) {
            return this.data[this.off + 2] & 0x7F;
        }
        return 0;
    }

    @Override
    public int read(int ofs, byte[] dst, int o, int n) {
        if (ofs + n > this.len) {
            n = this.len - ofs;
        }
        if (n < 1) {
            return 0;
        }
        if (ofs < 0) {
            return -1;
        }
        System.arraycopy(this.data, this.off + ofs, dst, o, n);
        return n;
    }

    @Override
    public boolean compare(MidiNode o) {
        if (o == this) {
            return true;
        }
        if (o.getTick() == this.tick && o.getStatus() == this.status && o instanceof TrackNodeN) {
            TrackNodeN tn = (TrackNodeN)o;
            if (tn.len != this.len) {
                return false;
            }
            byte[] d = tn.data;
            int x = tn.off;
            int end = this.off + this.len;
            for (int i = this.off; i < end; ++i) {
                if (this.data[i] == d[x++]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

