/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.lock;

import com.spacekiller.util.lock.ReadWriteLock;

public class SyncReadWriteLock
implements ReadWriteLock {
    private Thread owner = null;
    private int add = 0;
    private int num = 0;

    @Override
    public synchronized void lockRead() {
        if (this.owner == null || this.owner == Thread.currentThread()) {
            ++this.num;
            return;
        }
        while (true) {
            try {
                do {
                    this.wait();
                } while (this.owner != null);
                ++this.num;
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized boolean tryLockRead() {
        if (this.owner == null || this.owner == Thread.currentThread()) {
            ++this.num;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean tryLockRead(long time) throws InterruptedException {
        if (this.owner == null || this.owner == Thread.currentThread()) {
            ++this.num;
            return true;
        }
        long ms = System.currentTimeMillis();
        do {
            this.wait(time);
            if (this.owner != null) continue;
            ++this.num;
            return true;
        } while (System.currentTimeMillis() - ms < time);
        return false;
    }

    @Override
    public synchronized void unlockRead() {
        if (--this.num == 0) {
            this.notify();
            return;
        }
        if (this.num < 0) {
            this.num = 0;
            throw new IllegalMonitorStateException();
        }
    }

    @Override
    public synchronized void lockWrite() {
        Thread t = Thread.currentThread();
        if (this.num == 0) {
            if (this.owner == null) {
                this.owner = t;
                return;
            }
            if (this.owner == t) {
                ++this.add;
                return;
            }
        }
        while (true) {
            try {
                do {
                    this.wait();
                } while (this.num != 0 || this.owner != null);
                this.owner = t;
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized boolean tryLockWrite() {
        if (this.num > 0) {
            return false;
        }
        if (this.owner == null) {
            this.owner = Thread.currentThread();
            return true;
        }
        Thread t = Thread.currentThread();
        if (this.owner == t) {
            ++this.add;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean tryLockWrite(long time) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (this.num == 0) {
            if (this.owner == null) {
                this.owner = t;
                return true;
            }
            if (this.owner == t) {
                ++this.add;
                return true;
            }
        }
        long ms = System.currentTimeMillis();
        do {
            this.wait(time);
            if (this.num != 0 || this.owner != null) continue;
            this.owner = t;
            return true;
        } while (System.currentTimeMillis() - ms < time);
        return false;
    }

    @Override
    public synchronized void unlockWrite() {
        if (this.owner == Thread.currentThread()) {
            if (this.add > 0) {
                --this.add;
                return;
            }
            this.owner = null;
            this.notifyAll();
            return;
        }
        throw new IllegalMonitorStateException();
    }
}

