/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.model;

import com.waxmonster.model.LineConst;
import java.util.Arrays;

public class LineUtil
implements LineConst {
    public static final long MULTIPLY_UNIT = 1000000000L;

    private LineUtil() {
    }

    public static long longSum(long a, long b) {
        long c = a + b;
        return b > 0L ? (c < a ? Long.MAX_VALUE : c) : (c > a ? Long.MIN_VALUE : c);
    }

    public static double getUnitPos(long nanoPos, double unitRate) {
        long secs = nanoPos / 1000000000L;
        double nanos = (double)(nanoPos % 1000000000L) * unitRate / 1.0E9;
        return (double)secs * unitRate + nanos;
    }

    public static double getUnitPos(double nanoPos, double unitRate) {
        long secs = (long)(nanoPos / 1.0E9);
        double nanos = (nanoPos - (double)(secs * 1000000000L)) * unitRate / 1.0E9;
        return (double)secs * unitRate + nanos;
    }

    public static long getUnitOfs(long nanoPos, double unitRate) {
        long secs = nanoPos / 1000000000L;
        double nanos = (double)(nanoPos % 1000000000L) * unitRate / 1.0E9;
        return (long)((double)secs * unitRate + nanos);
    }

    public static long getUnitOfs(double nanoPos, double unitRate) {
        long secs = (long)(nanoPos / 1.0E9);
        double nanos = (nanoPos - (double)(secs * 1000000000L)) * unitRate / 1.0E9;
        return (long)((double)secs * unitRate + nanos);
    }

    public static double getNanoPos(long unitPos, double unitRate) {
        long secs = (long)((double)unitPos / unitRate);
        double nanos = ((double)unitPos - (double)secs * unitRate) * 1.0E9 / unitRate;
        return (double)(secs * 1000000000L) + nanos;
    }

    public static double getNanoPos(double unitPos, double unitRate) {
        long secs = (long)(unitPos / unitRate);
        double nanos = (unitPos - (double)secs * unitRate) * 1.0E9 / unitRate;
        return (double)(secs * 1000000000L) + nanos;
    }

    public static long getNanoOfs(long unitPos, double unitRate) {
        long secs = (long)((double)unitPos / unitRate);
        double nanos = ((double)unitPos - (double)secs * unitRate) * 1.0E9 / unitRate;
        return (long)((double)(secs * 1000000000L) + nanos);
    }

    public static long getNanoOfs(double unitPos, double unitRate) {
        long secs = (long)(unitPos / unitRate);
        double nanos = (unitPos - (double)secs * unitRate) * 1.0E9 / unitRate;
        return (long)((double)(secs * 1000000000L) + nanos);
    }

    public static double doubleMultiply(long value, double factor) {
        long major = value / 1000000000L;
        long minor = value % 1000000000L;
        return (double)major * factor * 1.0E9 + (double)minor * factor;
    }

    public static double doubleDivide(long value, double factor) {
        long major = value / 1000000000L;
        long minor = value % 1000000000L;
        return (double)major / factor * 1.0E9 + (double)minor / factor;
    }

    public static double doubleMultiply(double value, double factor) {
        long major = (long)(value / 1.0E9);
        double rest = value - (double)(major * 1000000000L);
        long minor = (long)rest;
        return (double)major * factor * 1.0E9 + (double)minor * factor + (rest -= (double)minor) * factor;
    }

    public static double doubleDivide(double value, double factor) {
        long major = (long)(value / 1.0E9);
        double rest = value - (double)(major * 1000000000L);
        long minor = (long)rest;
        return (double)major / factor * 1.0E9 + (double)minor / factor + (rest -= (double)minor) / factor;
    }

    public static long longMultiply(long value, double factor) {
        long major = value / 1000000000L;
        long minor = value % 1000000000L;
        double majorMul = (double)major * factor;
        long majorMulLong = (long)majorMul;
        double majorMulRest = majorMul - (double)majorMulLong;
        return majorMulLong * 1000000000L + (long)(majorMulRest * 1.0E9 + (double)minor * factor);
    }

    public static long longDivide(long value, double factor) {
        long major = value / 1000000000L;
        long minor = value % 1000000000L;
        double majorMul = (double)major / factor;
        long majorMulLong = (long)majorMul;
        double majorMulRest = majorMul - (double)majorMulLong;
        return majorMulLong * 1000000000L + (long)(majorMulRest * 1.0E9 + (double)minor / factor);
    }

    public static long longMultiply(double value, double factor) {
        long major = (long)(value / 1.0E9);
        double rest = value - (double)(major * 1000000000L);
        long minor = (long)rest;
        rest -= (double)minor;
        double majorMul = (double)major * factor;
        long majorMulLong = (long)majorMul;
        double majorMulRest = majorMul - (double)majorMulLong;
        double minorMul = (double)minor * factor;
        long minorMulLong = (long)minorMul;
        double minorMulRest = minorMul - (double)minorMulLong;
        return majorMulLong * 1000000000L + minorMulLong + (long)(majorMulRest * 1.0E9 + minorMulRest + rest * factor);
    }

    public static long longDivide(double value, double factor) {
        long major = (long)(value / 1.0E9);
        double rest = value - (double)(major * 1000000000L);
        long minor = (long)rest;
        rest -= (double)minor;
        double majorMul = (double)major / factor;
        long majorMulLong = (long)majorMul;
        double majorMulRest = majorMul - (double)majorMulLong;
        double minorMul = (double)minor / factor;
        long minorMulLong = (long)minorMul;
        double minorMulRest = minorMul - (double)minorMulLong;
        return majorMulLong * 1000000000L + minorMulLong + (long)(majorMulRest * 1.0E9 + minorMulRest + rest / factor);
    }

    public static String humanMillis(long millis) {
        if (millis < 0L) {
            return "-" + Long.toString(-millis / 1000L) + "." + Integer.toString(1000 + (int)(-millis % 1000L)).substring(1);
        }
        return Long.toString(millis / 1000L) + "." + Integer.toString(1000 + (int)(millis % 1000L)).substring(1);
    }

    public static String humanMillis(double millis) {
        return LineUtil.humanMillis((long)millis);
    }

    public static String humanNanos(long nanos) {
        return LineUtil.humanMillis(nanos / 1000000L);
    }

    public static String humanNanos(double nanos) {
        return LineUtil.humanMillis(nanos / 1000000.0);
    }

    public static String formatNanos(long nanos) {
        int i;
        boolean neg;
        if (nanos < 0L) {
            if (nanos == Long.MIN_VALUE) {
                return "-9223372036.854775808";
            }
            neg = true;
            nanos = -nanos;
        } else {
            neg = false;
        }
        long seconds = nanos / 1000000000L;
        String ns = Long.toString(1000000000L + (nanos %= 1000000000L)).substring(1);
        for (i = ns.length() - 1; i > 0 && ns.charAt(i) == '0'; --i) {
        }
        String s = Long.toString(seconds) + "." + ns.substring(0, i + 1);
        return neg ? "-" + s : s;
    }

    public static long parseNanos(String s) throws NumberFormatException {
        int len = s.length();
        if (len < 1) {
            throw new NumberFormatException("For input string: \"" + s + "\"");
        }
        int from = 0;
        boolean neg = false;
        switch (s.charAt(0)) {
            case '-': {
                neg = true;
                ++from;
                break;
            }
            case '+': {
                neg = false;
                ++from;
            }
        }
        int sep = s.indexOf(46, from);
        if (sep < 0) {
            sep = len;
        }
        String sSecs = s.substring(from, sep);
        long secs = 0L;
        if (sSecs.length() > 0) {
            secs = Long.parseLong(sSecs);
        }
        long nanos = 0L;
        int digits = Math.min(9, len - sep - 1);
        if (digits > 0) {
            int zeros = 9 - digits;
            char[] chars = new char[9];
            s.getChars(sep + 1, sep + digits + 1, chars, 0);
            if (zeros > 0) {
                Arrays.fill(chars, 9 - zeros, 9, '0');
            }
            nanos = Long.parseLong(new String(chars));
        }
        if (neg) {
            long v = -secs * 1000000000L - nanos;
            return v > 0L ? Long.MIN_VALUE : v;
        }
        long v = secs * 1000000000L + nanos;
        return v < 0L ? Long.MAX_VALUE : v;
    }
}

