/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jasiohost;

import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.device.AudioDevice;
import com.waxmonster.audio.jasiohost.AsioAudioDeviceInfo;
import com.waxmonster.audio.jasiohost.AsioAudioDevicePanel;
import com.waxmonster.audio.jasiohost.AsioAudioDeviceProvider;
import com.waxmonster.audio.jasiohost.AsioAudioDriverInfo;
import com.waxmonster.audio.jasiohost.AsioAudioInputPort;
import com.waxmonster.audio.jasiohost.AsioAudioOutputPort;
import com.waxmonster.audio.jasiohost.AsioAudioPortInfo;
import com.waxmonster.audio.jasiohost.AsioAudioSupport;
import com.waxmonster.audio.jasiohost.JAsioDriverManager;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class AsioAudioDevice
extends AudioDevice {
    private static final Logger logger = Logger.getLogger(AsioAudioDevice.class.getName());
    private static final String KEY_DRIVER_NAME = "asioDriverName";
    private static final String KEY_SAMPLE_RATE = "sampleRate";
    private static final String KEY_ASYNC_PROCESSING = "asyncProcessing";
    private final AsioAudioDeviceProvider provider;
    private final AsioAudioDeviceInfo info;
    private AsioAudioDevicePanel asioDevicePanel;
    private String asioDriverName;
    private AsioAudioDriverInfo asioDriverInfo;
    private double sampleRate;
    private boolean asyncProcessing;

    public AsioAudioDevice(AsioAudioDeviceProvider provider, String name, Icon iconColor16, AsioAudioDeviceInfo info) {
        super((DeviceProvider)provider, name);
        this.setIconColor16(iconColor16);
        this.provider = provider;
        this.info = info;
    }

    public final AsioAudioDeviceProvider getAsioDeviceProvider() {
        return this.provider;
    }

    public final AsioAudioDeviceInfo getAsioDeviceInfo() {
        return this.info;
    }

    protected void activate() throws StudioException {
        this.provider.activate(this);
    }

    protected void deactivate() throws StudioException {
        this.provider.deactivate(this);
    }

    public synchronized Component getCustomizer() {
        if (this.asioDevicePanel == null) {
            this.asioDevicePanel = new AsioAudioDevicePanel();
            this.asioDevicePanel.setOpaque(false);
            this.asioDevicePanel.setDevice(this);
        }
        return this.asioDevicePanel;
    }

    public synchronized Properties getProperties() {
        Properties props = super.getProperties();
        String drvName = this.getAsioDriverName();
        if (drvName != null) {
            props.setProperty(KEY_DRIVER_NAME, drvName);
        } else {
            props.remove(KEY_DRIVER_NAME);
        }
        double rate = this.getSampleRate();
        if (rate > 0.0) {
            props.setProperty(KEY_SAMPLE_RATE, String.valueOf(rate));
        } else {
            props.remove(KEY_SAMPLE_RATE);
        }
        boolean async = this.isAsyncProcessing();
        if (async) {
            props.setProperty(KEY_ASYNC_PROCESSING, Boolean.toString(async));
        } else {
            props.remove(KEY_ASYNC_PROCESSING);
        }
        return props;
    }

    protected void applyProperty(String key, String value) {
        if (KEY_DRIVER_NAME.equals(key)) {
            this.setAsioDriverName(value);
            try {
                AsioAudioDriverInfo driverInfo = null;
                if (value != null) {
                    String driverName = value;
                    JAsioDriverManager manager = JAsioDriverManager.getInstance();
                    driverInfo = manager.getAsioDriverInfo(driverName);
                }
                this.setAsioDriverInfo(driverInfo);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            return;
        }
        if (KEY_SAMPLE_RATE.equals(key)) {
            double rate = this.parseDoubleProperty(key, value);
            if (rate > 0.0) {
                this.setSampleRate(rate);
            }
            return;
        }
        if (KEY_ASYNC_PROCESSING.equals(key)) {
            this.setAsyncProcessing("true".equalsIgnoreCase(value));
            return;
        }
    }

    public String getAsioDriverName() {
        return this.asioDriverName;
    }

    public void setAsioDriverName(String asioDriverName) {
        this.asioDriverName = asioDriverName;
    }

    public AsioAudioDriverInfo getAsioDriverInfo() {
        return this.asioDriverInfo;
    }

    public synchronized void setAsioDriverInfo(AsioAudioDriverInfo info) {
        if (this.asioDriverInfo == info) {
            return;
        }
        this.asioDriverInfo = info;
        this.refreshAudioPorts();
        if (this.asioDevicePanel != null) {
            this.asioDevicePanel.refresh(false);
        }
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public synchronized void setSampleRate(double sampleRate) {
        if (this.sampleRate == sampleRate) {
            return;
        }
        this.sampleRate = sampleRate;
        if (this.asioDevicePanel != null) {
            this.asioDevicePanel.refresh(false);
        }
    }

    public boolean isAsyncProcessing() {
        return this.asyncProcessing;
    }

    public synchronized void setAsyncProcessing(boolean asyncProcessing) {
        if (this.asyncProcessing == asyncProcessing) {
            return;
        }
        this.asyncProcessing = asyncProcessing;
        if (this.asioDevicePanel != null) {
            this.asioDevicePanel.refresh(false);
        }
    }

    protected void setSubtitle(String subtitle) {
        super.setSubtitle(subtitle);
    }

    final AsioAudioSupport getAsioAudioSupport() {
        AudioPort[] ports = this.getAudioPorts();
        for (int i = 0; i < ports.length; ++i) {
            AudioPort port = ports[i];
            if (port == null) continue;
            if (port instanceof AsioAudioInputPort) {
                AsioAudioInputPort asioPort = (AsioAudioInputPort)port;
                return asioPort.getAsioAudioSupport();
            }
            if (!(port instanceof AsioAudioOutputPort)) continue;
            AsioAudioOutputPort asioPort = (AsioAudioOutputPort)port;
            return asioPort.getAsioAudioSupport();
        }
        return null;
    }

    protected synchronized AudioPort[] getAudioPorts() {
        return super.getAudioPorts();
    }

    protected synchronized void refreshAudioPorts() {
        AudioPort[] oldPorts;
        int outputChannelCount;
        int inputChannelCount;
        int totalChannelCount;
        Studio studio = this.getStudio();
        if (studio == null) {
            return;
        }
        AsioAudioPortInfo[] inputChannels = null;
        AsioAudioPortInfo[] outputChannels = null;
        AsioAudioDriverInfo driverInfo = this.asioDriverInfo;
        if (driverInfo != null) {
            inputChannels = driverInfo.getInputChannels();
            outputChannels = driverInfo.getOutputChannels();
        }
        if ((totalChannelCount = (inputChannelCount = inputChannels == null ? 0 : inputChannels.length) + (outputChannelCount = outputChannels == null ? 0 : outputChannels.length)) == (oldPorts = this.getAudioPorts()).length) {
            boolean changed = false;
            for (int i = 0; i < totalChannelCount; ++i) {
                AsioAudioPortInfo channel = i < inputChannelCount ? inputChannels[i] : outputChannels[i - inputChannelCount];
                int channelIndex = channel.getChannelIndex();
                AudioPort oldPort = oldPorts[i];
                if (channel != null && oldPort != null) {
                    String tooltip;
                    String portName;
                    Object asioPort;
                    if (oldPort instanceof AsioAudioOutputPort && ((AsioAudioOutputPort)((Object)(asioPort = (AsioAudioOutputPort)oldPort))).getChannelIndex() == channelIndex) {
                        portName = "Channel-" + (channelIndex + 1);
                        tooltip = portName + ": " + channel.getChannelName();
                        ((AsioAudioOutputPort)((Object)asioPort)).setTooltip(tooltip);
                        continue;
                    }
                    if (oldPort instanceof AsioAudioInputPort && ((AsioAudioInputPort)((Object)(asioPort = (AsioAudioInputPort)oldPort))).getChannelIndex() == channelIndex) {
                        portName = "Channel-" + (channelIndex + 1);
                        tooltip = portName + ": " + channel.getChannelName();
                        ((AsioAudioInputPort)((Object)asioPort)).setTooltip(tooltip);
                        continue;
                    }
                }
                changed = true;
                break;
            }
            if (!changed) {
                return;
            }
        }
        AudioPort[] newPorts = new AudioPort[totalChannelCount];
        if (totalChannelCount > 0) {
            String tooltip;
            String portName;
            String channelName;
            AsioAudioPortInfo channel;
            int i;
            AsioAudioSupport audioSupport = new AsioAudioSupport(this, this.provider.getConfig());
            int portIndex = 0;
            for (i = 0; i < inputChannelCount; ++i) {
                channel = inputChannels[i];
                channelName = channel.getChannelName();
                int channelIndex = channel.getChannelIndex();
                portName = "Channel-" + (channelIndex + 1);
                tooltip = portName + ": " + channelName;
                AsioAudioOutputPort sourcePort = new AsioAudioOutputPort(portName, audioSupport, channelIndex);
                sourcePort.setTooltip(tooltip);
                newPorts[portIndex++] = sourcePort;
            }
            for (i = 0; i < outputChannelCount; ++i) {
                channel = outputChannels[i];
                channelName = channel.getChannelName();
                int channelIndex = channel.getChannelIndex();
                portName = "Channel-" + (channelIndex + 1);
                tooltip = portName + ": " + channelName;
                AsioAudioInputPort targetPort = new AsioAudioInputPort(portName, audioSupport, channelIndex);
                targetPort.setTooltip(tooltip);
                newPorts[portIndex++] = targetPort;
            }
        }
        this.setAudioPorts(newPorts);
    }
}

