/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jasiohost;

import com.synthbot.jasiohost.AsioDriver;
import com.waxmonster.audio.jasiohost.AsioAudioDevice;
import com.waxmonster.audio.jasiohost.AsioAudioDriverInfo;
import com.waxmonster.audio.jasiohost.JAsioDriverManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class AsioAudioDevicePanel
extends JPanel {
    private static final long serialVersionUID = -3455209410298763438L;
    private static final String NONE_DRIVER = "<Select Driver>";
    private static final String DEFAULT_RATE = "<Default Rate>";
    private static final Logger logger = Logger.getLogger(AsioAudioDevicePanel.class.getName());
    private AsioAudioDevice device;
    private boolean refreshing;
    private JButton jButtonControlPanel = null;
    private JLabel jLabel = null;
    private JComboBox jComboBoxSampleRate = null;
    private JComboBox comboBoxDriver;
    private Set deviceNames = new HashSet();
    private AsioDeviceRenderer renderer;
    private JCheckBox chckbxAsyncProcessing;

    public AsioAudioDevicePanel() {
        this.initialize();
        this.initAsioDevicePanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.gridy = 1;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{1.0};
        gridBagLayout.columnWeights = new double[]{1.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(289, 174));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Device Settings", 4, 2, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(4, 4, 4, 4);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 0;
        this.add((Component)panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{0, 0};
        gbl_panel.rowHeights = new int[]{0, 0};
        gbl_panel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(4, 4, 4, 4);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 0;
        panel.add((Component)panel_1, gbc_panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{0, 0, 0};
        gbl_panel_1.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_panel_1.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblAsioDriver = new JLabel("ASIO Driver:");
        GridBagConstraints gbc_lblAsioDriver = new GridBagConstraints();
        gbc_lblAsioDriver.anchor = 17;
        gbc_lblAsioDriver.insets = new Insets(0, 0, 5, 5);
        gbc_lblAsioDriver.gridx = 0;
        gbc_lblAsioDriver.gridy = 0;
        panel_1.add((Component)lblAsioDriver, gbc_lblAsioDriver);
        JPanel panel_2 = new JPanel();
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(0, 0, 5, 0);
        gbc_panel_2.fill = 2;
        gbc_panel_2.gridx = 1;
        gbc_panel_2.gridy = 0;
        panel_1.add((Component)panel_2, gbc_panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{0, 0, 0};
        gbl_panel_2.rowHeights = new int[]{0, 0};
        gbl_panel_2.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_2.setLayout(gbl_panel_2);
        this.comboBoxDriver = new JComboBox();
        this.comboBoxDriver.setOpaque(false);
        this.comboBoxDriver.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AsioAudioDevicePanel.this.refreshing && e.getStateChange() == 1) {
                    AsioAudioDevicePanel.this.handleAsioDriverSelected();
                }
            }
        });
        GridBagConstraints gbc_comboBoxDriver = new GridBagConstraints();
        gbc_comboBoxDriver.weightx = 1.0;
        gbc_comboBoxDriver.insets = new Insets(0, 0, 0, 5);
        gbc_comboBoxDriver.fill = 1;
        gbc_comboBoxDriver.gridx = 0;
        gbc_comboBoxDriver.gridy = 0;
        panel_2.add((Component)this.comboBoxDriver, gbc_comboBoxDriver);
        JButton btnNewButton = new JButton("");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsioAudioDevicePanel.this.refresh(true);
            }
        });
        btnNewButton.setToolTipText("Refresh ASIO drivers");
        btnNewButton.setMargin(new Insets(2, 2, 2, 2));
        btnNewButton.setIcon(new ImageIcon(AsioAudioDevicePanel.class.getResource("/com/waxmonster/audio/jasiohost/icons/refresh_devices.gif")));
        GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
        gbc_btnNewButton.gridx = 1;
        gbc_btnNewButton.gridy = 0;
        panel_2.add((Component)btnNewButton, gbc_btnNewButton);
        this.jLabel = new JLabel();
        GridBagConstraints gbc_jLabel = new GridBagConstraints();
        gbc_jLabel.anchor = 17;
        gbc_jLabel.insets = new Insets(0, 0, 5, 5);
        gbc_jLabel.gridx = 0;
        gbc_jLabel.gridy = 1;
        panel_1.add((Component)this.jLabel, gbc_jLabel);
        this.jLabel.setText("Sample Rate:");
        GridBagConstraints gbc_jComboBoxSampleRate = new GridBagConstraints();
        gbc_jComboBoxSampleRate.fill = 2;
        gbc_jComboBoxSampleRate.weightx = 1.0;
        gbc_jComboBoxSampleRate.insets = new Insets(0, 0, 5, 0);
        gbc_jComboBoxSampleRate.gridx = 1;
        gbc_jComboBoxSampleRate.gridy = 1;
        panel_1.add((Component)this.getJComboBoxSampleRate(), gbc_jComboBoxSampleRate);
        this.chckbxAsyncProcessing = new JCheckBox("Async. Processing");
        this.chckbxAsyncProcessing.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AsioAudioDevicePanel.this.refreshing) {
                    AsioAudioDevicePanel.this.applyAsyncProcessing();
                }
            }
        });
        this.chckbxAsyncProcessing.setToolTipText("Asynchronous processing ?");
        GridBagConstraints gbc_chckbxAsyncProcessing = new GridBagConstraints();
        gbc_chckbxAsyncProcessing.anchor = 17;
        gbc_chckbxAsyncProcessing.gridwidth = 2;
        gbc_chckbxAsyncProcessing.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxAsyncProcessing.gridx = 0;
        gbc_chckbxAsyncProcessing.gridy = 2;
        panel_1.add((Component)this.chckbxAsyncProcessing, gbc_chckbxAsyncProcessing);
        GridBagConstraints gbc_jButtonControlPanel = new GridBagConstraints();
        gbc_jButtonControlPanel.anchor = 13;
        gbc_jButtonControlPanel.gridx = 1;
        gbc_jButtonControlPanel.gridy = 3;
        panel_1.add((Component)this.getJButtonControlPanel(), gbc_jButtonControlPanel);
    }

    private void initAsioDevicePanel() {
        ImageIcon missingDeviceIcon = new ImageIcon(AsioAudioDevicePanel.class.getResource("/com/waxmonster/audio/jasiohost/icons/missing_asio_device_icon16.png"));
        this.renderer = new AsioDeviceRenderer(missingDeviceIcon);
    }

    private JButton getJButtonControlPanel() {
        if (this.jButtonControlPanel == null) {
            this.jButtonControlPanel = new JButton();
            this.jButtonControlPanel.setText("Control Panel");
            this.jButtonControlPanel.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonControlPanel.setToolTipText("Open ASIO control panel");
            this.jButtonControlPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        AsioAudioDevicePanel.this.showAsioDriverControlPanel();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            });
        }
        return this.jButtonControlPanel;
    }

    private JComboBox getJComboBoxSampleRate() {
        if (this.jComboBoxSampleRate == null) {
            this.jComboBoxSampleRate = new JComboBox();
            this.jComboBoxSampleRate.setEditable(false);
            this.jComboBoxSampleRate.setOpaque(false);
            this.jComboBoxSampleRate.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!AsioAudioDevicePanel.this.refreshing) {
                        AsioAudioDevicePanel.this.applyPreferredSampleRate();
                    }
                }
            });
        }
        return this.jComboBoxSampleRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh(boolean refreshAsioDrivers) {
        try {
            this.refreshing = true;
            this.getComboBoxDriver().removeAllItems();
            this.getComboBoxDriver().setRenderer(this.renderer);
            this.getComboBoxDriver().addItem(NONE_DRIVER);
            this.deviceNames.clear();
            AsioAudioDevice dev = this.device;
            String driverName = dev == null ? null : dev.getAsioDriverName();
            int selIndex = -1;
            JAsioDriverManager manager = JAsioDriverManager.getInstance();
            if (refreshAsioDrivers) {
                try {
                    manager.refreshAsioDrivers();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            String[] driverNames = manager.getAsioDriverNames();
            for (int i = 0; i < driverNames.length; ++i) {
                if (driverName != null && driverName.equals(driverNames[i])) {
                    selIndex = this.getComboBoxDriver().getItemCount();
                }
                this.getComboBoxDriver().addItem(driverNames[i]);
                this.deviceNames.add(driverNames[i]);
            }
            if (selIndex < 0 && driverName != null && driverName.length() > 0) {
                selIndex = this.getComboBoxDriver().getItemCount();
                this.getComboBoxDriver().addItem(driverName);
            }
            if (selIndex >= 0) {
                this.getComboBoxDriver().setSelectedIndex(selIndex);
            }
        }
        finally {
            this.refreshing = false;
        }
        this.refreshDetails();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refreshDetails() {
        try {
            AsioAudioDriverInfo asioProps;
            this.refreshing = true;
            this.getJComboBoxSampleRate().removeAllItems();
            this.getJComboBoxSampleRate().addItem(DEFAULT_RATE);
            AsioAudioDevice dev = this.device;
            if (dev != null && (asioProps = dev.getAsioDriverInfo()) != null) {
                double[] supportedRates;
                double prefRate = dev.getSampleRate();
                int prefIndex = -1;
                if (prefRate <= 0.0) {
                    prefIndex = 0;
                }
                if ((supportedRates = asioProps.getSupportedSampleRates()) != null) {
                    for (int i = 0; i < supportedRates.length; ++i) {
                        if (prefIndex < 0 && supportedRates[i] == prefRate) {
                            prefIndex = this.getJComboBoxSampleRate().getItemCount();
                        }
                        this.getJComboBoxSampleRate().addItem(this.getSampleRateString(supportedRates[i]));
                    }
                }
                if (prefIndex >= 0) {
                    this.getJComboBoxSampleRate().setSelectedIndex(prefIndex);
                } else {
                    this.getJComboBoxSampleRate().setSelectedItem(this.getSampleRateString(prefRate));
                }
                boolean async = dev.isAsyncProcessing();
                this.chckbxAsyncProcessing.setSelected(async);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAsioDriverSelected() {
        final AsioAudioDevice dev = this.device;
        if (dev == null) {
            return;
        }
        String asioDriverName = null;
        Object item = this.getComboBoxDriver().getSelectedItem();
        if (item != null && !NONE_DRIVER.equals(item)) {
            asioDriverName = String.valueOf(item);
        }
        dev.setAsioDriverName(asioDriverName);
        final String newDriverName = asioDriverName;
        Runnable target = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AsioAudioDriverInfo newDriverInfo;
                AsioAudioDriverInfo asioDriverInfo = null;
                try {
                    if (newDriverName != null) {
                        JAsioDriverManager manager = JAsioDriverManager.getInstance();
                        asioDriverInfo = manager.getAsioDriverInfo(newDriverName);
                    }
                    newDriverInfo = asioDriverInfo;
                }
                catch (Throwable e) {
                    AsioAudioDriverInfo newDriverInfo2;
                    try {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                        newDriverInfo2 = asioDriverInfo;
                    }
                    catch (Throwable throwable) {
                        AsioAudioDriverInfo newDriverInfo3 = asioDriverInfo;
                        Runnable apply = new Runnable(newDriverInfo3){
                            final /* synthetic */ AsioAudioDriverInfo val$newDriverInfo;
                            {
                                this.val$newDriverInfo = asioAudioDriverInfo;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    dev.setAsioDriverInfo(this.val$newDriverInfo);
                                }
                                finally {
                                    AsioAudioDevicePanel.this.jComboBoxSampleRate.removeAllItems();
                                    AsioAudioDevicePanel.this.comboBoxDriver.setEnabled(true);
                                    AsioAudioDevicePanel.this.jComboBoxSampleRate.setEnabled(true);
                                    AsioAudioDevicePanel.this.jButtonControlPanel.setEnabled(true);
                                    AsioAudioDevicePanel.this.refreshDetails();
                                }
                            }
                        };
                        SwingUtilities.invokeLater(apply);
                        throw throwable;
                    }
                    Runnable apply = new /* invalid duplicate definition of identical inner class */;
                    SwingUtilities.invokeLater(apply);
                }
                Runnable apply = new /* invalid duplicate definition of identical inner class */;
                SwingUtilities.invokeLater(apply);
            }
        };
        Thread thread = new Thread(target, "SetAsioDriver-" + asioDriverName);
        try {
            this.refreshing = true;
            this.comboBoxDriver.setEnabled(false);
            this.jComboBoxSampleRate.setEnabled(false);
            this.jComboBoxSampleRate.removeAllItems();
            this.jComboBoxSampleRate.addItem("Getting ASIO driver info...");
            this.jComboBoxSampleRate.setSelectedIndex(0);
            this.jButtonControlPanel.setEnabled(false);
        }
        finally {
            this.refreshing = false;
        }
        thread.start();
    }

    protected String getSampleRateString(double rate) {
        String s = String.valueOf(rate);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    protected void applyPreferredSampleRate() {
        Object item = this.getJComboBoxSampleRate().getSelectedItem();
        if (item == null) {
            return;
        }
        try {
            String s = item.toString();
            double rate = DEFAULT_RATE.equals(s) ? 0.0 : Double.parseDouble(s);
            AsioAudioDevice dev = this.device;
            if (dev != null) {
                dev.setSampleRate(rate);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void applyAsyncProcessing() {
        boolean async = this.chckbxAsyncProcessing.isSelected();
        AsioAudioDevice dev = this.device;
        if (dev == null) {
            return;
        }
        dev.setAsyncProcessing(async);
    }

    public boolean showAsioDriverControlPanel() throws Exception {
        AsioAudioDevice dev = this.device;
        if (dev == null) {
            return false;
        }
        final AsioAudioDriverInfo props = dev.getAsioDriverInfo();
        if (props == null) {
            return false;
        }
        Runnable target = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String driverName = props.getDriverName();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Opening ASIO driver to show control panel: driverName=" + driverName);
                    }
                    JAsioDriverManager driverManager = JAsioDriverManager.getInstance();
                    AsioDriver driver = driverManager.openAsioDriver(driverName);
                    try {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Opening ASIO control panel: " + driverName);
                        }
                        driver.openControlPanel();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Opened ASIO control panel: " + driverName);
                        }
                    }
                    finally {
                        if (driver != null) {
                            driverManager.closeAsioDriver(driver);
                        }
                    }
                }
                finally {
                    AsioAudioDevicePanel.this.getJButtonControlPanel().setEnabled(true);
                }
            }
        };
        Thread thread = new Thread(target, "AsioControlPanel");
        this.getJButtonControlPanel().setEnabled(false);
        thread.start();
        return true;
    }

    public AsioAudioDevice getDevice() {
        return this.device;
    }

    public synchronized void setDevice(AsioAudioDevice device) {
        this.device = device;
        this.refresh(false);
    }

    protected JComboBox getComboBoxDriver() {
        return this.comboBoxDriver;
    }

    protected JCheckBox getChckbxAsyncProcessing() {
        return this.chckbxAsyncProcessing;
    }

    protected class AsioDeviceRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -3468550508935989377L;
        private Icon missingDeviceIcon;

        public AsioDeviceRenderer(Icon missingDeviceIcon) {
            this.missingDeviceIcon = missingDeviceIcon;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = null;
            String tip = null;
            String devName = String.valueOf(value);
            if (!AsioAudioDevicePanel.NONE_DRIVER.equals(devName) && !AsioAudioDevicePanel.this.deviceNames.contains(devName)) {
                icon = this.missingDeviceIcon;
                tip = "Device not found: " + devName;
            }
            this.setIcon(icon);
            this.setToolTipText(tip);
            this.setOpaque(isSelected);
            return comp;
        }
    }
}

