/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jasiohost;

import com.spacekiller.util.Tools;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioPortType;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.jasiohost.AsioAudioDevice;
import com.waxmonster.audio.jasiohost.AsioAudioDeviceInfo;
import com.waxmonster.audio.jasiohost.AsioAudioInputPort;
import com.waxmonster.audio.jasiohost.AsioAudioOutputPort;
import com.waxmonster.audio.jasiohost.AsioAudioSupport;
import com.waxmonster.audio.jasiohost.AsioAudioSyncGroup;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.DeviceInfo;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.StudioException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class AsioAudioDeviceProvider
extends DeviceProvider {
    public static final String PROVIDER_NAME = "AsioDeviceProvider";
    public static final String ASIO_DEVICE_NAME = "ASIO-Audio";
    public static final String DEVICE_CATEGORY_NAME = "Audio Devices";
    private static final Logger logger = Logger.getLogger(AsioAudioDeviceProvider.class.getName());
    private static final String CLASS_NAME = AsioAudioDeviceProvider.class.getName();
    private AudioEngineConfig config = new AudioEngineConfig();

    public AsioAudioDeviceProvider() {
        super(PROVIDER_NAME);
        this.initAsioDeviceProvider();
    }

    protected void initAsioDeviceProvider() {
        String tooltip = "ASIO-Audio Device";
        Icon icon = Tools.getIcon(AsioAudioDeviceProvider.class, (String)"/com/waxmonster/audio/jasiohost/icons/asio_audio_icon16.png");
        AsioAudioDeviceInfo sourceInfo = new AsioAudioDeviceInfo(ASIO_DEVICE_NAME, tooltip, icon);
        this.addDeviceInfo(sourceInfo);
    }

    public void refreshDeviceInfo() {
    }

    public synchronized Device createDevice(DeviceInfo info) throws StudioException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createDevice", info);
        }
        if (info == null || !(info instanceof AsioAudioDeviceInfo)) {
            throw new StudioException("Invalid DeviceInfo: " + info);
        }
        AsioAudioDeviceInfo asioInfo = (AsioAudioDeviceInfo)info;
        String devName = asioInfo.getDeviceName();
        Icon iconColor16 = info.getIcon(1);
        AsioAudioDevice dev = new AsioAudioDevice(this, devName, iconColor16, asioInfo);
        String title = ASIO_DEVICE_NAME;
        String subtitle = null;
        dev.setTitle(title);
        dev.setSubtitle(subtitle);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "createDevice", (Object)dev);
        }
        return dev;
    }

    protected synchronized void activate(AsioAudioDevice device) throws StudioException {
        HashSet<AsioAudioSyncGroup> groups = new HashSet<AsioAudioSyncGroup>();
        AudioPort[] ports = device.getAudioPorts();
        for (int i = 0; i < ports.length; ++i) {
            AsioAudioSupport support;
            AudioPort port = ports[i];
            if (port instanceof AsioAudioInputPort) {
                AsioAudioInputPort inputPort = (AsioAudioInputPort)port;
                support = inputPort.getAsioAudioSupport();
                groups.add(support.getAsioAudioSyncGroup());
                continue;
            }
            if (!(port instanceof AsioAudioOutputPort)) continue;
            AsioAudioOutputPort outputPort = (AsioAudioOutputPort)port;
            support = outputPort.getAsioAudioSupport();
            groups.add(support.getAsioAudioSyncGroup());
        }
        for (AsioAudioSyncGroup group : groups) {
            group.getAsioAudioEngine().activateAsioAudioDevice(device);
        }
    }

    protected synchronized void deactivate(AsioAudioDevice device) throws StudioException {
        HashSet<AsioAudioSyncGroup> groups = new HashSet<AsioAudioSyncGroup>();
        AudioPort[] ports = device.getAudioPorts();
        for (int i = 0; i < ports.length; ++i) {
            AsioAudioSupport support;
            AudioPort port = ports[i];
            if (port instanceof AsioAudioInputPort) {
                AsioAudioInputPort inputPort = (AsioAudioInputPort)port;
                support = inputPort.getAsioAudioSupport();
                groups.add(support.getAsioAudioSyncGroup());
                continue;
            }
            if (!(port instanceof AsioAudioOutputPort)) continue;
            AsioAudioOutputPort outputPort = (AsioAudioOutputPort)port;
            support = outputPort.getAsioAudioSupport();
            groups.add(support.getAsioAudioSyncGroup());
        }
        for (AsioAudioSyncGroup group : groups) {
            group.getAsioAudioEngine().deactivateAsioAudioDevice(device);
        }
    }

    public PortType getPortType(String typeName) {
        return AudioPortType.getAudioPortType((String)typeName);
    }

    public AudioEngineConfig getConfig() {
        return this.config;
    }

    public void setConfig(AudioEngineConfig config) {
        this.config = config;
    }
}

