/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jasiohost;

import com.spacekiller.util.Clock;
import com.synthbot.jasiohost.AsioChannel;
import com.synthbot.jasiohost.AsioDriver;
import com.synthbot.jasiohost.AsioDriverListener;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.jasiohost.AsioAudioEngine;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsioAudioDriverHandler
implements AsioDriverListener {
    private static final Logger logger = Logger.getLogger(AsioAudioDriverHandler.class.getName());
    private final AsioAudioEngine engine;
    private final AsioDriver driver;
    private final int frames;
    private final AudioProcessor[] pr;
    private final int np;
    private final Clock ck;

    public AsioAudioDriverHandler(AsioAudioEngine engine, AsioDriver driver, int bufSize, float frameRate, Clock clock, AudioProcessor[] processors) throws Exception {
        this.engine = engine;
        this.driver = driver;
        this.frames = bufSize;
        this.pr = processors;
        this.np = processors.length;
        this.ck = clock;
    }

    public void resetRequest() {
        this.engine.resetRequest();
    }

    public void resyncRequest() {
        this.engine.resyncRequest();
    }

    public void bufferSizeChanged(int bufferSize) {
        this.engine.bufferSizeChanged(bufferSize);
    }

    public void sampleRateDidChange(double sampleRate) {
        this.engine.sampleRateChanged(sampleRate);
    }

    public void latenciesChanged(int inputLatency, int outputLatency) {
        this.engine.latenciesChanged(inputLatency, outputLatency);
    }

    public void bufferSwitch(long time, long pos, Set<AsioChannel> ac) {
        try {
            time = this.ck.nanos();
            int i = 0;
            while (i < this.np) {
                this.pr[i++].process(time, this.frames);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.engine.bufferSwitchError(e);
        }
    }

    public void shutdownAudioProcessors() {
        for (int i = 0; i < this.np; ++i) {
            try {
                this.pr[i].shutdown();
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected AsioDriver getDriver() {
        return this.driver;
    }
}

