/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jasiohost;

import com.spacekiller.util.Clock;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.sound.RawSampleBuffer;
import com.spacekiller.util.sound.SampleBuffer;
import com.spacekiller.util.sound.SampleType;
import com.spacekiller.util.sound.SampleTypes;
import com.synthbot.jasiohost.AsioChannel;
import com.synthbot.jasiohost.AsioDriver;
import com.synthbot.jasiohost.AsioDriverListener;
import com.synthbot.jasiohost.AsioSampleType;
import com.waxmonster.audio.AudioContext;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.impl.AbstractAudioEngine;
import com.waxmonster.audio.impl.AudioContextImpl;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.impl.SampleBufferProxy;
import com.waxmonster.audio.impl.Wrapper;
import com.waxmonster.audio.impl.WrapperInputPort;
import com.waxmonster.audio.impl.WrapperOutputPort;
import com.waxmonster.audio.impl.WrapperPort;
import com.waxmonster.audio.jasiohost.AsioAudioDevice;
import com.waxmonster.audio.jasiohost.AsioAudioDriverHandler;
import com.waxmonster.audio.jasiohost.AsioAudioInputPort;
import com.waxmonster.audio.jasiohost.AsioAudioOutputPort;
import com.waxmonster.audio.jasiohost.AsioAudioSupport;
import com.waxmonster.audio.jasiohost.AsioAudioSyncGroup;
import com.waxmonster.audio.jasiohost.DebugAsioAudioDriverHandler;
import com.waxmonster.audio.jasiohost.JAsioAsync;
import com.waxmonster.audio.jasiohost.JAsioDriverManager;
import com.waxmonster.audio.jasiohost.JAsioReader;
import com.waxmonster.audio.jasiohost.JAsioTarget;
import com.waxmonster.audio.jasiohost.JAsioWriter;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.Device;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsioAudioEngine
extends AbstractAudioEngine {
    private static final Logger logger = Logger.getLogger(AsioAudioEngine.class.getName());
    private final String asioDriverName;
    private final Clock clock;
    private final boolean async;
    private final ThreadManager threadManager;
    private AsioAudioSupport asioAudioSupport;
    private AsioAudioSyncGroup asioSyncGroup;
    private AudioContextImpl audioContext;
    private JAsioDriverManager asioDriverManager;
    private AsioDriver asioDriver;
    private AsioAudioDriverHandler asioDriverHandler;
    private Set<AsioChannel> channelsToInit;
    private float frameRate;
    private int bufferSize;
    private Wrapper syncGroupWrapper;
    private List<AsioSourceInfo> asioSourceList;
    private List<AsioTargetInfo> asioTargetList;

    public AsioAudioEngine(String asioDriverName, AudioEngineConfig config, Clock clock, boolean async, ThreadManager threadManager) {
        super(config);
        this.asioDriverName = asioDriverName;
        this.clock = clock;
        this.async = async;
        this.threadManager = threadManager;
    }

    public String toString() {
        return super.toString() + "[" + this.asioDriverName + "]";
    }

    public static float castAsioSampleRate(double sampleRate) {
        float rate = (float)sampleRate;
        if (sampleRate != (double)rate) {
            throw new IllegalArgumentException("Unsupported sample rate: " + sampleRate + " != " + (double)rate);
        }
        return rate;
    }

    public static SampleType getSampleType(AsioSampleType asioSampleType) {
        switch (asioSampleType) {
            case ASIOSTInt16MSB: {
                return SampleTypes.Int16Msb;
            }
            case ASIOSTInt16LSB: {
                return SampleTypes.Int16Lsb;
            }
            case ASIOSTInt24MSB: {
                return SampleTypes.Int24Msb;
            }
            case ASIOSTInt24LSB: {
                return SampleTypes.Int24Lsb;
            }
            case ASIOSTInt32MSB: {
                return SampleTypes.Int32Msb;
            }
            case ASIOSTInt32LSB: {
                return SampleTypes.Int32Lsb;
            }
            case ASIOSTFloat64MSB: {
                return SampleTypes.Double64Msb;
            }
            case ASIOSTFloat64LSB: {
                return SampleTypes.Double64Lsb;
            }
            case ASIOSTFloat32MSB: {
                return SampleTypes.Float32Msb;
            }
            case ASIOSTFloat32LSB: {
                return SampleTypes.Float32Lsb;
            }
            case ASIOSTInt32MSB24: {
                return SampleTypes.Int32Msb24;
            }
            case ASIOSTInt32LSB24: {
                return SampleTypes.Int32Lsb24;
            }
            case ASIOSTInt32MSB20: {
                break;
            }
            case ASIOSTInt32LSB20: {
                break;
            }
            case ASIOSTInt32MSB18: {
                break;
            }
            case ASIOSTInt32LSB18: {
                break;
            }
            case ASIOSTInt32MSB16: {
                break;
            }
            case ASIOSTInt32LSB16: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported ASIO sample type: " + asioSampleType);
            }
        }
        throw new UnsupportedOperationException("ASIO sample type is currently not supported: " + asioSampleType);
    }

    public void prepare(AudioSyncGroup group, AudioContext context) throws AudioException {
        AudioContextImpl syncGroupContext = this.getAudioContextImpl(context);
        if (group == null || !(group instanceof AsioAudioSyncGroup)) {
            throw new AudioException("Invalid AudioSyncGroup: " + group);
        }
        AsioAudioSyncGroup asioGroup = (AsioAudioSyncGroup)group;
        AsioAudioSupport asioSupport = asioGroup.getAsioAudioSupport();
        this.prepareAsioDriver(asioSupport, syncGroupContext);
    }

    public void start() throws AudioException {
        this.startAsioDriver();
    }

    final void activateAsioAudioDevice(AsioAudioDevice device) throws StudioException {
        AudioContextImpl syncGroupContext;
        Studio studio = device.getStudio();
        if (studio == null) {
            throw new StudioException("Device is not assigned to a studio: " + (Object)((Object)device));
        }
        AsioAudioSupport asioSupport = device.getAsioAudioSupport();
        boolean prepared = this.prepareAsioDriver(asioSupport, syncGroupContext = this.createAudioContextImpl(studio));
        if (prepared) {
            this.startAsioDriver();
        }
    }

    final void deactivateAsioAudioDevice(AsioAudioDevice device) throws StudioException {
        AsioAudioSupport support = device.getAsioAudioSupport();
        if (support == null) {
            return;
        }
        this.deactivateAsioDriver(support);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepareAsioDriver(AsioAudioSupport support, AudioContextImpl syncGroupContext) throws AudioException {
        AsioAudioSyncGroup syncGroup;
        AsioAudioEngine asioAudioEngine = this;
        synchronized (asioAudioEngine) {
            if (this.asioAudioSupport == support) {
                return false;
            }
            syncGroup = support.getAsioAudioSyncGroup();
            if (syncGroup == null) {
                throw new AudioException("No AsioAudioSyncGroup available: " + (Object)((Object)support));
            }
            if (this.asioSyncGroup == syncGroup) {
                return false;
            }
            if (this.asioAudioSupport != null) {
                throw new AudioException("AsioAudioEngine is already activated: " + (Object)((Object)this));
            }
            AsioAudioEngine engine = syncGroup.getAsioAudioEngine();
            if (engine != this) {
                throw new AudioException("Invalid AsioAudioEngine: " + (Object)((Object)engine) + " != " + (Object)((Object)this));
            }
            this.asioAudioSupport = support;
            this.asioSyncGroup = syncGroup;
            this.audioContext = syncGroupContext;
        }
        boolean success = false;
        try {
            AsioSampleType asioSampleType;
            AsioChannel channel;
            int channelIndex;
            Object asioPort;
            int bufSize;
            float rate;
            int i;
            int sourceCount = syncGroup.getOutputPortCount();
            this.asioSourceList = new ArrayList<AsioSourceInfo>(sourceCount);
            HashMap<AsioAudioOutputPort, AsioSourceInfo> asioSourceMap = new HashMap<AsioAudioOutputPort, AsioSourceInfo>();
            for (int i2 = 0; i2 < sourceCount; ++i2) {
                AudioOutputPort port = syncGroup.getOutputPortAt(i2);
                if (!(port instanceof AsioAudioOutputPort)) continue;
                AsioAudioOutputPort asioPort2 = (AsioAudioOutputPort)port;
                LinkedList<AudioInputPort> targetPortList = new LinkedList<AudioInputPort>();
                LinkedList<AudioSyncGroup> targetGroupList = new LinkedList<AudioSyncGroup>();
                Connection[] conns = asioPort2.getConnections();
                for (int k = 0; k < conns.length; ++k) {
                    Port partner = conns[k].getPartner((Port)asioPort2);
                    if (partner == null) continue;
                    if (partner instanceof AudioInputPort) {
                        AudioSyncGroup destGroup;
                        AudioSupport audioSupport;
                        AudioInputPort destPort = (AudioInputPort)partner;
                        Device destDevice = destPort.getDevice();
                        if (!destDevice.isEnabled() || (audioSupport = destPort.getAudioSupport()) == null || (destGroup = audioSupport.getAudioSyncGroup((AudioPort)destPort)) == null) continue;
                        targetPortList.add(destPort);
                        targetGroupList.add(destGroup);
                        continue;
                    }
                    throw new StudioException("Unsupported partner port: " + partner);
                }
                if (targetPortList.isEmpty()) continue;
                AudioInputPort[] targetPorts = targetPortList.toArray(new AudioInputPort[targetPortList.size()]);
                AudioSyncGroup[] targetGroups = targetGroupList.toArray(new AudioSyncGroup[targetGroupList.size()]);
                AsioSourceInfo asioSourceInfo = new AsioSourceInfo(asioPort2, i2, targetPorts, targetGroups);
                this.asioSourceList.add(asioSourceInfo);
                asioSourceMap.put(asioPort2, asioSourceInfo);
            }
            int destCount = syncGroup.getInputPortCount();
            this.asioTargetList = new ArrayList<AsioTargetInfo>(destCount);
            HashMap<AsioAudioInputPort, AsioTargetInfo> asioTargetMap = new HashMap<AsioAudioInputPort, AsioTargetInfo>();
            for (i = 0; i < destCount; ++i) {
                AudioSyncGroup sourceGroup;
                AudioSupport sourceSupport;
                Device sourceDevice;
                AudioInputPort port = syncGroup.getInputPortAt(i);
                if (!(port instanceof AsioAudioInputPort)) continue;
                AsioAudioInputPort asioPort3 = (AsioAudioInputPort)port;
                AudioOutputPort sourcePort = port.getSourcePort();
                if (sourcePort == null || !(sourceDevice = sourcePort.getDevice()).isEnabled() || (sourceSupport = sourcePort.getAudioSupport()) == null || (sourceGroup = sourceSupport.getAudioSyncGroup((AudioPort)sourcePort)) == null) continue;
                AsioTargetInfo asioTargetInfo = new AsioTargetInfo(sourcePort, sourceGroup, asioPort3, i);
                this.asioTargetList.add(asioTargetInfo);
                asioTargetMap.put(asioPort3, asioTargetInfo);
            }
            if (this.asioSourceList.isEmpty() && this.asioTargetList.isEmpty()) {
                success = true;
                i = 0;
                return i != 0;
            }
            this.asioDriverManager = JAsioDriverManager.getInstance();
            this.asioDriver = this.asioDriverManager.openAsioDriver(this.asioDriverName);
            double defaultRate = this.asioDriver.getSampleRate();
            double prefRate = syncGroup.getAsioSampleRate();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ASIO Driver: " + this.asioDriverName + " -> " + this.asioDriver + ", defaultRate=" + defaultRate + ", prefRate=" + prefRate);
            }
            if (prefRate > 0.0 && prefRate != defaultRate) {
                this.asioDriver.setSampleRate(prefRate);
            }
            this.frameRate = rate = AsioAudioEngine.castAsioSampleRate(this.asioDriver.getSampleRate());
            this.bufferSize = bufSize = this.asioDriver.getBufferPreferredSize();
            Wrapper wrapper = syncGroupContext.getGroupWrapper((AudioSyncGroup)syncGroup);
            wrapper.setFrameRate(rate);
            wrapper.setBufferSize(bufSize);
            this.syncGroupWrapper = wrapper;
            this.channelsToInit = new HashSet<AsioChannel>();
            for (AsioSourceInfo asioSourceInfo : this.asioSourceList) {
                asioPort = asioSourceInfo.sourcePort;
                channelIndex = ((AsioAudioOutputPort)((Object)asioPort)).getChannelIndex();
                channel = this.asioDriver.getChannelInput(channelIndex);
                asioSampleType = channel.getSampleType();
                SampleType sampleType = AsioAudioEngine.getSampleType(asioSampleType);
                int channels = 1;
                RawSampleBuffer rsb = sampleType.createRawSampleBuffer(channels, rate, bufSize);
                WrapperOutputPort outputPort = wrapper.getOutputPortAt(asioSourceInfo.sourcePortIndex);
                SampleBufferProxy bufferProxy = new SampleBufferProxy((WrapperPort)outputPort, (SampleBuffer)rsb);
                outputPort.setSampleBufferProxy(bufferProxy);
                asioSourceInfo.asioInputChannel = channel;
                asioSourceInfo.sampleBuffer = rsb;
                this.channelsToInit.add(channel);
            }
            for (AsioTargetInfo asioTargetInfo : this.asioTargetList) {
                RawSampleBuffer sourceBuffer;
                AsioAudioOutputPort asioSourcePort;
                AsioSourceInfo sourceInfo;
                asioPort = asioTargetInfo.targetPort;
                channelIndex = ((AsioAudioInputPort)((Object)asioPort)).getChannelIndex();
                channel = this.asioDriver.getChannelOutput(channelIndex);
                asioSampleType = channel.getSampleType();
                RawSampleBuffer rsb = null;
                AudioOutputPort sourcePort = asioTargetInfo.sourcePort;
                if (sourcePort != null && sourcePort instanceof AsioAudioOutputPort && (sourceInfo = (AsioSourceInfo)asioSourceMap.get((Object)(asioSourcePort = (AsioAudioOutputPort)sourcePort))) != null && (sourceBuffer = sourceInfo.sampleBuffer) != null) {
                    rsb = sourceBuffer;
                }
                if (rsb == null) {
                    SampleType sampleType = AsioAudioEngine.getSampleType(asioSampleType);
                    int channels = 1;
                    rsb = sampleType.createRawSampleBuffer(channels, rate, bufSize);
                }
                WrapperInputPort inputPort = wrapper.getInputPortAt(asioTargetInfo.targetPortIndex);
                SampleBufferProxy bufferProxy = new SampleBufferProxy((WrapperPort)inputPort, rsb);
                inputPort.setSampleBufferProxy(bufferProxy);
                asioTargetInfo.asioOutputChannel = channel;
                asioTargetInfo.sampleBuffer = rsb;
                this.channelsToInit.add(channel);
            }
            this.prepareAudioSyncGroup(this.asioSyncGroup, syncGroupContext);
            success = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ASIO engine prepared: " + (Object)((Object)this));
            }
            boolean bl = true;
            return bl;
        }
        catch (AudioException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AudioException((Throwable)e);
        }
        finally {
            if (!success) {
                try {
                    this.deactivateAsioDriver(support);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startAsioDriver() throws AudioException {
        AsioAudioSupport support;
        AsioAudioEngine asioAudioEngine = this;
        synchronized (asioAudioEngine) {
            support = this.asioAudioSupport;
            if (support == null) {
                throw new AudioException("AsioAudioEngine is not prepared: " + (Object)((Object)this));
            }
        }
        boolean success = false;
        try {
            ArrayList<AudioProcessor> apList;
            if (this.syncGroupWrapper.isStarted()) {
                throw new AudioException("AsioAudioEngine is already started: " + (Object)((Object)this));
            }
            ArrayList<AudioProcessor> asioReaderList = new ArrayList<AudioProcessor>(this.asioSourceList.size());
            for (AsioSourceInfo info : this.asioSourceList) {
                AsioChannel channel = info.asioInputChannel;
                RawSampleBuffer rsb = info.sampleBuffer;
                asioReaderList.add(new JAsioReader(channel, rsb));
            }
            AudioProcessor[] postProcessors = this.syncGroupWrapper.createPostProcessors();
            for (int i = 0; i < postProcessors.length; ++i) {
                asioReaderList.add(postProcessors[i]);
            }
            AudioProcessor[] contextProcessors = this.createAudioProcessors(this.audioContext);
            ArrayList<AudioProcessor> asioWriterList = new ArrayList<AudioProcessor>(this.asioTargetList.size());
            AudioProcessor[] preProcessors = this.syncGroupWrapper.createPreProcessors();
            for (int i = 0; i < preProcessors.length; ++i) {
                asioWriterList.add(preProcessors[i]);
            }
            for (AsioTargetInfo info : this.asioTargetList) {
                AsioChannel channel = info.asioOutputChannel;
                RawSampleBuffer rsb = info.sampleBuffer;
                WrapperInputPort inputPort = this.syncGroupWrapper.getInputPortAt(info.targetPortIndex);
                SampleBufferProxy bufferProxy = inputPort.getSampleBufferProxy();
                if (bufferProxy == null) {
                    throw new AudioException("SampleBufferProxy not available for port: " + inputPort.getAudioInputPort());
                }
                SampleBuffer src = bufferProxy.getSampleBuffer();
                if (src == rsb) {
                    asioWriterList.add(new JAsioWriter(rsb, channel));
                    continue;
                }
                asioWriterList.add(new JAsioTarget(src, rsb, channel));
            }
            if (this.async && contextProcessors.length > 0) {
                int threadPrio = 10;
                String threadName = "JAsioAsync-" + this.asioDriver.getName();
                JAsioAsync asioAsync = new JAsioAsync(contextProcessors, this.threadManager, threadPrio, threadName);
                asioAsync.start();
                apList = new ArrayList(asioReaderList.size() + asioWriterList.size() + 1);
                apList.addAll(asioReaderList);
                apList.add(asioAsync);
                apList.addAll(asioWriterList);
            } else {
                apList = new ArrayList<AudioProcessor>(asioReaderList.size() + contextProcessors.length + asioWriterList.size());
                apList.addAll(asioReaderList);
                for (AudioProcessor cp : contextProcessors) {
                    apList.add(cp);
                }
                apList.addAll(asioWriterList);
            }
            AudioProcessor[] audioProcessors = apList.toArray(new AudioProcessor[apList.size()]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating AsioDriverHandler: driver=" + this.asioDriverName + ", bufferSize=" + this.bufferSize + ", frameRate=" + this.frameRate + ", processors=" + audioProcessors.length);
            }
            if (logger.isLoggable(Level.FINER)) {
                for (int i = 0; i < audioProcessors.length; ++i) {
                    logger.finer(" - AudioProcessor #" + i + ": " + audioProcessors[i]);
                }
            }
            this.asioDriverHandler = this.config.isDebug() ? new DebugAsioAudioDriverHandler(this, this.asioDriver, this.bufferSize, this.frameRate, this.clock, audioProcessors) : new AsioAudioDriverHandler(this, this.asioDriver, this.bufferSize, this.frameRate, this.clock, audioProcessors);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("AsioDriverHandler created: " + this.asioDriverHandler);
            }
            this.asioDriver.addAsioDriverListener((AsioDriverListener)this.asioDriverHandler);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating ASIO buffers: driver=" + this.asioDriverName + ", bufferSize=" + this.bufferSize + ", inputChannels=" + this.asioSourceList.size() + ", outputChannels=" + this.asioTargetList.size());
            }
            this.asioDriver.createBuffers(this.channelsToInit);
            if (logger.isLoggable(Level.FINER)) {
                int index = 0;
                for (AsioChannel channel : this.channelsToInit) {
                    logger.finer("AsioChannel #" + index + ": " + channel + ", buffer=" + channel.getByteBuffer());
                    ++index;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting ASIO driver: " + this.asioDriverName);
            }
            this.asioDriver.start();
            this.syncGroupWrapper.setStarted(true);
            success = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ASIO driver started: " + this.asioDriverName);
            }
            this.startAudioEngines(this.audioContext);
        }
        catch (AudioException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new AudioException((Throwable)e);
        }
        finally {
            if (!success) {
                try {
                    this.deactivateAsioDriver(support);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateAsioDriver(AsioAudioSupport support) throws AudioException {
        AsioAudioDriverHandler handler;
        AsioDriver driver;
        JAsioDriverManager driverManager;
        AsioAudioEngine asioAudioEngine = this;
        synchronized (asioAudioEngine) {
            driverManager = this.asioDriverManager;
            driver = this.asioDriver;
            if (driver == null && this.asioSyncGroup == null && this.asioAudioSupport == null) {
                return;
            }
            if (support != this.asioAudioSupport) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Ignored invalid AsioAudioSupport: " + (Object)((Object)support) + " != " + (Object)((Object)this.asioAudioSupport));
                }
                return;
            }
        }
        if (driver != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Stopping ASIO driver: " + this.asioDriverName);
            }
            if (driverManager != null) {
                driverManager.closeAsioDriver(driver);
            } else {
                driver.shutdownAndUnloadDriver();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ASIO driver stopped: " + this.asioDriverName);
            }
        }
        if ((handler = this.asioDriverHandler) != null) {
            handler.shutdownAudioProcessors();
        }
        AsioAudioEngine asioAudioEngine2 = this;
        synchronized (asioAudioEngine2) {
            this.asioDriver = null;
            this.asioDriverManager = null;
            this.asioDriverHandler = null;
            this.audioContext = null;
            this.asioSyncGroup = null;
            this.asioAudioSupport = null;
        }
        if (support != null) {
            support.reset();
        }
    }

    protected void latenciesChanged(int inputLatency, int outputLatency) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TODO ? latenciesChanged: driver=" + this.asioDriverName + ", inputLatency=" + inputLatency + ", outputLatency=" + outputLatency);
        }
    }

    protected void resyncRequest() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("TODO ? resyncRequest: driver=" + this.asioDriverName);
        }
    }

    protected void resetRequest() {
        try {
            this.restartAudioEngines(this.audioContext);
        }
        catch (Throwable e) {
            this.handleError(e);
        }
    }

    protected void bufferSizeChanged(int bufferSize) {
        try {
            this.restartAudioEngines(this.audioContext);
        }
        catch (Throwable e) {
            this.handleError(e);
        }
    }

    protected void sampleRateChanged(double sampleRate) {
        try {
            this.restartAudioEngines(this.audioContext);
        }
        catch (Throwable e) {
            this.handleError(e);
        }
    }

    protected void bufferSwitchError(Throwable e) {
        this.handleError(e);
    }

    protected void handleError(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
        try {
            this.deactivateAsioDriver(this.asioAudioSupport);
        }
        catch (Throwable e2) {
            logger.log(Level.SEVERE, e2.getMessage(), e2);
            AsioDriver driver = this.asioDriver;
            if (driver != null) {
                try {
                    driver.shutdownAndUnloadDriver();
                }
                catch (Throwable e3) {
                    logger.log(Level.SEVERE, e3.getMessage(), e3);
                }
            }
            return;
        }
    }

    protected class AsioTargetInfo {
        protected final AudioOutputPort sourcePort;
        protected final AudioSyncGroup sourceGroup;
        protected final AsioAudioInputPort targetPort;
        protected final int targetPortIndex;
        protected AsioChannel asioOutputChannel;
        protected RawSampleBuffer sampleBuffer;

        public AsioTargetInfo(AudioOutputPort sourcePort, AudioSyncGroup sourceGroup, AsioAudioInputPort targetPort, int targetPortIndex) {
            this.sourcePort = sourcePort;
            this.sourceGroup = sourceGroup;
            this.targetPort = targetPort;
            this.targetPortIndex = targetPortIndex;
        }
    }

    protected class AsioSourceInfo {
        protected final AsioAudioOutputPort sourcePort;
        protected final int sourcePortIndex;
        protected final AudioInputPort[] targetPorts;
        protected final AudioSyncGroup[] targetGroups;
        protected AsioChannel asioInputChannel;
        protected RawSampleBuffer sampleBuffer;

        public AsioSourceInfo(AsioAudioOutputPort sourcePort, int sourcePortIndex, AudioInputPort[] targetPorts, AudioSyncGroup[] targetGroups) {
            this.sourcePort = sourcePort;
            this.sourcePortIndex = sourcePortIndex;
            this.targetPorts = targetPorts;
            this.targetGroups = targetGroups;
        }
    }
}

