/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jasiohost;

import com.spacekiller.util.Clock;
import com.spacekiller.util.ThreadManager;
import com.waxmonster.audio.AudioInputPort;
import com.waxmonster.audio.AudioOutputPort;
import com.waxmonster.audio.AudioPort;
import com.waxmonster.audio.AudioSupport;
import com.waxmonster.audio.AudioSyncGroup;
import com.waxmonster.audio.impl.AudioEngineConfig;
import com.waxmonster.audio.jasiohost.AsioAudioDevice;
import com.waxmonster.audio.jasiohost.AsioAudioEngine;
import com.waxmonster.audio.jasiohost.AsioAudioInputPort;
import com.waxmonster.audio.jasiohost.AsioAudioOutputPort;
import com.waxmonster.audio.jasiohost.AsioAudioSyncGroup;
import com.waxmonster.studio.Studio;
import java.util.LinkedList;

public class AsioAudioSupport
extends AudioSupport {
    private final AsioAudioDevice asioDevice;
    private AudioEngineConfig config;
    private AsioAudioSyncGroup syncGroup;

    public AsioAudioSupport(AsioAudioDevice asioDevice, AudioEngineConfig config) {
        this.asioDevice = asioDevice;
        this.config = config;
    }

    public final AsioAudioDevice getAsioDevice() {
        return this.asioDevice;
    }

    public synchronized void reset() {
        if (this.syncGroup != null) {
            this.syncGroup = null;
        }
    }

    public synchronized AudioSyncGroup getAudioSyncGroup(AudioPort port) {
        return this.getAsioAudioSyncGroup();
    }

    public synchronized AsioAudioSyncGroup getAsioAudioSyncGroup() {
        if (this.syncGroup != null) {
            return this.syncGroup;
        }
        AsioAudioDevice audioDevice = this.asioDevice;
        if (audioDevice == null) {
            return null;
        }
        Studio studio = audioDevice.getStudio();
        if (studio == null) {
            return null;
        }
        String asioDriverName = audioDevice.getAsioDriverName();
        if (asioDriverName == null || asioDriverName.length() < 1) {
            return null;
        }
        double asioSampleRate = -1.0;
        AsioAudioDevice sourceDevice = audioDevice;
        AsioAudioDevice targetDevice = audioDevice;
        LinkedList<AsioAudioOutputPort> outputPortList = new LinkedList<AsioAudioOutputPort>();
        if (sourceDevice != null) {
            AudioPort[] ports;
            asioSampleRate = sourceDevice.getSampleRate();
            for (AudioPort p : ports = sourceDevice.getAudioPorts()) {
                if (p == null || !(p instanceof AsioAudioOutputPort)) continue;
                outputPortList.add((AsioAudioOutputPort)p);
            }
        }
        LinkedList<AsioAudioInputPort> inputPortList = new LinkedList<AsioAudioInputPort>();
        if (targetDevice != null) {
            AudioPort[] ports;
            if (asioSampleRate <= 0.0) {
                asioSampleRate = targetDevice.getSampleRate();
            }
            for (AudioPort p : ports = targetDevice.getAudioPorts()) {
                if (p == null || !(p instanceof AsioAudioInputPort)) continue;
                inputPortList.add((AsioAudioInputPort)p);
            }
        }
        AudioOutputPort[] outputPorts = outputPortList.toArray(new AudioOutputPort[outputPortList.size()]);
        AudioInputPort[] inputPorts = inputPortList.toArray(new AudioInputPort[inputPortList.size()]);
        Clock clock = studio.getClock();
        boolean async = audioDevice.isAsyncProcessing();
        ThreadManager threadManager = studio.getThreadManager();
        AsioAudioEngine engine = new AsioAudioEngine(asioDriverName, this.config, clock, async, threadManager);
        this.syncGroup = new AsioAudioSyncGroup(asioDriverName, asioSampleRate, inputPorts, outputPorts, engine, this);
        return this.syncGroup;
    }
}

