/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jasiohost;

import com.spacekiller.util.Clock;
import com.synthbot.jasiohost.AsioChannel;
import com.synthbot.jasiohost.AsioDriver;
import com.waxmonster.audio.AudioProcessor;
import com.waxmonster.audio.jasiohost.AsioAudioDriverHandler;
import com.waxmonster.audio.jasiohost.AsioAudioEngine;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugAsioAudioDriverHandler
extends AsioAudioDriverHandler {
    private static final Logger logger = Logger.getLogger(DebugAsioAudioDriverHandler.class.getName());
    private final String name;
    private final int bufSize;
    private volatile long expectedPos;
    private volatile int underruns;

    public DebugAsioAudioDriverHandler(AsioAudioEngine engine, AsioDriver driver, int bufSize, float frameRate, Clock clock, AudioProcessor[] processors) throws Exception {
        super(engine, driver, bufSize, frameRate, clock, processors);
        this.name = driver.getName();
        this.bufSize = bufSize;
    }

    @Override
    public void bufferSizeChanged(int bufferSize) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("bufferSizeChanged[" + this.name + "]: " + bufferSize);
        }
        super.bufferSizeChanged(bufferSize);
    }

    @Override
    public void bufferSwitch(long sampleTime, long samplePosition, Set<AsioChannel> activeChannels) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("bufferSwitch[" + this.name + "]: sampleTime=" + sampleTime + ", samplePosition=" + samplePosition + ", expectedPosition=" + this.expectedPos + ", underruns=" + this.underruns);
        }
        if (samplePosition != this.expectedPos) {
            ++this.underruns;
        }
        super.bufferSwitch(sampleTime, samplePosition, activeChannels);
        this.expectedPos = samplePosition + (long)this.bufSize;
    }

    @Override
    public void latenciesChanged(int inputLatency, int outputLatency) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("latenciesChanged[" + this.name + "]: inputLatency=" + inputLatency + ", outputLatency=" + outputLatency);
        }
        super.latenciesChanged(inputLatency, outputLatency);
    }

    @Override
    public void resetRequest() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("resetRequest[" + this.name + "]");
        }
        super.resetRequest();
    }

    @Override
    public void resyncRequest() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("resyncRequest[" + this.name + "]");
        }
        super.resyncRequest();
    }

    @Override
    public void sampleRateDidChange(double sampleRate) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("sampleRateDidChange[" + this.name + "]: " + sampleRate);
        }
        super.sampleRateDidChange(sampleRate);
    }

    public int getUnderruns() {
        return this.underruns;
    }

    public void resetUnderruns() {
        this.underruns = 0;
    }
}

