/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jasiohost;

import com.spacekiller.util.ThreadManager;
import com.waxmonster.audio.AudioException;
import com.waxmonster.audio.AudioProcessor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JAsioAsync
implements AudioProcessor,
Runnable {
    private static final Logger logger = Logger.getLogger(JAsioAsync.class.getName());
    private final AudioProcessor[] ap;
    private final int np;
    private final Thread thread;
    private final ThreadManager threadManager;
    private volatile long t;
    private volatile int f;
    private volatile boolean done;
    private volatile boolean active;

    public JAsioAsync(AudioProcessor[] procs, ThreadManager threadManager, int threadPrio, String threadName) {
        this.ap = procs;
        this.np = procs.length;
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.setPriority(threadPrio);
        this.threadManager = threadManager;
    }

    public synchronized void start() throws AudioException {
        if (this.thread.isAlive()) {
            throw new AudioException("Async audio processing thread is already running: " + this.thread);
        }
        this.done = true;
        this.active = true;
        this.thread.start();
    }

    public void process(long time, int frames) throws AudioException {
        this.t = time;
        this.f = frames;
        this.done = false;
        while (!this.done) {
        }
    }

    public synchronized void shutdown() throws AudioException {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.done = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JAsioAsync thread started: " + this.thread);
        }
        try {
            int i;
            if (this.threadManager != null) {
                this.threadManager.registerThread(Thread.currentThread());
            }
            block10: while (true) {
                if (this.done && this.active) {
                    continue;
                }
                if (!this.active) break;
                long time = this.t;
                int frames = this.f;
                try {
                    i = 0;
                    while (true) {
                        if (i >= this.np) continue block10;
                        this.ap[i++].process(time, frames);
                    }
                }
                finally {
                    this.done = true;
                    continue;
                }
                break;
            }
            for (i = 0; i < this.np; ++i) {
                try {
                    this.ap[i].shutdown();
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            this.done = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JAsioAsync thread stopped: " + this.thread);
            }
            if (this.threadManager != null) {
                this.threadManager.unregisterThread(Thread.currentThread());
            }
        }
    }
}

