/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.audio.jasiohost;

import com.spacekiller.util.Data;
import com.spacekiller.util.media.control.AbstractAudioFormatControl;
import com.synthbot.jasiohost.AsioChannel;
import com.synthbot.jasiohost.AsioDriver;
import com.synthbot.jasiohost.AsioSampleType;
import com.waxmonster.audio.jasiohost.AsioAudioDriverInfo;
import com.waxmonster.audio.jasiohost.AsioAudioPortInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JAsioDriverManager {
    private static final Logger logger = Logger.getLogger(JAsioDriverManager.class.getName());
    private static JAsioDriverManager INSTANCE;
    private List<String> driverNames;
    private Map<String, AsioAudioDriverInfo> driverInfoMap = new HashMap<String, AsioAudioDriverInfo>();
    private String loadedDriverName;
    private AsioDriver loadedDriver;
    private int loadedDriverUsage;

    protected JAsioDriverManager() {
        Thread hook = new Thread((Runnable)new AsioShutdown(), "ASIO-ShutdownHook");
        Runtime.getRuntime().addShutdownHook(hook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JAsioDriverManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<JAsioDriverManager> clazz = JAsioDriverManager.class;
        synchronized (JAsioDriverManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = JAsioDriverManager.createInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static JAsioDriverManager createInstance() {
        return new JAsioDriverManager();
    }

    public synchronized String[] getAsioDriverNames() {
        if (this.driverNames == null) {
            this.driverNames = AsioDriver.getDriverNames();
        }
        return this.driverNames.toArray(new String[this.driverNames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AsioAudioDriverInfo getAsioDriverInfo(String driverName) {
        AsioAudioDriverInfo info = this.driverInfoMap.get(driverName);
        if (info != null) {
            return info;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Opening ASIO driver to enumerate audio channels: driverName=" + driverName);
        }
        AsioDriver driver = this.openAsioDriver(driverName);
        try {
            int driverVersion = driver.getVersion();
            int asioVersion = driver.getAsioVersion();
            double defaultSampleRate = driver.getSampleRate();
            double[] supportedSampleRates = this.enumerateSupportedSampleRates(driver);
            ArrayList<AsioAudioPortInfo> inputChannelList = new ArrayList<AsioAudioPortInfo>();
            int inputChannelCount = driver.getNumChannelsInput();
            for (int i = 0; i < inputChannelCount; ++i) {
                AsioChannel channel = driver.getChannelInput(i);
                String channelName = channel.getChannelName();
                AsioSampleType sampleType = channel.getSampleType();
                inputChannelList.add(new AsioAudioPortInfo(i, channelName, sampleType));
            }
            ArrayList<AsioAudioPortInfo> outputChannelList = new ArrayList<AsioAudioPortInfo>();
            int outputChannelCount = driver.getNumChannelsOutput();
            for (int i = 0; i < outputChannelCount; ++i) {
                AsioChannel channel = driver.getChannelOutput(i);
                String channelName = channel.getChannelName();
                AsioSampleType sampleType = channel.getSampleType();
                outputChannelList.add(new AsioAudioPortInfo(i, channelName, sampleType));
            }
            info = new AsioAudioDriverInfo(driverName);
            info.setDriverVersion(String.valueOf(driverVersion));
            info.setAsioVersion(String.valueOf(asioVersion));
            info.setDefaultSampleRate(defaultSampleRate);
            info.setSupportedSampleRates(supportedSampleRates);
            info.setInputChannelList(inputChannelList);
            info.setOutputChannelList(outputChannelList);
            this.driverInfoMap.put(driverName, info);
            AsioAudioDriverInfo asioAudioDriverInfo = info;
            return asioAudioDriverInfo;
        }
        finally {
            this.closeAsioDriver(driver);
        }
    }

    public synchronized void refreshAsioDrivers() {
        if (this.loadedDriverName != null) {
            throw new IllegalStateException("An ASIO driver is already loaded: " + this.loadedDriverName);
        }
        this.driverNames = null;
        this.driverInfoMap.clear();
    }

    protected double[] enumerateSupportedSampleRates(AsioDriver driver) {
        TreeSet<Double> rates = new TreeSet<Double>();
        rates.add(Data.toDouble((double)driver.getSampleRate()));
        float[] commonRates = AbstractAudioFormatControl.getCommonAudioFrameRates();
        for (int i = 0; i < commonRates.length; ++i) {
            double rate = commonRates[i];
            if (!driver.canSampleRate(rate)) continue;
            rates.add(Data.toDouble((double)rate));
        }
        Double[] arr = rates.toArray(new Double[rates.size()]);
        int num = arr.length;
        double[] rc = new double[num];
        for (int i = 0; i < num; ++i) {
            rc[i] = arr[i];
        }
        return rc;
    }

    public synchronized AsioDriver openAsioDriver(String driverName) {
        AsioDriver driver;
        if (this.loadedDriverName != null) {
            if (this.loadedDriverName.equals(driverName)) {
                ++this.loadedDriverUsage;
                return this.loadedDriver;
            }
            throw new IllegalStateException("Another ASIO driver is already loaded: " + this.loadedDriverName);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loading ASIO driver: " + driverName);
        }
        if ((driver = AsioDriver.getDriver((String)driverName)) != null) {
            this.loadedDriver = driver;
            this.loadedDriverName = driverName;
            this.loadedDriverUsage = 1;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Loaded ASIO driver: " + driverName + " => " + driver);
        }
        return driver;
    }

    public synchronized void closeAsioDriver(AsioDriver driver) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("closeAsioDriver: " + driver);
        }
        if (this.loadedDriver == driver) {
            if (--this.loadedDriverUsage > 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("ASIO driver is still being used: " + driver + " (usage=" + this.loadedDriverUsage + ")");
                }
                return;
            }
            this.loadedDriverName = null;
            this.loadedDriver = null;
            this.loadedDriverUsage = 0;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Closing ASIO driver: " + driver);
        }
        driver.shutdownAndUnloadDriver();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Closed ASIO driver: " + driver);
        }
    }

    public synchronized void closeAllAsioDrivers() {
        AsioDriver driver;
        if (this.loadedDriver != null) {
            this.closeAsioDriver(this.loadedDriver);
        }
        if ((driver = AsioDriver.getCurrentDriver()) != null) {
            this.closeAsioDriver(driver);
        }
    }

    final synchronized void shutdown() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(JAsioDriverManager.class.getName(), "shutdown");
        }
        this.closeAllAsioDrivers();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(JAsioDriverManager.class.getName(), "shutdown");
        }
    }

    protected class AsioShutdown
    implements Runnable {
        protected AsioShutdown() {
        }

        @Override
        public void run() {
            JAsioDriverManager.this.shutdown();
        }
    }
}

