/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member;

import com.spacekiller.util.member.Group;
import com.spacekiller.util.member.Member;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractMember
implements Member {
    private int id;
    private String name = "";
    private String description = "";
    private long createdMillis = System.currentTimeMillis();
    private Set groups = new HashSet();

    public AbstractMember(int id) {
        this.setId(id);
    }

    @Override
    public long getCreatedMillis() {
        return this.createdMillis;
    }

    protected void setCreatedMillis(long createdMillis) {
        this.createdMillis = createdMillis;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected Iterator getGroups() {
        return this.groups.iterator();
    }

    void addGroup(Group g) {
        if (g != null) {
            this.groups.add(g);
        }
    }

    void removeGroup(Group g) {
        if (g != null) {
            this.groups.remove(g);
        }
    }

    protected boolean inGroup(Group g) {
        return this.groups.contains(g);
    }

    protected int getId() {
        return this.id;
    }

    private void setId(int id) {
        this.id = id;
    }

    public String toString() {
        return super.toString() + "[" + this.name + "]";
    }
}

