/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member.jaas;

import com.spacekiller.util.member.DefaultGroup;
import com.spacekiller.util.member.DefaultUser;
import com.spacekiller.util.member.Group;
import com.spacekiller.util.member.Member;
import com.spacekiller.util.member.User;
import com.spacekiller.util.member.UserRegistry;
import com.spacekiller.util.member.jaas.JaasCallbackHandler;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class JaasUserRegistry
implements UserRegistry {
    public static final String PROPERTY_JAAS_NAME = "jaas.name";
    private String jaasName = null;
    private int nextId = 1;
    private Map users = new HashMap();
    private Map groups = new HashMap();
    private Map groupMembers = new HashMap();
    private Map userGroups = new HashMap();
    private static final Logger logger = Logger.getLogger(JaasUserRegistry.class.getName());

    public static void main(String[] args) {
        try {
            String propKey = "java.security.auth.login.config";
            String configPath = "/jaas-test.config";
            System.setProperty(propKey, configPath);
            JaasUserRegistry reg = new JaasUserRegistry();
            Properties props = new Properties();
            props.put(PROPERTY_JAAS_NAME, "TestNT");
            reg.initialize(props);
            Properties cred = new Properties();
            cred.setProperty("user", "test");
            cred.setProperty("pass", "passwd");
            User user = reg.authenticate(cred);
            logger.fine("User: " + user);
            Group[] userGroups = reg.getGroupsFor(user, true);
            logger.fine("Member of groups: " + userGroups.length);
            for (int i = 0; i < userGroups.length; ++i) {
                logger.fine(" - " + userGroups[i]);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public synchronized void initialize(Properties config) throws Exception {
        if (this.jaasName != null) {
            throw new Exception("JaasUserRegistry already initialized");
        }
        this.jaasName = config.getProperty(PROPERTY_JAAS_NAME);
        if (this.jaasName == null) {
            throw new Exception("Missing config entry: jaas.name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User authenticate(Properties credentials) throws Exception {
        String username = credentials.getProperty("user");
        String pass = credentials.getProperty("pass");
        JaasCallbackHandler callbackHandler = new JaasCallbackHandler(username, pass.toCharArray());
        try {
            LoginContext context = new LoginContext(this.jaasName, callbackHandler);
            context.login();
            Subject subject = context.getSubject();
            if (subject == null) {
                User user = null;
                return user;
            }
            Set<Principal> principals = subject.getPrincipals();
            Principal userPrincipal = null;
            ArrayList<Principal> groupPrincipals = new ArrayList<Principal>();
            for (Principal p : principals) {
                logger.fine("Principal: " + p.getName() + " = " + p.getClass() + " => " + p);
                if (p instanceof Group) {
                    groupPrincipals.add(p);
                    continue;
                }
                if (userPrincipal == null) {
                    userPrincipal = p;
                    continue;
                }
                groupPrincipals.add(p);
            }
            User user = this.createUser(userPrincipal);
            String uname = user.getName();
            this.users.put(uname, user);
            ArrayList<Group> groupList = new ArrayList<Group>();
            for (Principal groupPrincipal : groupPrincipals) {
                String gname = groupPrincipal.getName();
                Group group = this.createGroup(groupPrincipal);
                this.groups.put(gname, group);
                groupList.add(group);
                ArrayList<User> userList = (ArrayList<User>)this.groupMembers.get(gname);
                if (userList == null) {
                    userList = new ArrayList<User>();
                    this.groupMembers.put(gname, userList);
                }
                userList.add(user);
            }
            this.userGroups.put(uname, groupList);
            User user2 = user;
            return user2;
        }
        finally {
            callbackHandler.clear();
        }
    }

    protected final synchronized int nextId() {
        return this.nextId++;
    }

    protected User createUser(Principal p) {
        String userName = p.getName();
        DefaultUser user = new DefaultUser(this.nextId(), userName);
        return user;
    }

    protected Group createGroup(Principal p) {
        String groupName = p.getName();
        DefaultGroup group = new DefaultGroup(this.nextId(), groupName);
        return group;
    }

    @Override
    public Member getMember(String name) throws Exception {
        User user = this.getUser(name);
        if (user != null) {
            return user;
        }
        return this.getGroup(name);
    }

    @Override
    public User getUser(String name) throws Exception {
        return (User)this.users.get(name);
    }

    @Override
    public Group getGroup(String name) throws Exception {
        return (Group)this.groups.get(name);
    }

    @Override
    public boolean isMember(Member member) throws Exception {
        String name = member.getName();
        Member m = this.getMember(name);
        return member == m;
    }

    @Override
    public boolean isGroupMember(Group group, Member member) throws Exception {
        String gname = group.getName();
        Group g = this.getGroup(gname);
        if (g != group) {
            return false;
        }
        List userList = (List)this.groupMembers.get(gname);
        if (userList == null) {
            return false;
        }
        return userList.contains(member);
    }

    @Override
    public Group[] getGroupsFor(Member member, boolean recursive) throws Exception {
        String uname = member.getName();
        User u = this.getUser(uname);
        if (u != member) {
            return new Group[0];
        }
        List groupList = (List)this.userGroups.get(uname);
        if (groupList == null) {
            return new Group[0];
        }
        Group[] rc = groupList.toArray(new Group[groupList.size()]);
        return rc;
    }

    @Override
    public Member[] getGroupMembers(Group group, boolean recursive) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected final String getJaasName() {
        return this.jaasName;
    }
}

