/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.member.was;

import com.spacekiller.util.member.AbstractMember;
import com.spacekiller.util.member.DefaultGroup;
import com.spacekiller.util.member.DefaultUser;
import com.spacekiller.util.member.Group;
import com.spacekiller.util.member.Member;
import com.spacekiller.util.member.User;
import com.spacekiller.util.member.UserRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Was5UserRegistry
implements UserRegistry {
    public static final String WAS_NT_USER_REGISTRY_CLASS = "com.ibm.ws.security.registry.nt.NTRegistryImpl";
    public static final String WAS_UNIX_USER_REGISTRY_CLASS = "com.ibm.ws.security.registry.unix.UnixRegistryImpl";
    private boolean initialized = false;
    private Object wasUserRegistry;
    private Class wasUserRegistryClass;
    private Method methodCheckPassword;
    private Method methodGetGroupsForUser;
    private static final Logger logger = Logger.getLogger(Was5UserRegistry.class.getName());

    protected Was5UserRegistry() {
    }

    public Was5UserRegistry(Object userRegistry) {
        this();
        this.initialize(userRegistry);
    }

    @Override
    public User authenticate(Properties credentials) throws Exception {
        if (this.methodCheckPassword == null) {
            this.methodCheckPassword = this.wasUserRegistryClass.getDeclaredMethod("checkPassword", String.class, String.class);
        }
        String user = credentials.getProperty("user");
        String pass = credentials.getProperty("pass");
        logger.fine("checking password for user: " + user);
        String fullName = null;
        try {
            fullName = (String)this.methodCheckPassword.invoke(this.wasUserRegistry, user, pass);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            logger.log(Level.SEVERE, cause.getMessage(), cause);
            throw new SecurityException("" + e);
        }
        if (fullName == null || fullName.length() < 1) {
            throw new Exception("Authentication failed: rc=" + fullName);
        }
        logger.fine("User authenticated successfully: " + user + " = " + fullName);
        int uid = 0;
        WasUser obj = new WasUser(uid, user);
        obj.setEmail(null);
        obj.setRevoked(false);
        return obj;
    }

    @Override
    public Group[] getGroupsFor(Member member, boolean recursive) throws Exception {
        String[] groupNames;
        if (this.methodGetGroupsForUser == null) {
            this.methodGetGroupsForUser = this.wasUserRegistryClass.getDeclaredMethod("getGroupsForUser", String.class);
        }
        String userName = member.getName();
        try {
            groupNames = (String[])this.methodGetGroupsForUser.invoke(this.wasUserRegistry, userName);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            logger.log(Level.SEVERE, cause.getMessage(), cause);
            throw new SecurityException("" + e);
        }
        int num = groupNames.length;
        Group[] groups = new Group[num];
        for (int c = 0; c < groups.length; ++c) {
            int id = 0;
            String name = this.getGroupName(groupNames[c]);
            WasGroup wasGroup = new WasGroup(id, name);
            wasGroup.addMember((AbstractMember)member);
            groups[c] = wasGroup;
        }
        return groups;
    }

    @Override
    public Member getMember(String name) throws Exception {
        throw new UnsupportedOperationException("TODO get member: " + name);
    }

    @Override
    public User getUser(String name) throws Exception {
        return (User)this.getMember(name);
    }

    @Override
    public Group getGroup(String name) throws Exception {
        return (Group)this.getMember(name);
    }

    @Override
    public boolean isMember(Member member) throws Exception {
        throw new UnsupportedOperationException("TODO check exists: " + member);
    }

    @Override
    public Member[] getGroupMembers(Group group, boolean recursive) throws Exception {
        throw new UnsupportedOperationException("TODO");
    }

    protected String getGroupName(String group) throws Exception {
        int len = group.length();
        int x = group.indexOf(47);
        if (x >= 0 && x + 1 < len) {
            return group.substring(x + 1);
        }
        x = group.indexOf(92);
        if (x >= 0 && x + 1 < len) {
            return group.substring(x + 1);
        }
        return group;
    }

    @Override
    public void initialize(Properties config) throws Exception {
    }

    protected synchronized void initialize(Object wasUserRegistry) {
        if (this.initialized) {
            throw new RuntimeException("User registry already initialized: " + this);
        }
        this.wasUserRegistry = wasUserRegistry;
        this.wasUserRegistryClass = wasUserRegistry.getClass();
        this.initialized = true;
    }

    @Override
    public boolean isGroupMember(Group group, Member member) throws Exception {
        String groupName = group.getName();
        Group[] groups = this.getGroupsFor(member, true);
        for (int c = 0; c < groups.length; ++c) {
            if (!groups[c].getName().equals(groupName)) continue;
            return true;
        }
        return false;
    }

    protected class WasGroup
    extends DefaultGroup {
        public WasGroup(int id, String name) {
            super(id, name);
        }

        @Override
        protected void addMember(AbstractMember m) {
            super.addMember(m);
        }

        @Override
        protected Iterator getMembers() {
            return super.getMembers();
        }

        @Override
        protected boolean isMember(Member m) {
            return super.isMember(m);
        }

        @Override
        protected void removeMember(AbstractMember m) {
            super.removeMember(m);
        }

        @Override
        protected void setCreatedMillis(long createdMillis) {
            super.setCreatedMillis(createdMillis);
        }

        @Override
        protected void setDescription(String description) {
            super.setDescription(description);
        }

        @Override
        protected void setName(String name) {
            super.setName(name);
        }
    }

    protected class WasUser
    extends DefaultUser {
        public WasUser(int id, String name) {
            super(id, name);
        }

        @Override
        protected void setEmail(String email) {
            super.setEmail(email);
        }

        @Override
        protected void setRevoked(boolean revoked) {
            super.setRevoked(revoked);
        }
    }
}

