/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.studio;

import com.spacekiller.util.media.control.Control;
import com.waxmonster.studio.Connection;
import com.waxmonster.studio.DeviceProvider;
import com.waxmonster.studio.Port;
import com.waxmonster.studio.PortType;
import com.waxmonster.studio.Preset;
import com.waxmonster.studio.Studio;
import com.waxmonster.studio.StudioException;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;

public abstract class Device {
    private static final Logger logger = Logger.getLogger(Device.class.getName());
    private final DeviceProvider provider;
    private String id;
    private String name;
    private Studio studio;
    private Properties properties;
    private List controlList;
    private Map controlMap;
    private List ports;
    private List conns;
    private List missingPorts;
    private List invalidConns;
    private List errors;
    private String presetName;
    private volatile boolean enabled;
    private volatile boolean active;
    private String title;
    private String subtitle;
    private String tooltip;
    private Object preferredLayoutConstraint = "Center";
    private Icon iconColor16;
    private Point position;

    public Device(DeviceProvider provider, String name) {
        this.provider = provider;
        this.name = name;
        this.controlList = new ArrayList();
        this.controlMap = new HashMap();
        this.ports = new LinkedList();
        this.conns = new LinkedList();
        this.missingPorts = new LinkedList();
        this.invalidConns = new LinkedList();
        this.errors = new LinkedList();
        this.enabled = true;
        this.active = false;
    }

    public final DeviceProvider getProvider() {
        return this.provider;
    }

    final String getId() {
        return this.id;
    }

    final void setId(String id) {
        this.id = id;
    }

    public final String getName() {
        return this.name;
    }

    final synchronized void setName(String name) {
        if (this.name == name) {
            return;
        }
        this.name = name;
        Studio s = this.studio;
        if (s != null) {
            s.deviceRenamed(this, name);
        }
    }

    public final Studio getStudio() {
        return this.studio;
    }

    final synchronized void setStudio(Studio studio) {
        if (this.studio == studio) {
            return;
        }
        this.studio = studio;
        this.studioChanged(studio);
    }

    protected void studioChanged(Studio studio) {
    }

    protected void validate() {
    }

    public final synchronized Port[] getPorts() {
        return this.ports.toArray(new Port[this.ports.size()]);
    }

    protected synchronized void addPort(Port port) throws StudioException {
        this.insertPortAt(port, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void insertPortAt(Port port, int index) throws StudioException {
        if (index < 0 || index > this.ports.size()) {
            index = this.ports.size();
        }
        Port port2 = port;
        synchronized (port2) {
            Device device = port.getDevice();
            if (device == this) {
                return;
            }
            if (device != null) {
                throw new StudioException("Port is already installed: port=" + port + ", device=" + device);
            }
            port.setDevice(this);
        }
        this.ports.add(index, port);
        Studio s = this.studio;
        if (s != null) {
            s.portAdded(port, this);
        }
    }

    protected synchronized int getPortIndex(Port port) {
        return this.ports.indexOf(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean removePort(Port port) throws StudioException {
        if (!this.ports.remove(port)) {
            return false;
        }
        Port port2 = port;
        synchronized (port2) {
            if (port.getDevice() == this) {
                port.setDevice(null);
            }
        }
        Studio s = this.studio;
        if (s != null) {
            s.portRemoved(port, this);
        }
        return true;
    }

    protected synchronized boolean renamePort(Port port, String newName) throws StudioException {
        if (port == null) {
            return false;
        }
        if (newName == null || newName.length() < 1) {
            return false;
        }
        if (!this.ports.contains(port)) {
            return false;
        }
        if (newName.equals(port.getName())) {
            return true;
        }
        port.setName(newName);
        Studio s = this.studio;
        if (s != null) {
            s.portRenamed(port, this);
        }
        return true;
    }

    public final synchronized Connection[] getConnections() {
        return this.conns.toArray(new Connection[this.conns.size()]);
    }

    final synchronized void addConnection(Connection conn) {
        this.conns.add(conn);
    }

    final synchronized void removeConnection(Connection conn) {
        this.conns.remove(conn);
    }

    public final synchronized LogRecord[] getErrors() {
        return this.errors.toArray(new LogRecord[this.errors.size()]);
    }

    public final synchronized int getErrorCount() {
        return this.errors.size();
    }

    final synchronized void addErrorInternal(LogRecord record) {
        this.errors.add(record);
    }

    final synchronized void removeErrorInternal(LogRecord record) {
        this.errors.remove(record);
    }

    final synchronized void clearErrors() {
        this.errors.clear();
    }

    protected LogRecord addError(Throwable error) {
        if (error == null) {
            return null;
        }
        LogRecord record = new LogRecord(Level.SEVERE, error.getMessage());
        record.setThrown(error);
        this.addError(record);
        return record;
    }

    protected void addError(LogRecord record) {
        if (record == null) {
            return;
        }
        Studio s = this.studio;
        if (s != null) {
            s.errorReported(this, record);
        } else {
            this.addErrorInternal(record);
        }
    }

    protected void removeError(LogRecord record) {
        if (record == null) {
            return;
        }
        Studio s = this.studio;
        if (s != null) {
            s.errorResolved(this, record);
        } else {
            this.removeErrorInternal(record);
        }
    }

    public final synchronized boolean isMissingPort(Port port) {
        return this.missingPorts.contains(port);
    }

    public final synchronized Port[] getMissingPorts() {
        return this.missingPorts.toArray(new Port[this.missingPorts.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void addMissingPort(Port port) throws StudioException {
        Port port2 = port;
        synchronized (port2) {
            Device device = port.getDevice();
            if (device == this) {
                return;
            }
            if (device != null) {
                throw new StudioException("Port is already installed: port=" + port + ", device=" + device);
            }
            port.setDevice(this);
        }
        this.missingPorts.add(port);
        Studio s = this.studio;
        if (s != null) {
            s.portAdded(port, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void removeMissingPort(Port port) throws StudioException {
        if (!this.missingPorts.remove(port)) {
            return;
        }
        Port port2 = port;
        synchronized (port2) {
            if (port.getDevice() != this) {
                return;
            }
            port.setDevice(null);
        }
        Studio s = this.studio;
        if (s != null) {
            s.portRemoved(port, this);
        }
    }

    protected final synchronized void cleanupMissingPorts() throws StudioException {
        if (this.missingPorts.isEmpty()) {
            return;
        }
        Connection[] ics = this.getInvalidConnections();
        Port[] missingPorts = this.getMissingPorts();
        for (int i = 0; i < missingPorts.length; ++i) {
            Port missingPort = missingPorts[i];
            if (missingPort.isConnected()) continue;
            boolean connected = false;
            for (int k = 0; k < ics.length; ++k) {
                Connection ic = ics[k];
                if (ic.getSource() == missingPort) {
                    connected = true;
                    break;
                }
                if (ic.getTarget() != missingPort) continue;
                connected = true;
                break;
            }
            if (connected) continue;
            this.removeMissingPort(missingPort);
        }
    }

    public final synchronized Connection[] getInvalidConnections() {
        return this.invalidConns.toArray(new Connection[this.invalidConns.size()]);
    }

    final synchronized void addInvalidConnection(Connection conn) throws StudioException {
        if (conn == null) {
            return;
        }
        this.invalidConns.add(conn);
    }

    final synchronized void removeInvalidConnection(Connection conn) throws StudioException {
        this.invalidConns.remove(conn);
    }

    public Object getPreferredLayoutConstraint() {
        return this.preferredLayoutConstraint;
    }

    protected void setPreferredLayoutConstraint(Object preferredLayoutConstraint) {
        this.preferredLayoutConstraint = preferredLayoutConstraint;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    protected void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public Icon getIcon(int iconKind) {
        return this.iconColor16;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    final synchronized void setEnabled(boolean enabled) throws StudioException {
        Studio s;
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (!enabled && this.active) {
            this.setActive(false);
        }
        if ((s = this.studio) != null) {
            if (enabled) {
                s.deviceEnabled(this);
            } else {
                s.deviceDisabled(this);
            }
        }
    }

    public final boolean isActive() {
        return this.active;
    }

    final synchronized void setActive(boolean active) throws StudioException {
        if (this.active == active) {
            return;
        }
        if (active) {
            if (!this.enabled) {
                throw new StudioException("Device is not enabled: " + this);
            }
            this.activate();
        } else {
            this.deactivate();
        }
        this.active = active;
    }

    protected abstract void activate() throws StudioException;

    protected abstract void deactivate() throws StudioException;

    public Component getCustomizer() {
        return null;
    }

    public final Point getPosition() {
        Point p = this.position;
        return p == null ? null : new Point(p);
    }

    final void setPosition(Point position) {
        this.position = position;
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String title) {
        if (title == null ? this.title == null : title.equals(this.title)) {
            return;
        }
        this.title = title;
        Studio s = this.studio;
        if (s != null) {
            s.deviceTitleChanged(this, title);
        }
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    protected void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    protected Icon getIconColor16() {
        return this.iconColor16;
    }

    protected void setIconColor16(Icon iconColor16) {
        this.iconColor16 = iconColor16;
    }

    protected final synchronized void replacePortsByName(Port[] oldPorts, Port[] newPorts) throws StudioException {
        int i;
        String portName;
        Port port;
        int i2;
        Studio studio = this.getStudio();
        int oldCount = oldPorts.length;
        int newCount = newPorts.length;
        HashSet<Port> oldPortSet = new HashSet<Port>();
        for (int i3 = 0; i3 < oldCount; ++i3) {
            Port port2 = oldPorts[i3];
            if (port2 == null) continue;
            oldPortSet.add(port2);
        }
        HashMap<String, Port> portMap = new HashMap<String, Port>();
        Port[] oldValidPorts = this.getPorts();
        for (i2 = 0; i2 < oldValidPorts.length; ++i2) {
            port = oldValidPorts[i2];
            if (oldPortSet.contains(port) || (portName = port.getName()) == null || portMap.containsKey(portName)) continue;
            portMap.put(portName, port);
        }
        for (i2 = 0; i2 < newCount; ++i2) {
            port = newPorts[i2];
            if (port == null || (portName = port.getName()) == null || portMap.containsKey(portName)) continue;
            portMap.put(portName, port);
        }
        Port[] oldMissingPorts = this.getMissingPorts();
        for (int i4 = 0; i4 < oldMissingPorts.length; ++i4) {
            String portName2;
            Port port3 = oldMissingPorts[i4];
            if (port3 == null || (portName2 = port3.getName()) == null || portMap.containsKey(portName2)) continue;
            portMap.put(portName2, port3);
        }
        HashMap connMap = new HashMap(oldCount * 2);
        LinkedList<Port> missingNewPorts = null;
        if (studio != null) {
            Port newPort;
            String portName3;
            List<Connection> list;
            Port port4;
            Port target;
            Port source;
            Connection conn;
            int i5;
            Connection[] oldConns = this.getConnections();
            for (i5 = 0; i5 < oldConns.length; ++i5) {
                conn = oldConns[i5];
                source = conn.getSource();
                target = conn.getTarget();
                port4 = null;
                if (source != null && source.getDevice() == this) {
                    port4 = source;
                } else if (target != null && target.getDevice() == this) {
                    port4 = target;
                }
                if (port4 == null || !oldPortSet.contains(port4)) continue;
                list = (LinkedList<Connection>)connMap.get(port4);
                if (list == null) {
                    list = new LinkedList<Connection>();
                    connMap.put(port4, list);
                }
                list.add(conn);
                studio.disconnect(conn);
                portName3 = port4.getName();
                if (portName3 == null || (newPort = (Port)portMap.get(portName3)) != null) continue;
                if (missingNewPorts == null) {
                    missingNewPorts = new LinkedList<Port>();
                }
                if (missingNewPorts.contains(port4)) continue;
                missingNewPorts.add(port4);
            }
            oldConns = this.getInvalidConnections();
            for (i5 = 0; i5 < oldConns.length; ++i5) {
                conn = oldConns[i5];
                source = conn.getSource();
                target = conn.getTarget();
                port4 = null;
                if (source != null && source.getDevice() == this) {
                    port4 = source;
                } else if (target != null && target.getDevice() == this) {
                    port4 = target;
                }
                if (port4 == null || !oldPortSet.contains(port4)) continue;
                list = (List)connMap.get(port4);
                if (list == null) {
                    list = new LinkedList();
                    connMap.put(port4, list);
                }
                list.add(conn);
                studio.removeInvalidConnection(conn);
                portName3 = port4.getName();
                if (portName3 == null || (newPort = (Port)portMap.get(portName3)) != null) continue;
                if (missingNewPorts == null) {
                    missingNewPorts = new LinkedList();
                }
                if (missingNewPorts.contains(port4)) continue;
                missingNewPorts.add(port4);
            }
        }
        for (i = 0; i < oldCount; ++i) {
            Port oldPort = oldPorts[i];
            if (oldPort == null) continue;
            this.removePort(oldPort);
        }
        for (i = 0; i < newCount; ++i) {
            Port newPort = newPorts[i];
            if (newPort == null) continue;
            this.addPort(newPort);
        }
        if (studio != null) {
            String portName4;
            Port oldPort2;
            if (missingNewPorts != null) {
                HashMap<Port, Port> missingPortMap = new HashMap<Port, Port>();
                for (Port oldPort2 : missingNewPorts) {
                    String portTypeTooltip;
                    PortType portType;
                    Port newPort;
                    String portId = oldPort2.getId();
                    portName4 = oldPort2.getName();
                    String portTitle = oldPort2.getTitle();
                    String portTooltip = "Missing port: " + portName4;
                    String portTypeName = null;
                    PortType oldPortType = oldPort2.getType();
                    if (oldPortType != null) {
                        portTypeName = oldPortType.getName();
                    }
                    String prefLayoutConstraint = null;
                    if (portTypeName != null) {
                        if (portTypeName.toLowerCase().indexOf("input") >= 0) {
                            prefLayoutConstraint = "West";
                        } else if (portTypeName.toLowerCase().indexOf("output") >= 0) {
                            prefLayoutConstraint = "East";
                        }
                    }
                    if ((newPort = studio.createMissingPort(this, portType = studio.createMissingPortType(portTypeName, portTypeTooltip = "Missing port type: " + portTypeName, prefLayoutConstraint), portName4, portTitle, portTooltip)) == null) continue;
                    newPort.setId(portId);
                    missingPortMap.put(oldPort2, newPort);
                    portMap.put(portName4, newPort);
                }
                for (int i6 = 0; i6 < oldCount; ++i6) {
                    Port newPort;
                    oldPort2 = oldPorts[i6];
                    if (oldPort2 == null || (newPort = (Port)missingPortMap.get(oldPort2)) == null) continue;
                    this.addMissingPort(newPort);
                }
            }
            for (Map.Entry entry : connMap.entrySet()) {
                Port newPort;
                oldPort2 = (Port)entry.getKey();
                List list = (List)entry.getValue();
                if (list.isEmpty() || (newPort = (Port)portMap.get(portName4 = oldPort2.getName())) == null) continue;
                for (Connection conn : list) {
                    Port source = conn.getSource();
                    Port target = conn.getTarget();
                    if (source == oldPort2) {
                        source = newPort;
                    } else {
                        if (target != oldPort2) continue;
                        target = newPort;
                    }
                    Connection newConn = null;
                    if (studio.isConnectable(source, target)) {
                        try {
                            newConn = studio.connect(source, target);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    if (newConn != null) continue;
                    try {
                        studio.addInvalidConnection(source, target);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
        if (studio != null) {
            try {
                studio.resolveInvalidConnections(this);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected int parseIntProperty(String key, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid property: key=" + key + ", value=" + value);
        }
    }

    protected float parseFloatProperty(String key, String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid property: key=" + key + ", value=" + value);
        }
    }

    protected double parseDoubleProperty(String key, String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid property: key=" + key + ", value=" + value);
        }
    }

    public synchronized Properties getProperties() {
        Properties props = new Properties();
        if (this.properties != null) {
            props.putAll((Map<?, ?>)this.properties);
        }
        return props;
    }

    public synchronized String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(key);
    }

    public synchronized void setProperties(Properties newProperties) {
        Properties oldProperties = this.properties;
        this.properties = new Properties();
        if (newProperties != null) {
            this.properties.putAll((Map<?, ?>)newProperties);
        }
        for (Map.Entry<Object, Object> me : newProperties.entrySet()) {
            String string = (String)me.getKey();
            String value = (String)me.getValue();
            this.applyProperty(string, value);
            if (oldProperties == null) continue;
            oldProperties.remove(string);
        }
        if (oldProperties != null) {
            for (String string : oldProperties.keySet()) {
                this.applyProperty(string, null);
            }
        }
    }

    public synchronized void setProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.setProperty(key, value);
        }
        this.applyProperty(key, value);
    }

    protected abstract void applyProperty(String var1, String var2);

    public synchronized Control getControl(String name) {
        return (Control)this.controlMap.get(name);
    }

    public synchronized int getControlCount() {
        return this.controlList.size();
    }

    public synchronized Control getControlAt(int index) {
        return (Control)this.controlList.get(index);
    }

    public synchronized int getControlIndex(Control control) {
        return this.controlList.indexOf(control);
    }

    public synchronized Control[] getControls() {
        return this.controlList.toArray(new Control[this.controlList.size()]);
    }

    protected synchronized void addControl(Control control) {
        this.insertControlAt(control, this.controlList.size());
    }

    protected synchronized void insertControlAt(Control control, int index) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        this.controlList.add(index, control);
        this.controlMap.put(control.getName(), control);
        Studio s = this.studio;
        if (s != null) {
            s.controlAdded(control, index, this);
        }
    }

    protected synchronized boolean removeControl(Control control) {
        int index = this.controlList.indexOf(control);
        if (index < 0) {
            return false;
        }
        this.removeControlAt(index);
        return true;
    }

    protected synchronized void removeControlAt(int index) {
        Control control = (Control)this.controlList.remove(index);
        if (control != null) {
            Studio s;
            String name = control.getName();
            if (this.controlMap.get(name) == control) {
                this.controlMap.remove(name);
            }
            if ((s = this.studio) != null) {
                s.controlRemoved(control, index, this);
            }
        }
    }

    public synchronized Preset createPreset() throws StudioException {
        String deviceName = this.getName();
        DeviceProvider provider = this.getProvider();
        String providerName = provider == null ? null : provider.getName();
        Properties properties = this.getProperties();
        HashMap<String, Object> controlMap = new HashMap<String, Object>();
        Control[] controls = this.getControls();
        if (controls != null) {
            for (Control control : controls) {
                if (control == null) continue;
                String controlName = control.getName();
                Object controlValue = control.getValue();
                controlMap.put(controlName, controlValue);
            }
        }
        Preset preset = new Preset();
        preset.setDeviceName(deviceName);
        preset.setProviderName(providerName);
        preset.setProperties(properties);
        preset.setControls(controlMap);
        return preset;
    }

    public synchronized boolean loadPreset(Preset preset) throws StudioException {
        if (preset == null) {
            return false;
        }
        String devName = this.getName();
        if (devName == null) {
            return false;
        }
        if (!devName.equals(preset.getDeviceName())) {
            return false;
        }
        Properties presetProps = preset.getProperties();
        if (presetProps == null) {
            return false;
        }
        Map presetControls = preset.getControls();
        if (presetControls == null) {
            return false;
        }
        this.setPresetName(preset.getPresetName());
        this.setProperties(presetProps);
        int errorCount = 0;
        if (!presetControls.isEmpty()) {
            int num = this.controlList.size();
            for (int i = 0; i < num; ++i) {
                Control control = (Control)this.controlList.get(i);
                String controlName = control.getName();
                if (!presetControls.containsKey(controlName)) continue;
                Object controlValue = presetControls.get(controlName);
                try {
                    control.setValue(controlValue);
                    continue;
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    ++errorCount;
                }
            }
        }
        if (errorCount > 0) {
            throw new StudioException("Error loading preset: " + preset);
        }
        return true;
    }

    public final String getPresetName() {
        return this.presetName;
    }

    public final void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    protected String getTitleOrName() {
        String s = this.title;
        if (s != null && s.length() > 0) {
            return s;
        }
        return this.name;
    }

    public String toString() {
        return super.toString() + "[" + this.getTitleOrName() + "]";
    }
}

